#define COMP_TABLE_LENGTH		(8)

#define CCSDS_PACKET_START		(lg+12+64)
#define CCSDS_DATA_START		(CCSDS_PACKET_START + 10)
#define CCSDS_MD_DATA_START		(CCSDS_DATA_START + COMP_TABLE_LENGTH)

#define CCSDS_PACKET_APID_MSB		(CCSDS_PACKET_START + 0)
#define CCSDS_PACKET_APID_LSB		(CCSDS_PACKET_START + 1)
#define CCSDS_PACKET_SEQUENCE_FLAG_BYTE	(CCSDS_PACKET_START + 2)
#define CCSDS_PACKET_SEQUENCE_COUNT_MSB	(CCSDS_PACKET_START + 2)
#define CCSDS_PACKET_SEQUENCE_COUNT_LSB	(CCSDS_PACKET_START + 3)
#define CCSDS_PACKET_LENGTH_MSB		(CCSDS_PACKET_START + 4)
#define CCSDS_PACKET_LENGTH_LSB		(CCSDS_PACKET_START + 5)
#define CCSDS_PACKET_TIME_BYTE0         (CCSDS_PACKET_START + 6)
#define CCSDS_PACKET_TIME_BYTE1         (CCSDS_PACKET_START + 7)
#define CCSDS_PACKET_TIME_BYTE2         (CCSDS_PACKET_START + 8)
#define CCSDS_PACKET_TIME_BYTE3         (CCSDS_PACKET_START + 9)

#define MD_HEADER_DATATYPE		(CCSDS_MD_DATA_START + 0)
#define MD_PKT_NUM_MSB			(CCSDS_MD_DATA_START + 1)
#define MD_PKT_NUM_MID			(CCSDS_MD_DATA_START + 2)
#define MD_PKT_NUM_LSB			(CCSDS_MD_DATA_START + 3)

#define MD_MAIN_ID_MSB			(CCSDS_MD_DATA_START + 8)
#define MD_MAIN_ID_LSB			(CCSDS_MD_DATA_START + 9)
#define MD_MAIN_SEQUENCE_FLAG_BYTE	(CCSDS_MD_DATA_START + 10)
#define MD_MAIN_SEQUENCE_COUNT_MSB	(CCSDS_MD_DATA_START + 10)
#define MD_MAIN_SEQUENCE_COUNT_LSB	(CCSDS_MD_DATA_START + 11)
#define MD_SUB_ID_MSB			(CCSDS_MD_DATA_START + 14)
#define MD_SUB_ID_LSB			(CCSDS_MD_DATA_START + 15)
#define MD_SUB_SEQUENCE_FLAG_BYTE	(CCSDS_MD_DATA_START + 16)
#define MD_SEQ				(CCSDS_MD_DATA_START + 48)
#define MD_LL				(CCSDS_MD_DATA_START + 49)
#define MD_SEQID_MSB			(CCSDS_MD_DATA_START + 50)
#define MD_SEQID_LSB			(CCSDS_MD_DATA_START + 51)
#define MD_RASID_MSB			(CCSDS_MD_DATA_START + 52)
#define MD_RASID_LSB			(CCSDS_MD_DATA_START + 53)

#define MEM_DUMP_SEQUENCE_FLAG		(CCSDS_DATA_START + 2)
#define MEM_TABLE_NUMBER		(CCSDS_DATA_START + 9)

#define CCSDS_PACKET_LENGTH_TOTAL	((recv_data[CCSDS_PACKET_LENGTH_MSB] * 256) + \
					 (recv_data[CCSDS_PACKET_LENGTH_LSB] + 7))

#define CCSDS_PACKET_SEQUENCE_FLAG	((recv_data[CCSDS_PACKET_SEQUENCE_FLAG_BYTE] >> 6))

#define CCSDS_PACKET_SEQUENCE_COUNT	(((recv_data[CCSDS_PACKET_SEQUENCE_COUNT_MSB] & 0x3F) * 256) + \
                                         (recv_data[CCSDS_PACKET_SEQUENCE_COUNT_LSB]))

#define CCSDS_PACKET_TIME               ((recv_data[CCSDS_PACKET_TIME_BYTE0] << 24) + \
                                         (recv_data[CCSDS_PACKET_TIME_BYTE1] << 16) + \
                                         (recv_data[CCSDS_PACKET_TIME_BYTE2] << 8)  + \
                                         (recv_data[CCSDS_PACKET_TIME_BYTE3]))

#define MD_MAIN_ID			((recv_data[MD_MAIN_ID_MSB] << 8) | \
					 (recv_data[MD_MAIN_ID_LSB]))

#define MD_MAIN_SEQUENCE_FLAG		((recv_data[MD_MAIN_SEQUENCE_FLAG_BYTE] >> 6))

#define MD_SUB_ID			((recv_data[MD_SUB_ID_MSB] << 8) | \
					 (recv_data[MD_SUB_ID_LSB]))

#define MD_SUB_SEQUENCE_FLAG		((recv_data[MD_SUB_SEQUENCE_FLAG_BYTE] >> 6))


#define MD_SEQUENCE_NUMBER		((recv_data[MD_RASID_MSB] * 256) + \
					 (recv_data[MD_RASID_LSB]))

#define MD_RAS_ID			((recv_data[MD_RASID_MSB] << 8) | \
					 (recv_data[MD_RASID_LSB]))

