#!/usr/local/bin/sh

declare -i index

# Set up default parameters for the sdtp fetching
# Antennae:
# USC34	17  (0x11)
# GNA	154 (0x9A)
# GNB	155 (0x9B)
# MSP1	150 (0x96)

band=3:Allband	# Band. Both S and X
sdate=20061017	# Start date of telemetry
edate=$sdate	# End date
ant=17		# Antenna number
stime=0
etime=0
no=0
verbose=0

# Process command line args
while getopts ":vmhna:b:s:e:r:z:" opt; do
    case $opt in
	v  ) verbose=1 ;;
	s  ) sdate=$OPTARG ;;
	e  ) edate=$OPTARG ;;
	m  ) norm=1 ;;
        n  ) no=1 ;;
	h  ) echo 'usage: daily_new [-n] [-a ant] [-b band] [-s start] [-e end] '
	     exit ;;
        a  ) ant=$OPTARG ;;
        b  ) band=$OPTARG ;;
	r  ) stime=$OPTARG ;;
	z  ) etime=$OPTARG ;;
        \? ) echo 'usage: daily_new [-n] [-a ant] [-b band] [-s start] [-e end] '
             exit 1
    esac
done
shift $(($OPTIND - 1))

if [ $verbose = 1 ] ; then
    echo "BAND:  $band"
    echo "ANT:   $ant"
    echo "START: $sdate"
    echo "END:   $edate"
    echo "STIME: $stime"
    echo "ETIME: $etime"
    echo "NO:    $no"
fi

if [ $no = 1 ] ; then
    exit 0
fi

# Remove all the previous sts files in the local directory
# unless told not to
if [ $norm = 0 ] ; then
    /bin/rm ~/localdata/sdtp/late/eis_*
fi

# Start times
stimes='000000 013000 030000 043000 060000 073000 090000 103000
        120000 133000 150000 163000 180000 193000 210000'

# End times
etimes=(013000 030000 043000 060000 073000 090000 103000 120000 \
    133000 150000 163000 180000 193000 210000 223000)

# Index into end times array
set index=0

# Whizz through the start times array and fetch telemetry
for start in $stimes ; do

    ./LATE_NEW <<EOF
$band
$ant
${sdate}$start
${sdate}${etimes[$((index))]}
1:packet
EOF
    set index=$((++index))
done

# Last one uses the edate (next day)
./LATE_NEW <<EOF
$band
$ant
${sdate}223000
${edate}000000
1:packet
EOF
