/**********************************************************
 *          * isas sat-ope.common-ql system *
 *      f.name      : SDTP client libray test program
 *      date        : 2000.09.28 K.Matsuzaki
 *	date	    : 1996.09.14 S.Takahashi
 *	update      :
 *********************************************************/
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<signal.h>
#include	<time.h>
#include	<ctype.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<sys/param.h>
#include	<sys/socket.h>
#include	<sys/fcntl.h>
#include	<netinet/in.h>
#include	<netdb.h>
#include	<errno.h>
#include	<unistd.h>
#include	<syslog.h>

#include	"SDT_all.h"
#include	"SDT_tlm.h"

#include "socket.h"
#include "offsets.h"
#include "error_string.h"

#ifdef ISAS
#define SBAND_ARCHIVE "/san_solar/disk2/home/sbukeis/localdata/sdtp/late/eis_sts_"
#define XBAND_ARCHIVE "/san_solar/disk2/home/sbukeis/localdata/sdtp/late/eis_md_"
#define DUMP_ARCHIVE "/san_solar/disk2/home/sbukeis/localdata/sdtp/late/eis_dmp_"
#define LOG "/san_solar/disk2/home/sbukeis/localdata/log/lates.log"
#else
#define SBAND_ARCHIVE "/data/eis/fm/data/sdtp/eis_sts_"
#define XBAND_ARCHIVE "/data/eis/fm/data/sdtp/eis_md_"
#define DUMP_ARCHIVE "/data/eis/fm/data/sdtp/eis_dmp_"
#define LOG "/data/eis/fm/data/sdtp/reals.log"
#endif

FILE *tlmfile;
FILE *sts_file = (FILE *)NULL, *dmp_file = (FILE *)NULL, *md_file = (FILE *)NULL;
FILE *log_file = (FILE *)NULL;
unsigned long sts_count = 0, sts = 0, dmp = 0, md = 0, hk_sts = 0, hk_428_sts = 0, hk_440_sts = 0, hk_count = 0;
int md_type;
char sts_filename[256], dmp_filename[256], md_filename[256];
char temp_buffer[256];
char temp_md_packet[8096];
char month_str[4];
char day_str[4];
int month,day;
int md_packet_counter = 0;
int md_data_size;

int dump_seq_flag;
int ccsds_seq_flag;

int previous_md_mid = -1;
int current_md_mid;
unsigned short mid;

int first_sts_pkt = 1;
int transmit = 1;

unsigned short	msf;
unsigned short	ssf;
unsigned short	end_msf;
unsigned short	end_ssf;
unsigned short	msc;
unsigned short	ssc;

unsigned short	seq_number, ll_number, sequence_id, raster_id, pkt_type;
unsigned long	pkt_num;

char *sts_type[] = {"STS1", "STS2", "STS3"};

unsigned char end_date[256];

FILE *open_file(FILE *, char *, char *);

char start_tim[15];
unsigned char recv_data[164600];
int lg = 0;

//char *error_str(int err_num);


/* Modification for sirius (start) */
#if 1
static int SDT_tlm_open( 
			int mode,		
			int type,		
			int sat_no,		
			int ant_id,		
			int band,		
			int cpn_type,		
			int cpn_cnt,		
			unsigned char *cpn_data, 
			int blk_no,		
			char *start_time,	
			char *end_time,	
			char *pathno){	

  int ant_band[8][2];
  int ii;
  int ret;

  /* initialize station and telemetry bands */
  for(ii=0;ii<8;ii++){
    ant_band[ii][0] = 0;
    ant_band[ii][1] = 0;
  }

  ant_band[0][0] = ant_id;  
  ant_band[0][1] = band;    

  ret = SDT_tlm_open_sirius( mode, type, sat_no, ant_band, cpn_type, cpn_cnt, cpn_data, blk_no, start_time, end_time, pathno);

  return ret;
}
#endif

/* Modification for sirius (end) */

#define TXTRD(prompt,variable) \
{ \
  variable[0] = '0'; \
  printf(prompt "\n"); \
  printf("  ====> "); \
  fgets(variable,sizeof(variable),stdin); \
}

#define INTRD(prompt,variable) \
{ \
  char _tmp[256]; \
  printf(prompt "\n"); \
  printf("  ====> "); \
  fgets(_tmp,256,stdin); \
  variable = atoi(_tmp); \
}

int main()
{
  /* Parameter setting for SDT_tlm_open() */
  int mode;
  int sat_no;
  int ant_id;
  int band;
  int type;
  char pathno[11];
  //    char start_tim[15];
  char end_tim[15];
  int cpn_type;
  int cpn_cnt;
  int blk_no;
  unsigned char cpnbuf[128];
  Cpn_data  cpndata;

  /* Output */
  int wrtflg;
  char filename[36];
  int fd = 0;
  int dumplevel = 0;
        
  /* Temporal */
  int tmp, iwk, ir;
  char buf[128];

  // EIS vars
  int statusmon_socket_fd;

 // Open the log file
  if((log_file = fopen(LOG, "a")) == (FILE *)NULL) {
      fprintf(stderr, "Bad log file open\n");
  }


#ifdef ISAS
  fprintf(stderr, "Compiled for ISAS\n");
#else
  fprintf(stderr, "Compiled for MSSL\n");
#endif

  // EIS stuff
  if((statusmon_socket_fd = tcp_open("localhost",
				     (char *)NULL,
				     10006)) < 0) {
    fprintf(stderr,"Connect error (%d)\n",
	    statusmon_socket_fd);

    transmit = 0;
  }
  else 
    fprintf(stdout, "Connected OK\n");

  /* transfer mode (1:REAL 2:LATE BUFFERING) */
  ///  mode = 1;
  mode = 2;

#if 0
  TXTRD("Satellite Number (0:SOLAR-B(*) 1:ASTRO-E 2:MUSES-C 3:ASTRO-F)", buf);
  if (buf[0] =='\n') sat_no = SOLARB; else /* default for dummy data */
    if (buf[0] == '0') sat_no = SOLARB; else
      if (buf[0] == '1') sat_no = ASTROE; else
	if (buf[0] == '2') sat_no = MUSESC; else
	  if (buf[0] == '3') sat_no = ASTROF; else
	    goto error;
#else
  sat_no = SOLARB;
#endif

#if 1
  TXTRD("Telemetry band (1:S-BAND(*) 2:X-BAND 3:Allband)", buf);
  if (buf[0] =='\n') band = ALLBAND;
  else if (buf[0] == '1') band = SBAND;
  else if (buf[0] == '2') band = XBAND;
  else if (buf[0] == '3') band = ALLBAND;
  else goto error;
#else
  band = SBAND;
#endif

#if 1
  TXTRD("Antenna Number 1:KSC20 2:KSC34 3:UDSC64 4:C-A 5:C-B(*) 6:SVAL 7:GNA 8:GNB 9:MSP1 A:Merge B:SNT1", buf);
  if (buf[0] =='\n') ant_id = ALLANT;
  else if (buf[0] == '1') ant_id = 16;
  else if (buf[0] == '2') ant_id = 17;
  else if (buf[0] == '3') ant_id = 32;
  else if (buf[0] == '4') ant_id = 128;
  else if (buf[0] == '5') ant_id = 129;
  else if (buf[0] == '6') ant_id = 0x61;
  else if (buf[0] == '7') ant_id = 0x9A;
  else if (buf[0] == '8') ant_id = 0x9B;
  else if (buf[0] == '9') ant_id = 0x96;
  else if (buf[0] == 'B') ant_id = 0x94;
  else if (buf[0] == 'A') ant_id = 240;
  else goto error;
#else
  ant_id = 128;
#endif

#if 0
  TXTRD("Antenna Number (1:KSC20 2:KSC34 3:UDSC64 4:C-A 5:C-B(*) 6:KSC20+34 7:SVAL 8:WPS+CUS+GN) 9:Merge", buf);
  if (buf[0] =='\n') ant_id = ALLANT;
  else if (buf[0] == '1') ant_id = 16;
  else if (buf[0] == '2') ant_id = 17;
  else if (buf[0] == '3') ant_id = 32;
  else if (buf[0] == '4') ant_id = 128;
  else if (buf[0] == '5') ant_id = 129;
  else if (buf[0] == '6') ant_id = (0x10|0x11);
  else if (buf[0] == '7') ant_id = 0x61;
  //  else if (buf[0] == '8') ant_id = (0x60|0x9A|0x9B);
  else if (buf[0] == '8') ant_id = 0x9b;
  else if (buf[0] == '9') ant_id = 240;
  else goto error;
#endif


    //if (buf[0] =='\n') ant_id = 129; else /* default for dummy data */
  INTRD("Data Specification (1:Pass Number 2:Time(*))", type);
  if (type == 0) type = 2; /* default for dummy data */
  if (type == 1) {
    printf("Pass Number\n");
    printf("       [YYMMDDxxxx]\n");
    printf("  ====> ");
    fgets(pathno,sizeof(pathno),stdin);
    printf("pathno=%s\n",pathno);
  }
  else if (type==2){
    printf("Start Time\n");
    printf("       [YYYYMMDDhhmmss](*20010827100900)\n");
    printf("  ====> ");
    fgets(start_tim,sizeof(start_tim),stdin);
      
    if(start_tim[0] == '\n') {
      strcpy(start_tim, "20010827100900");
      fprintf(stdout, "DEFAULT START TIME\n");
    }
    if (start_tim[0] == 'x') exit(0);
    ir = strncmp(&start_tim[4],"1231",4);
    if (ir > 0) goto error;
    ir = strncmp(&start_tim[8],"235959",6);
    if (ir > 0) goto error;

    //        fgets(end_tim,sizeof(end_tim),stdin);
    fgets(buf, sizeof(buf), stdin);	// Eat spare \n

    printf("End Time\n");
    printf("       [YYYYMMDDhhmmss](*20010827113200)\n");
    printf("  ====> ");
    fgets(end_tim,sizeof(end_tim),stdin);
    if(end_tim[0] == '\n') {
      strcpy(end_tim, "20010827113200");
      fprintf(stdout, "DEFAULT END TIME\n");
    }
    if (end_tim[0] == 'x') exit(0);
    if (end_tim[0] == 0x00 || end_tim[0] == 0x20) {
      memset(end_tim,0x00,15);  /* NULL */
    }
    ir = strncmp(&end_tim[4],"1231",4);
    if (ir > 0) goto error;
    ir = strncmp(&end_tim[8],"235959",6);
    if (ir > 0) goto error;      
  }

#if 1
  TXTRD("CPN service (0:two packets 1:packet(*) 2:virtual channel 3:transfer frame) ", buf);
#else
  buf[0] = '1';
#endif

  if (buf[0] =='\n') buf[0] = '1'; /* default for dummy data */
  if (buf[0] == '0') {
    cpn_type = 1;
    /* # of CPN service */
    cpn_cnt = 2;
    /* CPN service setting */	

    INTRD("No.1 APID (Binary)", iwk);  
    cpndata.pc_id[2] = iwk>>8;
    cpndata.pc_id[3] = iwk;
      
    INTRD("No.1 APID mask ( 0x7ff => 2047 )", iwk); 
    cpndata.pc_id[0] = iwk>>8;
    cpndata.pc_id[1] = iwk;
      
    INTRD("No.1 VCID (Binary)", iwk);
    cpndata.vc_ch[1] = iwk;
      
    INTRD("No.1 VCID mask ( 0x3f => 63 )", iwk);
    cpndata.vc_ch[0] = iwk;
       
    memcpy(&cpnbuf[0], &cpndata, sizeof( Cpn_data ));

    INTRD("No.2 APID (Binary)", iwk);
    cpndata.pc_id[2] = iwk>>8;
    cpndata.pc_id[3] = iwk;
      
    INTRD("No.2 APID mask ( 0x7ff => 2047 )", iwk);
    cpndata.pc_id[0] = iwk>>8;
    cpndata.pc_id[1] = iwk;
      
    INTRD("No.2 VCID (Binary)", iwk);
    cpndata.vc_ch[1] = iwk;
      
    INTRD("No.2 VCID mask ( 0x3f => 63 )", iwk);
    cpndata.vc_ch[0] = iwk;
            
    memcpy(&cpnbuf[sizeof( Cpn_data )], &cpndata, sizeof( Cpn_data ));      
  }
  else if (buf[0] == '1') {
    /* CPN service setting */
    cpn_type = 1;
    /* # of CPN service */
    cpn_cnt = 1;

    ////    INTRD("APID (Binary)", iwk);
    iwk = atoi("\n");
    cpndata.pc_id[2] = iwk>>8;
    cpndata.pc_id[3] = iwk;

    ////    INTRD("APID mask ( 0x7ff => 2047 )", iwk);
    iwk = atoi("\n");
    cpndata.pc_id[0] = iwk>>8;
    cpndata.pc_id[1] = iwk;
      
    ////    INTRD("VCID (Binary)", iwk);
    iwk = atoi("\n");
    cpndata.vc_ch[1] = iwk;
      
    ////    INTRD("VCID mask ( 0x3f => 63 )", iwk);
    iwk = atoi("\n");
    cpndata.vc_ch[0] = iwk;

    memcpy(&cpnbuf[0], &cpndata, sizeof( Cpn_data ));
  }
  else if (buf[0] == '2') {
    cpn_type = 2;
    /* # of CPN service */
    cpn_cnt = 1;
    /* CPN service setting */

    cpndata.pc_id[0] = 0x00;
    cpndata.pc_id[1] = 0x00;
    cpndata.pc_id[2] = 0x00;
    cpndata.pc_id[3] = 0x00;

    INTRD("VCID (Binary)", iwk);
    cpndata.vc_ch[1] = iwk;

    INTRD("VCID mask ( 0x3f => 63 )", iwk);
    cpndata.vc_ch[0] = iwk;
      
    memcpy(&cpnbuf[0], &cpndata, sizeof( Cpn_data ));
  }
  else if (buf[0] == '3') {
    cpn_type = 8;
    /* # of CPN service */
    cpn_cnt = 1;
    /* CPN service setting */

    cpndata.pc_id[0] = 0x00;
    cpndata.pc_id[1] = 0x00;
    cpndata.pc_id[2] = 0x00;
    cpndata.pc_id[3] = 0x00;
      
    INTRD("VCID (Binary)", iwk);
    cpndata.vc_ch[1] = iwk;

    INTRD("VCID mask ( 0x3f => 63 )", iwk);
    cpndata.vc_ch[0] = iwk;
      
    memcpy(&cpnbuf[0], &cpndata, sizeof( Cpn_data ));      
  }
  else {
    goto error;
  }

  INTRD("# of blocks (frame or packet) per request (*16) ", blk_no);
  if (blk_no == 0) blk_no = 16; /* default for dummy data */
  // Hard coding this because can't seem to change it otherwise
  blk_no = 16;

#if 0
  if (blk_no > 10) goto error;
#endif

#if 1
  INTRD("Save received data (1:yes 2:no(*))", tmp);
#endif

  if (tmp == 1) {
    printf("\n");
    printf("File name (/data/wk/... )\n");
    printf("Default /data/wk/TLMDMP \n");
    printf("  ====> ");
    fgets(buf,sizeof(buf),stdin);
    ir = strlen(buf);
    if (ir <= 0) strcpy(buf, "TLMDMP");
    sprintf(filename, "/data/wk/%s",buf);
    wrtflg = 1;
  }else{
    wrtflg = 0;
  }

  /** OPEN data file **/
  if (wrtflg == 1) {
    fd = open(filename, O_WRONLY|O_TRUNC|O_CREAT,0666);
    if (fd == -1) printf("Data file OPEN ERROR[%d]\n",errno);
  }
#if 1
  INTRD("Dump data (0:Summary(*), 1:CcsdsHeader 2:CcsdsPacket, 3:All)", dumplevel);
#endif

  /* Call SDTP telemetry function */

#if 1
  fprintf( stderr, "Call SDT_tlm_open() Mode = [%d]\n", mode );
  fflush( stderr );
  fprintf( stderr, "Call SDT_tlm_open() Type = [%d]\n", type );
  fflush( stderr );
  fprintf( stderr, "Call SDT_tlm_open() Satellite Number = [%d]\n", sat_no );
  fflush( stderr );
  fprintf( stderr, "Call SDT_tlm_open() Antenna Number   = [%d]\n", ant_id );
  fflush( stderr );
  fprintf( stderr, "Call SDT_tlm_open() Telemetry Band   = [%d]\n", band );
  fflush( stderr );
  fprintf( stderr, "Call SDT_tlm_open() CPN service = [%d]\n", cpn_type );
  fprintf( stderr, "    vc_ch[%2x%2x]\n", cpndata.vc_ch[0],cpndata.vc_ch[1]);
  fprintf( stderr, "    pc_id[%2x%2x%2x%2x]\n", cpndata.pc_id[0],cpndata.pc_id[1],cpndata.pc_id[2],cpndata.pc_id[3]);
  fflush( stderr );
  fprintf( stderr, "Call SDT_tlm_open() # of blocks = [%d]\n", blk_no );
  fflush( stderr );
#endif

  if(log_file) {
    fprintf( log_file, "Call SDT_tlm_open() Mode = [%d]\n", mode );
    fflush( log_file );
    fprintf( log_file, "Call SDT_tlm_open() Type = [%d]\n", type );
    fflush( log_file );
    fprintf( log_file, "Call SDT_tlm_open() Satellite Number = [%d]\n", sat_no );
    fflush( log_file );
    fprintf( log_file, "Call SDT_tlm_open() Antenna Number   = [%d]\n", ant_id );
    fflush( log_file );
    fprintf( log_file, "Call SDT_tlm_open() Telemetry Band   = [%d]\n", band );
    fflush( log_file );
    fprintf(log_file, "Start time = [%s]\n", start_tim);
    fprintf(log_file, "End   time = [%s]\n", end_tim);
    fprintf( log_file, "Call SDT_tlm_open() CPN service = [%d]\n", cpn_type );
    fprintf( log_file, "    vc_ch[%2x%2x]\n", cpndata.vc_ch[0],cpndata.vc_ch[1]);
    fprintf( log_file, "    pc_id[%2x%2x%2x%2x]\n", cpndata.pc_id[0],cpndata.pc_id[1],cpndata.pc_id[2],cpndata.pc_id[3]);
    fflush( log_file );
    fprintf( log_file, "Call SDT_tlm_open() # of blocks = [%d]\n", blk_no );
    fflush( log_file );
  }

  ir = SDT_tlm_open( mode, type, sat_no, ant_id, band, cpn_type, cpn_cnt, &cpnbuf[0], blk_no, start_tim, end_tim, pathno);
  if( ir != 0 ){
    /* error */
    fprintf( stderr, "SDT_tlm_open() Error [%d]\t", ir );
    fprintf( stderr, "%s\n", error_str(ir));
    fflush( stderr );
    exit( -1 );
  }

  while( 1 ){
    int pdu_type;
    int recv_len;
    int ret;
    unsigned char vcwk[2];
    	
    /* Initialize Receive Buffer */
    memset( recv_data, 0, sizeof( recv_data ));
    ret = SDT_tlm_recv( &pdu_type, recv_data, &recv_len );
    if( ret < 0 ){
      /* error */
      fprintf( stderr, "SDT_tlm_recv() Error [%d]\t", ret );
      fprintf( stderr, "%s\n", error_str(ret));
      fflush( stderr );
      exit( -2 );
    }

    if( ret != 1 ){
      fprintf( stdout, "receive PDU type  [%d]\t", pdu_type );
      fprintf( stdout, "receive length [%d]\n", recv_len );

      if( pdu_type == 0 ){
	int i;
	lg = 0;
	for (i=0;i<blk_no;i++) {
	  if (recv_data[lg] == 0x01) {
	    printf("Received first data\n");
	    break;
	  }
	  else if (recv_data[lg] == 0x02) {
	    if (cpn_type == 8) {
	      vcwk[0] = 0x3f & recv_data[12+64+4+1+lg];
	    }
	    else if (cpn_type == 2) {
	      vcwk[0] = 0x3f & recv_data[12+64+1+lg];
	    }
	    else {
	      vcwk[0] = 0x07 & recv_data[12+64+lg];
	      vcwk[1] = 0xff & recv_data[12+64+1+lg];
	    }
	  }
	  else if (recv_data[lg] == 0x04) {
	    printf("Received last data\n");
	    break;
	  }
	  else {
	    /* printf("Data Identification Error \n"); */
	    break;
	  }
	  {
	    union word {
	      unsigned int	iwd;
	      char cwd[4];
	    } wd;
	    int r_lg;
	    /*		int j; */

	    int txlen;	// EIS
	    /*		    int txlen1; */
	    unsigned short sts_type_offset;

	    // EIS stuff
	    unsigned short APID = (vcwk[0] << 8) | vcwk[1];

	    // Copy record length from the Information Field
	    memcpy(&wd.cwd,&recv_data[8+lg], 4);

	    // Assign record length to r_lg
	    r_lg = ntohl( wd.iwd );

	    fprintf( stdout, "Data [%02d/%02d] : ", 
		     i+1, blk_no );

	    // Print out time fields of the attached Data
	    fprintf( stdout, "[%.2x%.2x/%.2x%.2x ", 
		     recv_data[14+lg], recv_data[15+lg], 
		     recv_data[16+lg], recv_data[17+lg] );
	    fprintf( stdout, "%.2x:%.2x:%.2x:%.2x:%.2x]", 
		     recv_data[18+lg], recv_data[19+lg],
		     recv_data[20+lg], recv_data[21+lg], recv_data[22+lg]);

	    if (cpn_type == 8 || cpn_type == 2) {
	      fprintf( stdout, " : VCID [%.2x]\n", 
		       vcwk[0]);
	    }
	    else {
	      fprintf( stdout, " : VCID [%.2x] : APID [%.2x%.2x]\t",
		       recv_data[2+lg], vcwk[0],vcwk[1]);
	    }
	    fflush( stdout );

	    if((APID == 0x5c4) ||	// status 1
	       (APID == 0x5c6) ||	// status 2
	       (APID == 0x5c8) ||	// status 3
	       (APID == 0x1ca) ||	// md
	       (APID == 0x1cb) ||	// md
	       (APID == 0x320) ||	// dump
	       (APID == 0x428) ||	// hk2
	       (APID == 0x440) ||	// hk3
	       (APID == 0x420)) {	// hk1

	      ////	      transmit = 1;
	      transmit = (statusmon_socket_fd != 0);

	      txlen = CCSDS_PACKET_LENGTH_TOTAL;

	      switch(APID) {
		    
	      case 0x5c4 :	// status 1
	      case 0x5c6 :	// status 2
	      case 0x5c8 :	// status 3
		sts_type_offset = APID - 0x5C4;
		if(sts_type_offset) sts_type_offset /= 2;
		if(first_sts_pkt) {
		  first_sts_pkt = 0;
		  sts_file = open_file(sts_file, SBAND_ARCHIVE, sts_filename);
		  fprintf( log_file, "First packet %.2x%.2x/%.2x%.2x ", 
			   recv_data[14+lg], recv_data[15+lg], 
			   recv_data[16+lg], recv_data[17+lg] );
		  fprintf( log_file, "%.2x:%.2x:%.2x:%.2x:%.2x]\n", 
			   recv_data[18+lg], recv_data[19+lg],
			   recv_data[20+lg], recv_data[21+lg], recv_data[22+lg]);
		  fflush(log_file);
		}
		sts_count++;
		// + 7 gives a packet length of 0x6E (110)
		// => primary (6) + secondary (4) + user (100) = 110
		// pkt len actually contains secondary + user - 1 = 0x67 (103)
		//txlen = recv_data[lg+12+64+5] + 7; 
		//txlen = recv_data[CCSDS_PACKET_LENGTH_LSB] + 7;

		(void)memcpy(end_date, &recv_data[14+lg], 9);

		fprintf(stdout, "[%ld] %s : LEN %04X (%d)\t", sts_count, sts_type[sts_type_offset], txlen,txlen);
		if(sts_file)
		  fwrite((void *)&recv_data[CCSDS_PACKET_START], sizeof(unsigned char), txlen, sts_file);
		break;

		// Mission data packets
	      case 0x1ca :
	      case 0x1cb :
		msf = MD_MAIN_SEQUENCE_FLAG;
		ssf = MD_SUB_SEQUENCE_FLAG;
		mid = MD_MAIN_ID;

		//		sequence_number = MD_SEQUENCE_NUMBER;
		//		ll_number       = MD_LL_NUMBER;
		//		sequence_id     = MD_SEQUENCE_ID;
		//		raster_id       = MD_RASTER_ID;

		transmit = 0;	// Don't send to status monitor
		ccsds_seq_flag = CCSDS_PACKET_SEQUENCE_FLAG;

#ifdef DEBUGGING
		// Better to look at ccsds sequence flag == 1 then look at msf,ssf
		if(ccsds_seq_flag == 1) {
		  fprintf(stdout, "MD LEN %04X (%d) mid,msf,ssf (%u,%u,%u)\t",
			  txlen, txlen, mid, msf,ssf);
		  current_md_mid = MD_MAIN_ID;

		  if(msf == 3) {
		    if((ssf == 1) || (ssf == 3)) {
		      end_ssf = (ssf == 1) ? 2 : 3; end_msf = 3;
		    }
		    else {
		      end_msf = 0xFF; end_ssf = 0xFF;
		    }
		  }
		  else if(msf == 1) {
		    if((ssf == 1) || (ssf == 3)) {
		      end_ssf = (ssf == 1) ? 2 : 3; end_msf = 2;
		    }
		    else {
		      end_msf = 0xFF; end_ssf = 0xFF;
		    }
		  }
		  else {
		    end_msf = 0xFF; end_ssf = 0xFF;
		  }

		  if(current_md_mid != previous_md_mid) {
		    previous_md_mid = current_md_mid;
		    md_file = open_file(md_file, XBAND_ARCHIVE, md_filename);
		    if(log_file) {
		      fprintf(log_file, "%s %04X %u %u (%u %u)\n", md_filename, mid, msf, ssf, end_msf, end_ssf);
		      fflush(log_file);
		    }
		  }
		}
		else {
		  fprintf(stdout, "MD LEN %04X (%d)\t", txlen, txlen);
		}
#else
		fprintf(stdout, "MD LEN %04X (%d)\t", txlen, txlen);
#endif

		fprintf(stdout, "CCSDS [%02X]\t", ccsds_seq_flag);
		fflush(stdout);
		if(md_file)
		  fwrite((void *)&recv_data[CCSDS_PACKET_START], sizeof(unsigned char), txlen, md_file);
		break;

	      case 0x0420 :
	      case 0x0428 :
	      case 0x0440 :
		if(first_sts_pkt) {
		  first_sts_pkt = 0;
		  sts_file = open_file(sts_file, SBAND_ARCHIVE, sts_filename);
		  fprintf( log_file, "First packet %.2x%.2x/%.2x%.2x-", 
			   recv_data[14+lg], recv_data[15+lg], 
			   recv_data[16+lg], recv_data[17+lg] );
		  fprintf( log_file, "%.2x:%.2x:%.2x:%.2x:%.2x\n", 
			   recv_data[18+lg], recv_data[19+lg],
			   recv_data[20+lg], recv_data[21+lg], recv_data[22+lg]);

		  fflush(log_file);
		}
		if(APID == 0x0420) { ++hk_sts; hk_count = hk_sts; }
		else if(APID == 0x0428) { ++hk_428_sts; hk_count = hk_428_sts; }
		else { ++hk_440_sts; hk_count = hk_440_sts; }
		//		hk_sts++;
		fprintf(stdout, "[%ld] S/C : LEN %04X (%d)\t", hk_count, txlen,txlen);

		(void)memcpy(end_date, &recv_data[14+lg], 9);
		/*
		sprintf(end_date,
			"%.2x%.2x/%.2x%.2x-%.2x:%.2x:%.2x:%.2x:%.2x", 
			recv_data[14+lg], recv_data[15+lg], recv_data[16+lg], recv_data[17+lg],
			recv_data[18+lg], recv_data[19+lg], recv_data[20+lg], recv_data[21+lg], recv_data[22+lg]);
		*/
		if(sts_file)
		  fwrite((void *)&recv_data[lg+12+64],sizeof(unsigned char),txlen,sts_file);
		break;

	      default :
		fprintf(stdout,"DUMP DATA : LEN %04X (%d) ", txlen, txlen);
		dump_seq_flag = (recv_data[MEM_DUMP_SEQUENCE_FLAG]  & 0xC0);
		fprintf(stdout, "SEQ [%02X] ", dump_seq_flag);
		fprintf(stdout,"MEMORY ID [%02X]\t", recv_data[lg+12+64+9]);

		if((recv_data[MEM_TABLE_NUMBER] & 0xF0) != 0xE0) {
		  transmit = 0;
		  txlen = 0;
		  break;	// Not eis dump
		}

		// if seq_flag == 1 or 3, open new file
		// else if seq_flag == 2 close file after writing
		// if 0 just write
		switch(dump_seq_flag) {
		case 0x40 :	// 1
		case 0xC0 :	// 3
		  dmp_file = open_file(md_file, DUMP_ARCHIVE, dmp_filename);
		  if(dmp_file) {
		    fwrite((void *)&recv_data[lg+12+64],sizeof(unsigned char),txlen,dmp_file);
		    fflush(dmp_file);
		  }

		  break;

		case 0x80 :	// 2
		  if(dmp_file) {
		    fwrite((void *)&recv_data[lg+12+64],sizeof(unsigned char),txlen,dmp_file);
		    fflush(dmp_file);
		  }
		  break;

		case 0 :
		  if(dmp_file) {
		    fwrite((void *)&recv_data[lg+12+64],sizeof(unsigned char),txlen,dmp_file);
		    fflush(dmp_file);
		  }
		  break;
		default :
		  break;
		}
		//		      txlen = 0;
		break;
	      }
	      if(txlen) {
		if(transmit)
		  write(statusmon_socket_fd, &recv_data[CCSDS_PACKET_START], txlen);
	      }

	      //		  } // if(dumplevel >= 1) {
	      // mcrw 10/08/05
	      // Moved to be at the same level as r_lg = ntohl( wd.iwd );
	      lg = lg + r_lg + 12;
	      fprintf(stdout, "\n");
	    }	// if(APID == EIS APIDS)
	    else {
	      fprintf(stdout, "\n");
	      lg = lg + r_lg + 12;
	    }
	  }	// local decs    
	}	// for(i=0;i<blk_no;i++)
      }	// if(pdu_type == 0)
	  
      if (wrtflg == 1) {
	if ( pdu_type == 0 ) {
	  ir = write(fd,recv_data,recv_len);
	  if( ir == -1 ){
	    printf("TEST FILE WRITE ERROR[%d]\n",errno);
	  }
	}
      }
	  
    }	// if(ret != -1)
	
    if( ret == SDT_RCVFREEREQ ){
      fprintf(stdout, "Received connection close request \n");
      fflush(stdout);
      fprintf(stderr, "Received connection close request \n");
      fprintf( log_file, "Received connection close request \n");
      fprintf( log_file, "Last packet %.2x%.2x/%.2x%.2x-%.2x:%.2x:%.2x:%.2x:%.2x\n", 
	       end_date[0], end_date[1], 
	       end_date[2], end_date[3],
	       end_date[4], end_date[5],
	       end_date[6], end_date[7], end_date[8]);
      //      fprintf( log_file, "Last packet %s\n", end_date);
      fflush( log_file );
      break;
    }
  }
    
  /* Close connection */
  fprintf(stderr, "Closing connection\n");
  ir = SDT_tlm_close();
  if( ir != 0 ) {
    /* Error */
    fprintf( stderr, "SDT_tlm_close() Error [%d]\n", ir );
    fflush( stderr );
    fprintf( log_file, "SDT_tlm_close() Error [%d]\n", ir );
      fprintf( log_file, "Last packet %.2x%.2x/%.2x%.2x-%.2x:%.2x:%.2x:%.2x:%.2x\n", 
	       end_date[0], end_date[1], 
	       end_date[2], end_date[3],
	       end_date[4], end_date[5],
	       end_date[6], end_date[7], end_date[8]);
      //    fprintf( log_file, "Last packet %s\n", end_date);
    fflush( log_file );
    exit( -3 );
  }
  if (wrtflg == 1) close( fd );
  if(statusmon_socket_fd) close(statusmon_socket_fd);
  fprintf(stderr, "Exiting\n");
  exit(0);
    
 error:    
  printf("** input error\n");
  fprintf( log_file, "** input error\n");
  fflush( log_file );
  if(statusmon_socket_fd) close(statusmon_socket_fd);
  exit(-4);
}


FILE *open_file(FILE *file_pointer, char *new_path, char *fname) {

  FILE *fp = (FILE *)NULL;
  char temp_buffer[256];
  char month_str[4];
  char day_str[4];
  char filename[256];

  if(file_pointer != (FILE *)NULL) {
    fflush(file_pointer);
    fclose(file_pointer);
  }
  
  strncpy(month_str, &start_tim[4],2);
  strncpy(day_str, &start_tim[6],2);
  // yr yr mnth day hr min sec tenths milli
  // 20 01 08 28 10 30 00
  sprintf(temp_buffer,
	  "%.2x%.2x%.2s%.2s_%.2x%.2x%.2x%.2x%.2x",
	  recv_data[14+lg],
	  recv_data[15+lg],
	  month_str,
	  day_str,
	  recv_data[18+lg],	// hour
	  recv_data[19+lg],	// min
	  recv_data[20+lg],	// sec
	  recv_data[21+lg],	// tenths
	  recv_data[22+lg]);	// milli
  filename[0] = '\0';
  strcpy(filename, new_path);
  strcat(filename, temp_buffer);
  fname[0] = '\0';
  strcat(fname, filename);
  fprintf(stderr,"FILENAME = %s\n",filename);
  fflush(stderr);
  
  if((fp = fopen(filename,"w")) == (FILE *)NULL) {
    fprintf(stderr,"Bad file open\n");
    //    exit(-99);
    return (FILE *)NULL;
  }
  return fp;
}
