/**********************************************************
 *          * isas sat-ope.common-ql system *
 *      f.name      : SDTP client libray test program
 *      date        : 2000.09.28 K.Matsuzaki
 *	date	    : 1996.09.14 S.Takahashi
 *	update      :
 *********************************************************/
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<signal.h>
#include	<time.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<sys/param.h>
#include	<sys/socket.h>
#include	<sys/fcntl.h>
#include	<netinet/in.h>
#include	<netdb.h>
#include	<errno.h>
#include	<unistd.h>
#include	<syslog.h>

#include	"SDT_all.h"
#include	"SDT_tlm.h"

/* Modification for sirius (start) */

static int SDT_tlm_open( 
  int mode,		
  int type,		
  int sat_no,		
  int ant_id,		
  int band,		
  int cpn_type,		
  int cpn_cnt,		
  unsigned char *cpn_data, 
  int blk_no,		
  char *start_time,	
  char *end_time,	
  char *pathno){	

  int ant_band[8][2];
  int ii;
  int ret;

  /* initialize station and telemetry bands */
  for(ii=0;ii<8;ii++){
    ant_band[ii][0] = 0;
    ant_band[ii][1] = 0;
  }

  ant_band[0][0] = ant_id;  
  ant_band[0][1] = band;    

  ret = SDT_tlm_open_sirius( mode, type, sat_no, ant_band, cpn_type, cpn_cnt, cpn_data, blk_no, start_time, end_time, pathno);

  return ret;
}

/* Modification for sirius (end) */

#define TXTRD(prompt,variable) \
{ \
  variable[0] = '0'; \
  printf(prompt "\n"); \
  printf("  ====> "); \
  fgets(variable,sizeof(variable),stdin); \
}

#define INTRD(prompt,variable) \
{ \
  char _tmp[256]; \
  printf(prompt "\n"); \
  printf("  ====> "); \
  fgets(_tmp,256,stdin); \
  variable = atoi(_tmp); \
}

int main()
{
    /* Parameter setting for SDT_tlm_open() */
    int mode;
    int sat_no;
    int ant_id;
    int band;
    int type;
    char pathno[11];
    char start_tim[15];
    char end_tim[15];
    int cpn_type;
    int cpn_cnt;
    int blk_no;
    unsigned char cpnbuf[128];
    Cpn_data  cpndata;

    /* Output */
    int wrtflg;
    char filename[36];
    int fd = 0;
        
    /* Temporal */
    int tmp, iwk, ir;
    char buf[128];
	
    /* transfer mode (1:REAL 2:LATE BUFFERING) */
    mode = 2;

    /* Satellite */ 
    sat_no = SOLARB;
      
    TXTRD("Telemetry band (1:S-BAND 2:X-BAND(*))", buf);
    if (buf[0] =='\n') band = ALLBAND; else /* default for dummy data */
    if (buf[0] == '1') band = SBAND; else
    if (buf[0] == '2') band = XBAND; else
        goto error;

    TXTRD("Antenna Number (1:KSC20 2:KSC34 3:UDSC64 4:C-A(*) 5:C-B)", buf);
    if (buf[0] =='\n') ant_id = ALLANT; else /* default for dummy data */
    if (buf[0] == '1') ant_id = 16; else
    if (buf[0] == '2') ant_id = 17; else
    if (buf[0] == '3') ant_id = 32; else
    if (buf[0] == '4') ant_id = 128; else
    if (buf[0] == '5') ant_id = 129; else
      goto error;

    INTRD("Data Specification (1:Pass Number 2:Time(*))", type);
    if (type == 0) type = 2; /* default for dummy data */
    if (type == 1) {
      printf("Pass Number\n");
      printf("       [YYMMDDxxxx]\n");
      printf("  ====> ");
      fgets(pathno,sizeof(pathno),stdin);
         printf("pathno=%s\n",pathno);
    }
    else if (type==2){
      printf("Start Time\n");
      printf("       [YYYYMMDDhhmmss](*20060401000000)\n");
      printf("  ====> ");
      gets(start_tim);
      
      if(start_tim[0] == '\0') strcpy(start_tim, "20060401000000");
      if (start_tim[0] == 'x') exit(0);
      ir = strncmp(&start_tim[4],"1231",4);
      if (ir > 0) goto error;
      ir = strncmp(&start_tim[8],"235959",6);
      if (ir > 0) goto error;

      printf("End Time\n");
      printf("       [YYYYMMDDhhmmss](*20060401235959)\n");
      printf("  ====> ");
      gets(end_tim);

      if(end_tim[0] == '\0') strcpy(end_tim, "20060401235959");
      printf("        %s\n",end_tim);

      if (end_tim[0] == 'x') exit(0);
      if (end_tim[0] == 0x00 || end_tim[0] == 0x20) {
        memset(end_tim,0x00,15);  /* NULL */
      }
      ir = strncmp(&end_tim[4],"1231",4);
      if (ir > 0) goto error;
      ir = strncmp(&end_tim[8],"235959",6);
      if (ir > 0) goto error;      
    }
    
    TXTRD("CPN service (0:two packets 1:packet(*) 2:virtual channel 3:transfer frame) ", buf);
    if (buf[0] =='\n') buf[0] = '1'; /* default for dummy data */
    if (buf[0] == '0') {
      cpn_type = 1;
	/* # of CPN service */
      cpn_cnt = 2;
	/* CPN service setting */	

      INTRD("No.1 APID (Binary)", iwk);  
      cpndata.pc_id[2] = iwk>>8;
      cpndata.pc_id[3] = iwk;
      
      INTRD("No.1 APID mask ( 0x7ff => 2047 )", iwk); 
      cpndata.pc_id[0] = iwk>>8;
      cpndata.pc_id[1] = iwk;
      
      INTRD("No.1 VCID (Binary)", iwk);
      cpndata.vc_ch[1] = iwk;
      
      INTRD("No.1 VCID mask ( 0x3f => 63 )", iwk);
      cpndata.vc_ch[0] = iwk;
       
      memcpy(&cpnbuf[0], &cpndata, sizeof( Cpn_data ));

      INTRD("No.2 APID (Binary)", iwk);
      cpndata.pc_id[2] = iwk>>8;
      cpndata.pc_id[3] = iwk;
      
      INTRD("No.2 APID mask ( 0x7ff => 2047 )", iwk);
      cpndata.pc_id[0] = iwk>>8;
      cpndata.pc_id[1] = iwk;
      
      INTRD("No.2 VCID (Binary)", iwk);
      cpndata.vc_ch[1] = iwk;
      
      INTRD("No.2 VCID mask ( 0x3f => 63 )", iwk);
      cpndata.vc_ch[0] = iwk;
            
      memcpy(&cpnbuf[sizeof( Cpn_data )], &cpndata, sizeof( Cpn_data ));      
    }
    else if (buf[0] == '1') {
	/* CPN service setting */
      cpn_type = 1;
	/* # of CPN service */
      cpn_cnt = 1;

      INTRD("APID (Binary)", iwk);
      cpndata.pc_id[2] = iwk>>8;
      cpndata.pc_id[3] = iwk;

      INTRD("APID mask ( 0x7ff => 2047 )", iwk);
      cpndata.pc_id[0] = iwk>>8;
      cpndata.pc_id[1] = iwk;
      
      INTRD("VCID (Binary)", iwk);
      cpndata.vc_ch[1] = iwk;
      
      INTRD("VCID mask ( 0x3f => 63 )", iwk);
      cpndata.vc_ch[0] = iwk;

      memcpy(&cpnbuf[0], &cpndata, sizeof( Cpn_data ));
    }
    else if (buf[0] == '2') {
      cpn_type = 2;
	/* # of CPN service */
      cpn_cnt = 1;
	/* CPN service setting */

      cpndata.pc_id[0] = 0x00;
      cpndata.pc_id[1] = 0x00;
      cpndata.pc_id[2] = 0x00;
      cpndata.pc_id[3] = 0x00;

      INTRD("VCID (Binary)", iwk);
      cpndata.vc_ch[1] = iwk;

      INTRD("VCID mask ( 0x3f => 63 )", iwk);
      cpndata.vc_ch[0] = iwk;
      
      memcpy(&cpnbuf[0], &cpndata, sizeof( Cpn_data ));
    }
    else if (buf[0] == '3') {
      cpn_type = 8;
	/* # of CPN service */
      cpn_cnt = 1;
	/* CPN service setting */

      cpndata.pc_id[0] = 0x00;
      cpndata.pc_id[1] = 0x00;
      cpndata.pc_id[2] = 0x00;
      cpndata.pc_id[3] = 0x00;
      
      INTRD("VCID (Binary)", iwk);
      cpndata.vc_ch[1] = iwk;

      INTRD("VCID mask ( 0x3f => 63 )", iwk);
      cpndata.vc_ch[0] = iwk;
      
      memcpy(&cpnbuf[0], &cpndata, sizeof( Cpn_data ));      
    }
    else {
      goto error;
    }

    INTRD("# of blocks (frame or packet) per request (*16) ", blk_no);
    if (blk_no == 0) blk_no = 16; /* default for dummy data */
#if 0
    if (blk_no > 10) goto error;
#endif

    INTRD("Save received data (1:yes 2:no(*))", tmp);
    if (tmp == 1) {
      printf("\n");
      printf("File name (/data/wk/... )\n");
      printf("Default /data/wk/TLMDMP \n");
      printf("  ====> ");
      fgets(buf,sizeof(buf),stdin);
      ir = strlen(buf);
      if (ir <= 0) strcpy(buf, "TLMDMP");
      sprintf(filename, "/data/wk/%s",buf);
      wrtflg = 1;
    }else{
      wrtflg = 0;
    }

    /** OPEN data file **/
    if (wrtflg == 1) {
      fd = open(filename, O_WRONLY|O_TRUNC|O_CREAT,0666);
      if (fd == -1) printf("Data file OPEN ERROR[%d]\n",errno);
    }

    /* Call SDTP telemetry function */

    //band = 241;
    //ant_id = 240;
    ////ant_id = 241;
#if 1
fprintf( stderr, "Call SDT_tlm_open() Mode = [%d]\n", mode );
fflush( stderr );
fprintf( stderr, "Call SDT_tlm_open() Type = [%d]\n", type );
fflush( stderr );
fprintf( stderr, "Call SDT_tlm_open() Satellite Number = [%d]\n", sat_no );
fflush( stderr );
fprintf( stderr, "Call SDT_tlm_open() Antenna Number   = [%d]\n", ant_id );
fflush( stderr );
fprintf( stderr, "Call SDT_tlm_open() Telemetry Band   = [%d]\n", band );
fflush( stderr );
fprintf( stderr, "Call SDT_tlm_open() CPN service = [%d]\n", cpn_type );
fprintf( stderr, "    vc_ch[%2x%2x]\n", cpndata.vc_ch[0],cpndata.vc_ch[1]);
fprintf( stderr, "    pc_id[%2x%2x%2x%2x]\n", cpndata.pc_id[0],cpndata.pc_id[1],cpndata.pc_id[2],cpndata.pc_id[3]);
fflush( stderr );
fprintf( stderr, "Call SDT_tlm_open() # of blocks = [%d]\n", blk_no );
fflush( stderr );
#endif

    ir = SDT_tlm_open( mode, type, sat_no, ant_id, band, cpn_type, cpn_cnt, &cpnbuf[0], blk_no, start_tim, end_tim, pathno);
    if( ir != 0 ){
        /* error */
	fprintf( stderr, "SDT_tlm_open() Error [%d]\n", ir );
    	fflush( stderr );
	exit( -1 );
    }

    while( 1 ){
        int pdu_type;
        unsigned char recv_data[164600];
        int recv_len;
   	int ret;
        unsigned char vcwk[2];
    	
	/* Initialize Receive Buffer */
        memset( recv_data, 0, sizeof( recv_data ));
	ret = SDT_tlm_recv( &pdu_type, recv_data, &recv_len );
        if( ret < 0 ){
	    /* error */
	    fprintf( stderr, "SDT_tlm_recv() Error [%d]\n", ret );
    	    fflush( stderr );
	    exit( -2 );
    	}
     	if( ret != 1 ){
#if 0
	    fprintf( stderr, "receive PDU type = [%d]\n", pdu_type );
    	    fflush( stderr );
#endif
	    fprintf( stderr, "receive length   = [%d]\n", recv_len );
    	    fflush( stderr );

     	  if( pdu_type == 0 ){
            int lg = 0;
            int i;
            
            for (i=0;i<blk_no;i++) {
              if (recv_data[lg] == 0x01) {
	         printf("Received first data\n");
	         break;
	      }
              else if (recv_data[lg] == 0x02) {
/****
	        if (i == 0) printf("Received succeeding data\n");
****/
    	        if (cpn_type == 8) {
    	          vcwk[0] = 0x3f & recv_data[12+64+4+1+lg];
/*****
                     int ii;
	             printf("vcid1=%.2x\n",recv_data[2+lg]);
	             printf("vcdu[0][1]=%.2x%.2x\n",recv_data[12+64+4+lg],recv_data[12+64+4+1+lg]);
	             printf("vcid2=%.2x\n",recv_data[12+64+4+1+lg]);
	             printf("vc=");
			for( ii=0; ii<1051; ii++ ) {
	             		printf("%.2x",recv_data[12+64+4+lg+ii]);
				if( ii%50 == 0 ) {
	             printf("\n");
				}
			}
	             printf("\n");
*****/
	        }
    	        else if (cpn_type == 2) {
    	          vcwk[0] = 0x3f & recv_data[12+64+1+lg];
/*****
	             printf("vcid1=%.2x\n",recv_data[2+lg]);
	             printf("vcdu[0][1]=%.2x%.2x\n",recv_data[12+64+lg],recv_data[12+64+1+lg]);
	             printf("vcid=%.2x\n",recv_data[12+64+1+lg]);
*****/
	        }
    	        else {
    	          vcwk[0] = 0x07 & recv_data[12+64+lg];
    	          vcwk[1] = 0xff & recv_data[12+64+1+lg];
/*****
	             printf("vcid1=%.2x\n",recv_data[2+lg]);
	             printf("apid=%.2x%.2x\n",vcwk[0],vcwk[1]);
*****/
	        }

                fprintf( stderr, "Receive Data[%d/%d] : TIME [%.2x%.2x/%.2x%.2x %.2x:%.2x:%.2x:%.2x:%.2x]", 
	        i+1, blk_no, recv_data[14+lg],recv_data[15+lg],recv_data[16+lg],recv_data[17+lg],recv_data[18+lg],recv_data[19+lg],recv_data[20+lg],recv_data[21+lg],recv_data[22+lg]);
	          
    	        if (cpn_type == 8 || cpn_type == 2) {
	          fprintf( stderr, " : VCID [%.2x]\n", vcwk[0]);
	        }
	        else {
	          fprintf( stderr, " : VCID [%.2x] : APID [%.2x%.2x]\n",recv_data[2+lg], vcwk[0],vcwk[1]);
	        }
    	        fflush( stderr );

	      }
              else if (recv_data[lg] == 0x04) {
	         printf("Received last data\n");
	         break;
	      }
              else {
	        /* printf("Data Identification Error \n"); */
	         break;
	      }
	      {
	        union word {
                  unsigned int	iwd;
	          char cwd[4];
                } wd;
                int r_lg;

                memcpy(&wd.cwd,&recv_data[8+lg], 4);
	        r_lg = ntohl( wd.iwd );
                lg = lg + r_lg + 12;
              }
	    }
	    printf("\n");
	  }

          if (wrtflg == 1) {
            if ( pdu_type == 0 ) {
              ir = write(fd,recv_data,recv_len);
              if( ir == -1 ){
                 printf("TEST FILE WRITE ERROR[%d]\n",errno);
              }
            }
          }

	}
	if( ret == SDT_RCVFREEREQ ){
	    printf("Received connection close request \n");
	    break;
	}
#if 0
	sleep(1);
#endif
    }
    
    /* Close connection */
	
    ir = SDT_tlm_close();
    if( ir != 0 ){
        /* Error */
	fprintf( stderr, "SDT_tlm_close() Error [%d]\n", ir );
    	fflush( stderr );
	exit( -3 );
    }

    if (wrtflg == 1) close( fd );
    return 0;

error:    
    printf("** input error\n");
    exit(0);
}
