#!/usr/local/bin/sh

function ant2apid () {
    
    echo "ant2mask"
    echo "NO $no"
}

# USC34	17  (0x11)
# GNA	154 (0x9A)
# GNB	155 (0x9B)
# MSP1	150 (0x96)

#declare -f ant2mask

band=3:Allband
sdate=0
edate=$sdate
ant=17
stime=0
etime=0
no=0
verbose=0

apidbin=252
apidmask=000
vcidbin=00
vcidmask=000

# Process command line args
while getopts ":vhna:b:s:e:r:z:" opt; do
    case $opt in
	v  ) verbose=1 ;;
	s  ) sdate=$OPTARG ;;
	e  ) edate=$OPTARG ;;
        n  ) no=1 ;;
	h  ) echo 'usage: daily_new [-n] [-a ant] [-b band] [-s start] [-e end] '
	     exit 0 ;;
        a  ) ant=$OPTARG ;;
        b  ) band=$OPTARG ;;
	r  ) stime=$OPTARG ;;
	z  ) etime=$OPTARG ;;
        \? ) echo 'usage: daily_new [-n] [-a ant] [-b band] [-s start] [-e end] '
             exit 1
    esac
done
shift $(($OPTIND - 1))

if [ $sdate = 0 ] ; then
    echo "No start date. Exiting"
    exit
fi

if [ $stime = 0 ] ; then
    echo "No start time. Exiting"
    exit
fi

if [ $etime = 0 ] ; then
    echo "No end time. Exiting"
    exit
fi

if [ $edate = 0 ] ; then
    edate=$sdate
fi

if [ $verbose = 1 ] ; then
    echo "BAND:  $band"
    echo "ANT:   $ant"
    echo "START: $sdate"
    echo "END:   $edate"
    echo "STIME: $stime"
    echo "ETIME: $etime"
    echo "APID:  $apidbin"
    echo "MASK:  $apidmask"
    echo "VCID:  $vcidbin"
    echo "MASK:  $vcidmask"
    echo "NO:    $no"
fi

ant2apid

if [ $no = 0 ] ; then
    ./REAL_NEW <<EOF
$band
$ant
${sdate}${stime}
${edate}${etime}
1:packet
$apidbin
$apidmask
$vcidbin
$vcidmask
EOF
fi

###exit 0
