//
// RCS $Id: socket.c,v 1.2 2001/03/31 14:09:38 solarb Exp $
//
// $Source: /home/solarb/egse/software/current-wip/src/scsim/RCS/socket.c,v $
//
// $Log: socket.c,v $
// Revision 1.2  2001/03/31 14:09:38  solarb
// Tidied up.
//
// Revision 1.1  2001/02/08 18:47:22  solarb
// Initial revision
//
//
//----------------------------------------------------------------------


#include <locale.h>
#include <stdarg.h>
#include <sys/types.h>		/* for data type defs			*/
#include <unistd.h>		/* for read ?				*/
#include <sys/socket.h>		/* for socket structures		*/
#include <sys/un.h>		/* for unix domain data structures	*/
#include <netinet/in.h>		/* for internet domain structures	*/
#include <arpa/inet.h>
#include <netdb.h>		/* for socket library calls		*/
#include <netinet/in.h>		/* for htons				*/
#include <errno.h>
#include <strings.h>		/* for bzero				*/
#include <sys/param.h>

////#include "egse_sock_lib.h"

#include "socket.h"

////extern int	errno;


#ifdef	SIGTSTP			/* true if BSD system */
#include	<sys/file.h>
#include	<sys/ioctl.h>
#endif


struct sockaddr_in	tcp_serv_addr;	// Server's internet socket address ...
struct servent		tcp_serv_info;	// ... from getservbyname
struct hostent		tcp_host_info;	// From gethostbyname


int tcp_open(char *host, char *service, int port) {

  int			fd, resvport;
  unsigned long		inaddr;
  //  char			*host_err_str();
  struct servent	*sp;
  struct hostent	*hp;

  bzero((char *)&tcp_serv_addr, sizeof(tcp_serv_addr));

  tcp_serv_addr.sin_family = AF_INET;

  if (service != (char *)NULL) {

    if ((sp = getservbyname(service, "tcp")) == (struct servent *)NULL)

      return(-1);

    tcp_serv_info = *sp;

    if (port > 0)

      tcp_serv_addr.sin_port = htons(port);

    else

      tcp_serv_addr.sin_port = sp->s_port;

  }

  else {

    if (port <= 0)

      return(-2);

    tcp_serv_addr.sin_port = htons(port);

  }

  if ((inaddr = inet_addr(host)) != INADDR_NONE) {

    bcopy((char *)&inaddr, (char *)&tcp_serv_addr.sin_addr, sizeof(inaddr));

    tcp_host_info.h_name = NULL;

  }

  else {

    if ((hp = gethostbyname(host)) == NULL)

      return(-3);

    tcp_host_info = *hp;

    bcopy(hp->h_addr, (char *)&tcp_serv_addr.sin_addr, hp->h_length);

  }

  if (port >= 0) {

    if ((fd = socket(AF_INET, SOCK_STREAM, 0)) < 0)

      return(-4);

  }

  else

    if (port < 0) {

      resvport = IPPORT_RESERVED - 1;

      if ((fd = rresvport(&resvport)) < 0)

	return(-5);

    }

  if (connect(fd, (struct sockaddr *)&tcp_serv_addr, sizeof(tcp_serv_addr)) < 0) {

    close(fd);

    return(-6);

  }

  return(fd);

}
