/**********************************************************
 *          * isas sat-ope.common-ql system *
 *      f.name      : SDTP client libray test program
 *      date        : 2000.09.28 K.Matsuzaki
 *	date	    : 1996.09.14 S.Takahashi
 *	update      :
 *********************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<signal.h>
#include	<time.h>
#include	<ctype.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<sys/param.h>
#include	<sys/socket.h>
#include	<sys/fcntl.h>
#include	<netinet/in.h>
#include	<netdb.h>
#include	<errno.h>
#include	<unistd.h>
#include	<syslog.h>

#include "SDT_all.h"
#include "SDT_tlm.h"

#include "socket.h"
#include "offsets.h"
#include "error_string.h"

#if 0
#ifdef ISAS
#define SBAND_ARCHIVE "/san_solar/disk2/home/sbukeis/localdata/sdtp/late/eis_sts_"
#define XBAND_ARCHIVE "/san_solar/disk2/home/sbukeis/localdata/sdtp/late/eis_md_"
#define DUMP_ARCHIVE "/san_solar/disk2/home/sbukeis/localdata/sdtp/late/eis_dmp_"
#define LOG "/san_solar/disk2/home/sbukeis/localdata/log/late.log"
#else
#define SBAND_ARCHIVE "/data/eis/fm/data/sdtp/eis_sts_"
#define XBAND_ARCHIVE "/data/eis/fm/data/sdtp/eis_md_"
#define DUMP_ARCHIVE "/data/eis/fm/data/sdtp/eis_dmp_"
#define LOG "/data/eis/fm/data/sdtp/reals.log"
#endif
#endif

#define LOG(...)	if(log_file) { fprintf(log_file, __VA_ARGS__); fflush(log_file); }

//#define HK1_PER_ORBIT (90 * 60)		// 1 packet per second
//#define STS1_PER_ORBIT ((90 * 60) / 2)	// 2 packets per second
#define HK1_PER_ORBIT	(90 * 60 * 2)		// More than 90 mins worth to prevent daily_merge_status1 opening files
#define STS1_PER_ORBIT	((90 * 60 * 2) / 2)	// Ditto

void doy2sensible_values(unsigned long, unsigned long, unsigned char *, unsigned char *);

FILE *tlmfile;
FILE *sts_file = (FILE *)NULL, *dmp_file = (FILE *)NULL, *md_file = (FILE *)NULL;
FILE *log_file = (FILE *)NULL;
unsigned long sts_count = 0, sts = 0, dmp = 0, md = 0, hk_sts = 0, hk_428_sts = 0, hk_440_sts = 0, hk_count = 0, sot_sts = 0, eis_mdp_sts = 0;
int md_type;
char sts_filename[256], dmp_filename[256], md_filename[256];
char log_filename[256];
char temp_buffer[256];
char temp_md_packet[8096];
char month_str[4];
char day_str[4];
int month,day;
int md_packet_counter = 0;
int md_data_size;

int dump_seq_flag;
int ccsds_seq_flag;

int previous_md_mid = -1;
int current_md_mid;
unsigned short mid;

int first_sts_pkt = 1;
int transmit = 1;

unsigned short	msf;
unsigned short	ssf;
unsigned short	end_msf;
unsigned short	end_ssf;
unsigned short	msc;
unsigned short	ssc;
unsigned short	got_md_start = 0;

unsigned short	seq_number, ll_number, sequence_id, raster_id, pkt_type;
unsigned long	pkt_num;

int ccsds_seq_count;
int previous_sts1_seq_count = -1;
int previous_sts2_seq_count = -1;
int previous_sts3_seq_count = -1;

int expected_sts1_seq_count = 0;
int expected_sts2_seq_count = 0;
int expected_sts3_seq_count = 0;

long previous_hk1_seq_count = -1;
long previous_hk2_seq_count = -1;
long previous_hk3_seq_count = -1;
long previous_sot_seq_count = -1;
long previous_eis_mdp_seq_count = -1;

int diff;
unsigned char skip = 0;
unsigned char skip1 = 0;

// Not used anymore
char *sts_type[] = {"STS1", "STS2", "STS3"};

unsigned char end_date[256];

FILE *open_file(FILE *, char *, char *);

int handle_duplicate_packets(int *packet_type_seq_count, int seq_count, int *diff, int good_vcid);
int handle_duplicate_packets1(long *previous_packet_seq_count, unsigned long current_packet_time, int *diff, int good_vcid);
void print_pass_information(unsigned char *recv_data, int lg, unsigned short apid);
void print_time_fields(unsigned char *recv_data, int lg);
int next_packet_sequence_number(int current_sequence_count);

int packed_bcd2int(int pbcd);

char start_tim[15];
unsigned char recv_data[164600];
int lg = 0;

int end_hour, end_minute;
int packet_hour, packet_min, packet_sec;

// Used to calculate time in seconds of packet from start of archive
int start_hour, start_minute, start_seconds, current_seconds, elapsed_seconds = 0;

/* Modification for sirius (start) */
/* mcrw 20080829 */
/*int SDT_tlm_open();*/
#if 1
static int SDT_tlm_open( 
			int mode,		
			int type,		
			int sat_no,		
			int ant_id,		
			int band,		
			int cpn_type,		
			int cpn_cnt,		
			unsigned char *cpn_data, 
			int blk_no,		
			char *start_time,	
			char *end_time,	
			char *pathno){	
  
  int ant_band[8][2];
  int ii;
  int ret;
  
  /* initialize station and telemetry bands */
  for(ii=0;ii<8;ii++){
    ant_band[ii][0] = 0;
    ant_band[ii][1] = 0;
  }
  
  ant_band[0][0] = ant_id;  
  ant_band[0][1] = band;    
  
  //	ret = SDT_tlm_open( mode, type, sat_no, ant_band, cpn_type, cpn_cnt, cpn_data, blk_no, start_time, end_time, pathno);
  ret = SDT_tlm_open_sirius( mode, type, sat_no, ant_band, cpn_type, cpn_cnt, cpn_data, blk_no, start_time, end_time, pathno);
  //	ret = SDT_tlm_open_client( mode, type, sat_no, ant_band, cpn_type, cpn_cnt, cpn_data, blk_no, start_time, end_time, pathno);
  
  return ret;
}
#endif

/* Modification for sirius (end) */

#define TXTRD(prompt,variable) \
{ \
variable[0] = '0'; \
printf(prompt "\n"); \
printf("  ====> "); \
fgets(variable,sizeof(variable),stdin); \
}

#define INTRD(prompt,variable) \
{ \
char _tmp[256]; \
printf(prompt "\n"); \
printf("  ====> "); \
fgets(_tmp,256,stdin); \
variable = atoi(_tmp); \
}

int main()
{
  /* Parameter setting for SDT_tlm_open() */
  int mode;
  int sat_no;
  int ant_id;
  int band;
  int type;
  char pathno[11];
  //    char start_tim[15];
  char end_tim[15];
  int cpn_type;
  int cpn_cnt;
  int blk_no;
  unsigned char cpnbuf[128];
  Cpn_data  cpndata;
  
  /* Output */
  int wrtflg;
  char filename[36];
  int fd = 0;
  
  /* Temporal */
  int iwk, ir;
  char buf[128];
  
  // EIS vars
  int statusmon_socket_fd;
  
  unsigned long fetch_count = 0;
  
  fprintf(stderr, "TLMPATH = %s\n", getenv("TLMPATH"));
  
#ifdef ISAS
  fprintf(stderr, "Compiled for ISAS\n");
#else
  fprintf(stderr, "Compiled for MSSL\n");
#endif
  
  // EIS stuff
  if((statusmon_socket_fd = tcp_open("localhost", (char *)NULL, 10006)) < 0) {
    fprintf(stderr,"Statusmon connect error (%d)\n",
	    statusmon_socket_fd);
    
    transmit = 0;
  }
  else 
    fprintf(stdout, "Connected OK\n");
  
  /* transfer mode (1:REAL 2:LATE BUFFERING) */
  ///  mode = 1;
  mode = 2;
  
  sat_no = SOLARB;
  
#if 1
  TXTRD("Telemetry band (1:S-BAND(*) 2:X-BAND 3:Allband)", buf);
  if (buf[0] =='\n') band = ALLBAND;
  else if (buf[0] == '1') band = SBAND;
  else if (buf[0] == '2') band = XBAND;
  else if (buf[0] == '3') band = ALLBAND;
  else goto error;
#else
  band = SBAND;
#endif
  
#if 1
  INTRD("Antenna number", ant_id);
#endif
  
#if 0
  INTRD("Data Specification (1:Pass Number 2:Time(*))", type);
#endif
  
  type = 2;
  
  if (type == 0) type = 2; /* default for dummy data */
  if (type == 1) {
    printf("Pass Number\n");
    printf("       [YYMMDDxxxx]\n");
    printf("  ====> ");
    fgets(pathno,sizeof(pathno),stdin);
    printf("pathno=%s\n",pathno);
  }
  else if (type==2){
    printf("Start Time\n");
    printf("       [YYYYMMDDhhmmss](*20010827100900)\n");
    printf("  ====> ");
    fgets(start_tim,sizeof(start_tim),stdin);
    
    if(start_tim[0] == '\n') {
      strcpy(start_tim, "20010827100900");
      fprintf(stdout, "DEFAULT START TIME\n");
    }
    if (start_tim[0] == 'x') exit(0);
    ir = strncmp(&start_tim[4],"1231",4);
    if (ir > 0) goto error;
    ir = strncmp(&start_tim[8],"235959",6);
    if (ir > 0) goto error;
    
    //        fgets(end_tim,sizeof(end_tim),stdin);
    fgets(buf, sizeof(buf), stdin);	// Eat spare \n
    
    printf("End Time\n");
    printf("       [YYYYMMDDhhmmss](*20010827113200)\n");
    printf("  ====> ");
    fgets(end_tim,sizeof(end_tim),stdin);
    if(end_tim[0] == '\n') {
      strcpy(end_tim, "20010827113200");
      fprintf(stdout, "DEFAULT END TIME\n");
    }
    if (end_tim[0] == 'x') exit(0);
    if (end_tim[0] == 0x00 || end_tim[0] == 0x20) {
      memset(end_tim,0x00,15);  /* NULL */
    }
    ir = strncmp(&end_tim[4],"1231",4);
    if (ir > 0) goto error;
    ir = strncmp(&end_tim[8],"235959",6);
    if (ir > 0) goto error;      
  }
  
  ////  fgets(buf, sizeof(buf), stdin);	// Eat spare \n
  
#if 1
  TXTRD("CPN service (0:two packets 1:packet(*) 2:virtual channel 3:transfer frame) ", buf);
#else
  buf[0] = '1';
#endif
  
  if (buf[0] =='\n') buf[0] = '1'; /* default for dummy data */
  if (buf[0] == '0') {
    cpn_type = 1;
    /* # of CPN service */
    cpn_cnt = 2;
    /* CPN service setting */	
    
    INTRD("No.1 APID (Binary)", iwk);  
    cpndata.pc_id[2] = iwk>>8;
    cpndata.pc_id[3] = iwk;
    
    INTRD("No.1 APID mask ( 0x7ff => 2047 )", iwk); 
    cpndata.pc_id[0] = iwk>>8;
    cpndata.pc_id[1] = iwk;
    
    INTRD("No.1 VCID (Binary)", iwk);
    cpndata.vc_ch[1] = iwk;
    
    INTRD("No.1 VCID mask ( 0x3f => 63 )", iwk);
    cpndata.vc_ch[0] = iwk;
    
    memcpy(&cpnbuf[0], &cpndata, sizeof( Cpn_data ));
    
    INTRD("No.2 APID (Binary)", iwk);
    cpndata.pc_id[2] = iwk>>8;
    cpndata.pc_id[3] = iwk;
    
    INTRD("No.2 APID mask ( 0x7ff => 2047 )", iwk);
    cpndata.pc_id[0] = iwk>>8;
    cpndata.pc_id[1] = iwk;
    
    INTRD("No.2 VCID (Binary)", iwk);
    cpndata.vc_ch[1] = iwk;
    
    INTRD("No.2 VCID mask ( 0x3f => 63 )", iwk);
    cpndata.vc_ch[0] = iwk;
    
    memcpy(&cpnbuf[sizeof( Cpn_data )], &cpndata, sizeof( Cpn_data ));      
  }
  else if (buf[0] == '1') {
    /* CPN service setting */
    cpn_type = 1;
    /* # of CPN service */
    cpn_cnt = 1;
    
    //    INTRD("APID (Binary)", iwk);
    iwk = atoi("\n");
    cpndata.pc_id[2] = iwk>>8;
    cpndata.pc_id[3] = iwk;
    
    //    INTRD("APID mask ( 0x7ff => 2047 )", iwk);
    iwk = atoi("\n");
    cpndata.pc_id[0] = iwk>>8;
    cpndata.pc_id[1] = iwk;
    
    //    INTRD("VCID (Binary)", iwk);
    iwk = atoi("\n");
    cpndata.vc_ch[1] = iwk;
    
    INTRD("VCID mask ( 0x3f => 63 )", iwk);
    iwk = atoi("\n");
    cpndata.vc_ch[0] = iwk;
    
    memcpy(&cpnbuf[0], &cpndata, sizeof( Cpn_data ));
  }
  else if (buf[0] == '2') {
    cpn_type = 2;
    /* # of CPN service */
    cpn_cnt = 1;
    /* CPN service setting */
    
    cpndata.pc_id[0] = 0x00;
    cpndata.pc_id[1] = 0x00;
    cpndata.pc_id[2] = 0x00;
    cpndata.pc_id[3] = 0x00;
    
    INTRD("VCID (Binary)", iwk);
    cpndata.vc_ch[1] = iwk;
    
    INTRD("VCID mask ( 0x3f => 63 )", iwk);
    cpndata.vc_ch[0] = iwk;
    
    memcpy(&cpnbuf[0], &cpndata, sizeof( Cpn_data ));
  }
  else if (buf[0] == '3') {
    cpn_type = 8;
    /* # of CPN service */
    cpn_cnt = 1;
    /* CPN service setting */
    
    cpndata.pc_id[0] = 0x00;
    cpndata.pc_id[1] = 0x00;
    cpndata.pc_id[2] = 0x00;
    cpndata.pc_id[3] = 0x00;
    
    INTRD("VCID (Binary)", iwk);
    cpndata.vc_ch[1] = iwk;
    
    INTRD("VCID mask ( 0x3f => 63 )", iwk);
    cpndata.vc_ch[0] = iwk;
    
    memcpy(&cpnbuf[0], &cpndata, sizeof( Cpn_data ));      
  }
  else {
    goto error;
  }
  
#if 0
  INTRD("# of blocks (frame or packet) per request (*16) ", blk_no);
  if (blk_no == 0) blk_no = 16; /* default for dummy data */
#endif
  
  // Hard coding this because can't seem to change it otherwise
  blk_no = 16;
  
#if 0
  if (blk_no > 10) goto error;
#endif
  
#if 0
  INTRD("Save received data (1:yes 2:no(*))", tmp);
  
  if (tmp == 1) {
    printf("\n");
    printf("File name (/data/wk/... )\n");
    printf("Default /data/wk/TLMDMP \n");
    printf("  ====> ");
    fgets(buf,sizeof(buf),stdin);
    ir = strlen(buf);
    if (ir <= 0) strcpy(buf, "TLMDMP");
    sprintf(filename, "/data/wk/%s",buf);
    wrtflg = 1;
  }else{
    wrtflg = 0;
  }
#endif
  
  wrtflg = 0;
  
  /** OPEN data file **/
  if (wrtflg == 1) {
    fd = open(filename, O_WRONLY|O_TRUNC|O_CREAT,0666);
    if (fd == -1) printf("Data file OPEN ERROR[%d]\n",errno);
  }
#if 0
  INTRD("Dump data (0:Summary(*), 1:CcsdsHeader 2:CcsdsPacket, 3:All)", dumplevel);
#endif
	
  /* Call SDTP telemetry function */
  
  fprintf(stderr, "SDT_tlm_open: sat %d, mode %d, type %d, ant %d, band %d, cpntype %d, vc [%d,%d], pc [%d,%d,%d,%d]\n", sat_no, mode, type, ant_id, band, cpn_type, cpndata.vc_ch[0], cpndata.vc_ch[1], cpndata.pc_id[0], cpndata.pc_id[1], cpndata.pc_id[2], cpndata.pc_id[3]);
  
  // Open the log file
  //  if((log_file = fopen(LOG, "a")) == (FILE *)NULL) {
  
  (void)strncpy(log_filename, getenv("SDTP_LOG"), 256);
  //  (void)strncat(log_filename, start_tim, 256 - strlen(log_filename));
  (void)strncat(log_filename, start_tim, 8);
  (void)strncat(log_filename, "_", 1);

  // mcrw 20180317
  //  (void)strncat(log_filename, &start_tim[8], 4);
  (void)strncat(log_filename, &start_tim[8], 6);

  (void)strncat(log_filename, ".log", 4);
  
  //  if((log_file = fopen(getenv("SDTP_LOG"), "a")) == (FILE *)NULL) {
  if((log_file = fopen(log_filename, "w")) == (FILE *)NULL) {
    fprintf(stderr, "Bad log file fopen\n");
  }
  
  fprintf(stderr, "SDTP_LOG = %s\n", log_filename);
#if 0  
  if(log_file) {
    fprintf(log_file, "SDT_tlm_open: sat %d, mode %d, type %d, ant %d, band %d, cpntype %d, vc [%d,%d], pc [%d,%d,%d,%d]\n", sat_no, mode, type, ant_id, band, cpn_type, cpndata.vc_ch[0], cpndata.vc_ch[1], cpndata.pc_id[0], cpndata.pc_id[1], cpndata.pc_id[2], cpndata.pc_id[3]);
    
    fflush( log_file );
  }
#endif
  ir = SDT_tlm_open( mode, type, sat_no, ant_id, band, cpn_type, cpn_cnt, &cpnbuf[0], blk_no, start_tim, end_tim, pathno);
  
  if( ir != 0 ){
    /* error */
    fprintf( stderr, "SDT_tlm_open() Error [%d, %s]\t", ir, error_str(ir) );
    LOG("SDT_tlm_open() Error [%d, %s]\t", ir, error_str(ir));
    fclose(log_file);
#if 0
    if(log_file) {
      fprintf( log_file, "SDT_tlm_open() Error [%d, %s]\t", ir, error_str(ir) );
      fflush(log_file);
      fclose(log_file);
    }
#endif
    fflush( stderr );
    exit( -1 );
  }
  
  fprintf(stdout, "\n\nStarting at %s,  ending at %s\n", start_tim, end_tim);

  // Get the end hour & minute so that we don't read in packets from outside the time boundary

  //  end_hour = (end_tim[8] * 10) + end_tim[9];
  //  end_minute = (end_tim[10] * 10) + end_tim[11];
  start_hour   = ((start_tim[8]  - '0') * 10) + (start_tim[9]  - '0');
  start_minute = ((start_tim[10] - '0') * 10) + (start_tim[11] - '0');
  end_hour     = ((end_tim[8]  - '0')   * 10) + (end_tim[9]  - '0');
  end_minute   = ((end_tim[10] - '0')   * 10) + (end_tim[11] - '0');

  start_seconds = (start_hour * (60 * 60)) + (start_minute * 60);

  LOG("\n\nStart %s\nEnd %s\nend_hour %u\nend_minute %u\nstart_seconds %u\n", start_tim, end_tim, end_hour, end_minute, start_seconds);

  while( 1 )
    {
      int				pdu_type;
      int				recv_len;
      int				ret;
      unsigned char	vcwk[2];
      
      /* Initialize Receive Buffer */
      memset( recv_data, 0, sizeof( recv_data ));
      ret = SDT_tlm_recv( &pdu_type, recv_data, &recv_len );
      if( ret < 0 ){
	/* error */
	fprintf( stderr, "SDT_tlm_recv() Error [%d, %s]\n", ret, error_str(ret) );
	LOG("SDT_tlm_recv() Error [%d, %s]\n", ret, error_str(ret));
#if 0
	if(log_file) {
	  fprintf( log_file, "SDT_tlm_recv() Error [%d, %s]\n", ret, error_str(ret) );
	  fflush(log_file);
	}
#endif
#if 0
	fprintf( stderr, "SDT_tlm_recv() Error [%d]\t", ret );
	fprintf( stderr, "%s\n", error_str(ret));
#endif
	
	fflush( stderr );
	exit( 2 );
      }
      
      if( ret != 1 ){
	fprintf( stdout, "receive PDU type  [%d]\t", pdu_type );
	fprintf( stdout, "receive length [%d]\n", recv_len );
	
	/* mcrw 20080905 */
	fprintf(stdout, "Fetch  Data                     GRT? VCID Band Brt     passno  ant                   GRT         Time     Time APID   Cnt Type   Seq Flg\n");
	
	if( pdu_type == 0 ){
	  int i;
	  ++fetch_count;
	  lg = 0;
	  for (i=0;i<blk_no;i++) {
	    if (recv_data[lg] == 0x01) {
	      printf("Received first data\n");
	      break;
	    }
	    else if (recv_data[lg] == 0x02) {
	      fprintf(stdout, "recv_data[lg] = 2\n");
	      if (cpn_type == 8) {
		vcwk[0] = 0x3f & recv_data[12+64+4+1+lg];
		fprintf(stdout, "cpn_type = 8 && vcwk[0] = %d\n", vcwk[0]);
	      }
	      else if (cpn_type == 2) {
		vcwk[0] = 0x3f & recv_data[12+64+1+lg];
		fprintf(stdout, "cpn_type = 2 && vcwk[0] = %d\n", vcwk[0]);
	      }
	      else {
		vcwk[0] = 0x07 & recv_data[12+64+lg];
		vcwk[1] = 0xff & recv_data[12+64+1+lg];
		fprintf(stdout, "cpn_type = %d && vcwk[0] = %d && vcwk[1] = %d\n", cpn_type, vcwk[0], vcwk[1]);
	      }
	    }
	    else if (recv_data[lg] == 0x04) {
	      printf("Received last data\n");
	      break;
	    }
	    else {
	      /* printf("Data Identification Error \n"); */
	      break;
	    }
	    {
	      union	word {
		unsigned int	iwd;
		char cwd[4];
	      }	wd;
	      int		r_lg;
	      /*		int j; */
	      
	      int	vcid;
	      int txlen;	// EIS
	      unsigned short sts_type_offset;
	      
	      // EIS stuff
	      unsigned short APID = (vcwk[0] << 8) | vcwk[1];
	      
	      // Copy record length from the Information Field
	      memcpy(&wd.cwd,&recv_data[8+lg], 4);
	      
	      // Assign record length to r_lg
	      r_lg = ntohl( wd.iwd );
	      
	      fprintf(stdout, "%05lu %02u/%02u ", fetch_count, i+1, blk_no);
	      
	      // Print out time fields of the attached Data
	      print_time_fields(recv_data, lg);
	      
	      if (cpn_type == 8 || cpn_type == 2) {
		fprintf( stdout, "<%.2x>", vcwk[0]);
		fprintf( stderr, "SETTING VCID TO 0 : %.2x \n", vcwk[0]);
		
		vcid = 0;
		
	      }
	      else {
		//	      fprintf( stdout, "%.2x %.2x%.2x ",
		//		       recv_data[2+lg], vcwk[0],vcwk[1]);
		vcid = recv_data[2 + lg];
		fprintf( stdout, "  %.2x ", recv_data[2+lg]);	// print VCID
	      }
	      
	      print_pass_information(recv_data, lg, APID);
	      
	      // Now look only for EIS packets or EIS pertinent packets
	      transmit        = (statusmon_socket_fd != 0);
	      txlen           = CCSDS_PACKET_LENGTH_TOTAL;
	      ccsds_seq_count = CCSDS_PACKET_SEQUENCE_COUNT;
	      skip            = 0;
	      unsigned long packet_time = CCSDS_PACKET_TIME;
	      ccsds_seq_flag  = CCSDS_PACKET_SEQUENCE_FLAG;

	      char *type_report;

	      //	      fprintf(stdout, "%05u %05u", ccsds_seq_count, ccsds_seq_flag);

	      packet_hour = packed_bcd2int(recv_data[18 + lg]);
	      packet_min  = packed_bcd2int(recv_data[19 + lg]);
	      packet_sec  = packed_bcd2int(recv_data[20 + lg]);

	      current_seconds = (packet_hour * (60 * 60)) + (packet_min * 60) + packet_sec;
	      elapsed_seconds = (current_seconds - start_seconds);

	      switch(APID) {
		// Mission data packets
	      case 0x1ca :
	      case 0x1cb :
		skip = 1;
		type_report = "MD";
		break;
		
		// EIS HK packets
	      case 0x5C4 : 
		//		if(! (skip = handle_duplicate_packets(&previous_sts1_seq_count, ccsds_seq_count, &diff, vcid == 1))) ++sts_count;
		skip = handle_duplicate_packets(&previous_sts1_seq_count, ccsds_seq_count, &diff, vcid == 1);
		type_report = "STS1";
		break;
	      case 0x5C6 :
		skip = handle_duplicate_packets(&previous_sts2_seq_count, ccsds_seq_count, &diff, vcid == 1);
		type_report = "STS2";
		break;								
	      case 0x5C8 :
		skip = handle_duplicate_packets(&previous_sts3_seq_count, ccsds_seq_count, &diff, vcid == 1);
		type_report = "STS3";
		break;
		
		// Spacecraft HK packets. These don't have a sequence count...
	      case 0x0420 :
		skip = handle_duplicate_packets1(&previous_hk1_seq_count, packet_time, &diff, vcid == 0);
		type_report = "HK1";
		break;
	      case 0x0428 :
		skip = handle_duplicate_packets1(&previous_hk2_seq_count, packet_time, &diff, vcid == 0);
		type_report = "HK2";
		break;
	      case 0x0440 :
		skip = handle_duplicate_packets1(&previous_hk3_seq_count, packet_time, &diff, vcid == 0);
		type_report = "HK3";
		break;
	      case 0x0542 :	// sot_sts for doppler info
		skip = handle_duplicate_packets1(&previous_sot_seq_count, packet_time, &diff, vcid == 1);
		type_report = "SOT";
		break;
	      case 0x05C2 :
		skip = handle_duplicate_packets1(&previous_eis_mdp_seq_count, packet_time, &diff, vcid == 1);
		type_report = "MDP";
		break;
		
	      case 0x320 :	// Dump packet
		type_report = "DMP";
		skip = 1;
		dump_seq_flag = (recv_data[MEM_DUMP_SEQUENCE_FLAG]  & 0xC0);
		fprintf(stdout,"%4s %02X %02X", "DMP", dump_seq_flag, recv_data[lg+12+64+9]);								
		if((recv_data[MEM_TABLE_NUMBER] & 0xF0) != 0xE0) {
		  transmit = 0;
		  txlen = 0;
		  break;	// Not eis dump
		}
		
		// if seq_flag == 1 or 3, open new file
		// else if seq_flag == 2 close file after writing
		// if 0 just write
		switch(dump_seq_flag) {
		case 0x40 :	// 1
		case 0xC0 :	// 3
		  dmp_file = open_file(md_file, getenv("DUMP_ARCHIVE"), dmp_filename);										
		default :
		  break;
		}
		
		if(dmp_file) {
		  fwrite((void *)&recv_data[lg+12+64],sizeof(unsigned char),txlen,dmp_file);
		  fflush(dmp_file);
		}
		
		break;
		
	      default :
		type_report = "???";
		skip = 1;
	      }

	      //	      skip1 = ((end_hour == packet_hour) && (end_minute == packet_min) && packet_sec > 0) ? 1 : 0;
	      skip1 = ((end_hour == packet_hour) && (end_minute == packet_min)) ? 1 : 0;
	      fprintf(stdout, "  %s %u (%u:%u, %u:%u, %u)\n", type_report, skip1, end_hour, packet_hour, end_minute, packet_min, packet_sec);
	      //	      fprintf(stdout, "  %s\n", type_report);

	      (void)memcpy(end_date, &recv_data[14+lg], 9);


	      // Write packet to file if correct type
	      ////	      if(!skip) {
	      int wrote_ok = 0;
	      /////////////	      if((!skip) && (!skip1)) {
	      if(!skip) {
		if(!skip1) {
		  if(sts_file)
		    wrote_ok = fwrite((void *)&recv_data[CCSDS_PACKET_START], sizeof(unsigned char), txlen, sts_file);
		  else {
		    sts_file = open_file(sts_file, getenv("SBAND_ARCHIVE"), sts_filename);
		    wrote_ok = fwrite((void *)&recv_data[CCSDS_PACKET_START], sizeof(unsigned char), txlen, sts_file);
		  }
		  LOG("%s\t%02u %02u %02u %5u %u %u %u %d %d %u\n", type_report, packet_hour, packet_min, packet_sec, ccsds_seq_count, skip, skip1, vcid, wrote_ok == txlen, wrote_ok, elapsed_seconds);
		  if(transmit)	// Transmit packet if connected to the status monitor
		    write(statusmon_socket_fd, &recv_data[CCSDS_PACKET_START], txlen);
		}		
		////		LOG("%s\t%02u %02u %02u %5u %u %u %u %d %d %u\n", type_report, packet_hour, packet_min, packet_sec, ccsds_seq_count, skip, skip1, vcid, wrote_ok == txlen, wrote_ok, elapsed_seconds);
	      }				
	      
	      // Point to start of next packet in buffer
	      lg = lg + r_lg + 12;
	      
	    }	// local decs    
	  }	// for(i=0;i<blk_no;i++)
	}	// if(pdu_type == 0)
	
	if (wrtflg == 1) {
	  if ( pdu_type == 0 ) {
	    ir = write(fd,recv_data,recv_len);
	    if( ir == -1 ){
	      printf("TEST FILE WRITE ERROR[%d]\n",errno);
	    }
	  }
	}
	
      }	// if(ret != -1)
      
      if( ret == SDT_RCVFREEREQ ){
	fprintf(stdout, "Received connection close request \n");
	fflush(stdout);
	fprintf(stderr, "Received connection close request \n");
	//      fprintf( log_file, "Received connection close request \n");
#if 0
	fprintf( log_file, "Last packet %.2x%.2x/%.2x%.2x-%.2x:%.2x:%.2x:%.2x:%.2x\n", 
		 end_date[0], end_date[1], 
		 end_date[2], end_date[3],
		 end_date[4], end_date[5],
		 end_date[6], end_date[7], end_date[8]);
	//      fprintf( log_file, "Last packet %s\n", end_date);
	fflush( log_file );
#endif
	break;
      }
      
    }	// while(1)
  
	/* Close connection */
	//  fprintf(stderr, "Closing connection\n");
  ir = SDT_tlm_close();
  if( ir != 0 ) {
    /* Error */
    fprintf( stderr, "SDT_tlm_close() Error [%d]\n", ir );
    fflush( stderr );
#if 0
    fprintf( log_file, "SDT_tlm_close() Error [%d]\n", ir );
    fprintf( log_file, "Last packet %.2x%.2x/%.2x%.2x-%.2x:%.2x:%.2x:%.2x:%.2x\n", 
	     end_date[0], end_date[1], 
	     end_date[2], end_date[3],
	     end_date[4], end_date[5],
	     end_date[6], end_date[7], end_date[8]);
    //    fprintf( log_file, "Last packet %s\n", end_date);
    fflush( log_file );
#endif
    fclose(log_file);
    exit( -3 );
  }
  if (wrtflg == 1) close( fd );
  if(statusmon_socket_fd) close(statusmon_socket_fd);
  fprintf(stderr, "Exiting\n");
  exit(0);
  
 error:    
  printf("** input error\n");
  LOG("** input error\n");
#if 0
  fprintf( log_file, "** input error\n");
  fflush( log_file );
#endif
  fclose(log_file);
  if(statusmon_socket_fd) close(statusmon_socket_fd);
  exit(-4);
}

void doy2sensible_values(unsigned long yr,unsigned long day_num, unsigned char *m, unsigned char *d ) {
  
  char days_in_month[] = {31,28,31,30,31,30,31,31,30,31,30,31};
  unsigned short start_of_month = 1;
  unsigned short end_of_month = 0;
  unsigned short i;
  unsigned short res;
  
  if((yr % 4) == 0) {	// Divisible by 4, leap year. not bothering with century years
    days_in_month[1] = 29;
  }
  for(i = 0; i < 12; i++) {
    end_of_month += days_in_month[i];
    if(day_num <= end_of_month)
      break;
    start_of_month += days_in_month[i];
  }
  res = day_num - start_of_month + 1;
  //  fprintf(stderr,"i = %u, start = %u, end = %u, day = %u\n",i,start_of_month, end_of_month,res);
  *m = i + 1;
  *d = res;
}

FILE *open_file(FILE *file_pointer, char *new_path, char *fname) {
  
  FILE *fp = (FILE *)NULL;
  char temp_buffer[256];
  //  char month_str[4];
  //  char day_str[4];
  char filename[256];
  unsigned char m,d;
  unsigned char tmp[8];
  
  unsigned long year;
  unsigned long doy;
  
  //  sprintf(tmp, "%2u%2u",recv_data[14+lg],recv_data[15+lg]);
  sprintf(tmp, "%2x%02x",recv_data[14+lg],recv_data[15+lg]);
  year = atol(tmp);
  //  fprintf(stderr, "YEAR = %s (%lu)\n",tmp, year);
  tmp[0] = '\0';
  //  sprintf(tmp, "%2u%02u",recv_data[16+lg],recv_data[17+lg]);
  sprintf(tmp, "%.2x%02x",recv_data[16+lg],recv_data[17+lg]);
  doy = atol(tmp);
  //  fprintf(stderr, "DOY = %s (%lu)\n",tmp,doy);
  doy2sensible_values(year,doy,&m,&d);
  
  if(file_pointer != (FILE *)NULL) {
    fflush(file_pointer);
    fclose(file_pointer);
  }
  
  //  strncpy(month_str, &start_tim[4],2);
  //  strncpy(day_str, &start_tim[6],2);
  
  // yr yr mnth day hr min sec tenths milli
  // 20 01 08 28 10 30 00
  sprintf(temp_buffer,
	  //	  "%.2x%.2x%.2s%.2s_%.2x%.2x%.2x%.2x%.2x",
	  "%.2x%.2x%02u%02u_%.2x%.2x%.2x%.2x%.2x",
	  recv_data[14+lg],	// yy
	  recv_data[15+lg],	// yy
	  //	  month_str,
	  //	  day_str,
	  //	  recv_data[16+lg],	
	  //	  recv_data[17+lg],	
	  m,
	  d,
	  recv_data[18+lg],	// hour
	  recv_data[19+lg],	// min
	  recv_data[20+lg],	// sec
	  recv_data[21+lg],	// tenths
	  recv_data[22+lg]);	// milli
  filename[0] = '\0';
  strcpy(filename, new_path);
  strcat(filename, temp_buffer);
  fname[0] = '\0';
  strcat(fname, filename);
  fprintf(stderr,"FILENAME = %s\n",filename);
  fflush(stderr);
  
  if((fp = fopen(filename,"w")) == (FILE *)NULL) {
    fprintf(stderr,"Bad file open\n");
    //    exit(-99);
    return (FILE *)NULL;
  }
  return fp;
}

int handle_duplicate_packets(int *previous_packet_seq_count, int current_packet_seq_count, int *missing, int good_vcid)
{
  //  fprintf(stderr,"%u : %u : %u", *previous_packet_seq_count, current_packet_seq_count, good_vcid);

  // If the vcid is not 1 then skip
  if(! good_vcid) {
    // Do I need to update the sequence counter here????
    return 1;
  }

  // If the counts are the same then return 1 so packet handling is skipped - should not happen...
  if (*previous_packet_seq_count == current_packet_seq_count)
    return 1;
  
  int next_expected_sequence_count = next_packet_sequence_number(*previous_packet_seq_count);
  if (next_expected_sequence_count == current_packet_seq_count) {
    *missing = 0;
  }
  else if (next_expected_sequence_count > current_packet_seq_count) {
    //		diff = next_expected_sequence_count - *previous_packet_seq_count;
    //		*missing = 16384 - next_expected_sequence_count;	// TBC
    //		*missing = 16383 - (next_expected_sequence_count - current_packet_seq_count);	// Alternative - TBC
    *missing = (16384 + current_packet_seq_count) - next_expected_sequence_count;
  }
  else {
    *missing = current_packet_seq_count - next_expected_sequence_count;		// TBC
  }
  
  // Remember the current count and return 0 to allow further packet handling
  *previous_packet_seq_count = current_packet_seq_count;

  return 0;
  
  //	return (*previous_packet_seq_count == current_packet_seq_count) ? 1 : (*previous_packet_seq_count = current_packet_seq_count, 0);
}

int handle_duplicate_packets1(long *previous_packet_seq_count, unsigned long current_packet_time, int *diff, int good_vcid)
{	
  // Skip if the vcid is not true
  if(! good_vcid)
    return 1;
  return 0;
}

void print_pass_information(unsigned char *recv_data, int lg, unsigned short apid)
{
  fprintf(stdout, "  %2u ", recv_data[24+lg]);	// Band
  fprintf(stdout, " %2u ", recv_data[28+lg]);	// Bit rate
  fprintf(stdout, "%02X%02X%02X%02X%02X ", recv_data[29+lg], recv_data[30+lg], recv_data[31+lg], recv_data[32+lg], recv_data[33+lg]);	// passno
  fprintf(stdout, "  %02X ", recv_data[35+lg]);	// antenna id
  fprintf( stdout, "%.2x%.2x/%.2x%.2x ", 	// doy
	   recv_data[68+lg], recv_data[69+lg], 
	   recv_data[70+lg], recv_data[71+lg] );
  fprintf( stdout, "%.2x:%.2x:%.2x:%.2x ", // grt?
	   recv_data[72+lg], recv_data[73+lg],
	   recv_data[74+lg], recv_data[75+lg]);
  // Time
  fprintf(stdout, "%.2X%.2X%.2X%.2X%.2X%.2X ", recv_data[51+lg], recv_data[52+lg], recv_data[53+lg], recv_data[54+lg], recv_data[55+lg], recv_data[56+lg]);
  // Time
  fprintf(stdout, "%.2X%.2X%.2X%.2X ", recv_data[82+lg], recv_data[83+lg], recv_data[84+lg], recv_data[85+lg]);
  fprintf(stdout, "%04X ", apid);
  //  fprintf(stdout, "\n");
  fflush( stdout );
}

void print_time_fields(unsigned char *recv_data, int lg)
{
  // Print out time fields of the attached Data
  //                  y0  y1/  d0  d1			where y0 = 1st 2 year chars, y1 = last 2 chars, d0 1st 2 chars of doy, d1 last 2 chars of doy
  fprintf( stdout, "%.2x%.2x/%.2x%.2x ",
	   recv_data[14+lg], recv_data[15+lg], 
	   recv_data[16+lg], recv_data[17+lg] );
  //                  hh   mm   ss   tt   hu	where tt = tenths, hu = hundredths
  fprintf( stdout, "%.2x:%.2x:%.2x:%.2x:%.2x ", 
	   recv_data[18+lg], recv_data[19+lg],
	   recv_data[20+lg], recv_data[21+lg], recv_data[22+lg]);
}

int next_packet_sequence_number(int current_sequence_count)
{
  return (current_sequence_count + 1) & 0x3FFF;
  //	return (current_sequence_count + 1) % 16384;
}

int packed_bcd2int(int pbcd)
{
  return ((pbcd >> 4) * 10) + (pbcd & 0xF);
}
