/**************************************
 *
 *  CompImageDump
 *
 *    2001/07/10  created
 **************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <cfortran.h>
#include <hbook.h>
#include <cli.h>
#include <com.h>
#include <bnkfm.h>
#include <anl.h>
#include <anl_misc.h>

char CompImageDump_version[] = "version 0.3.2";

void CompImageDump_ana(int nevent, int eventid, int *status)
{
  unsigned char *compimg;
  int compimg_len;
  int gnd_mdphdr_len;
  char *gnd_mdphdr;
  int size,i;
  int img_comp_mode;

  BnkfGetM("GND:MDPHDR",      sizeof(gnd_mdphdr),      &size, &gnd_mdphdr);
  BnkfGetM("GND:MDPHDR_LEN",  sizeof(gnd_mdphdr_len),  &size, &gnd_mdphdr_len);
  BnkGet("GND:CMPIMG",       sizeof(compimg),  &size, &compimg);
  BnkGet("GND:CMPIMG_LEN",   sizeof(compimg_len),  &size, &compimg_len);

  /* Image Compression Mode */
  img_comp_mode = (int) gnd_mdphdr[30] & 0x07;

  switch(img_comp_mode)
    {
    case 0:
      /* no Compression */
      *status = ANL_OK;
      return; 
    case 3:
      /* 12 bits DPCM comp */
      printf("DPCM Comp\n");
      //      for(i=0;i<compimg_len;i++){
      for(i=0;i<16*8;i++){
	printf("%02x ",compimg[i]);
	if(i%16==15)printf("\n");
      }
      break;
    case 7:
      /* 12 bits DCT(JPEG) comp */
      printf("DCT Comp\n");
      //      for(i=0;i<compimg_len;i++){
      for(i=0;i<16*8;i++){
	printf("%02x ",compimg[i]);
	if(i%16==15)printf("\n");
      }
      break;
    default:
      printf("Decompress Error\n");
      *status = ANL_SKIP;
      return ;
    }

  *status = ANL_OK;
}

void CompImageDump_init   (int *status){ *status = ANL_OK; }
void CompImageDump_startup(int *status){ *status = ANL_OK; }
void CompImageDump_com    (int *status){ *status = ANL_OK; }
void CompImageDump_his    (int *status){ *status = ANL_OK; }
void CompImageDump_bgnrun (int *status){ *status = ANL_OK; }
void CompImageDump_endrun (int *status){ *status = ANL_OK; }
void CompImageDump_exit   (int *status){ *status = ANL_OK; }


