/**************************************
 *
 *  CompressNone
 *
 *    2001/07/10  created by Keiichi Matsuzaki
 *
 **************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <cfortran.h>
#include <hbook.h>
#include <cli.h>
#include <com.h>
#include <bnkfm.h>
#include <anl.h>
#include <anl_misc.h>

char CompressNone_version[] = "version 0.3.0";

void CompressNone_init(int *status){ 
  BnkDef( "ONB:CMPIMG",      sizeof(unsigned char *));
  BnkDef( "ONB:CMPIMG_LEN",  sizeof(int) );
  *status = ANL_OK;
}

void CompressNone_ana(int nevent, int eventid, int *status)
{
  unsigned char *img;
  int len;
  int size;

  BnkGet("ONB:SUBIMG",       sizeof(img),  &size, &img);
  BnkGet("ONB:SUBIMG_LEN",   sizeof(len),  &size, &len);

  BnkPut("ONB:CMPIMG",       sizeof(img),  &img);
  BnkPut("ONB:CMPIMG_LEN",   sizeof(len),  &len);

  *status = ANL_OK;
}

void CompressNone_startup(int *status){ *status = ANL_OK; }
void CompressNone_com    (int *status){ *status = ANL_OK; }
void CompressNone_his    (int *status){ *status = ANL_OK; }
void CompressNone_bgnrun (int *status){ *status = ANL_OK; }
void CompressNone_endrun (int *status){ *status = ANL_OK; }
void CompressNone_exit   (int *status){ *status = ANL_OK; }


