/**************************************
 *
 *  DeCompress
 *
 *    2001/07/10  created
 *    2001/08/03  version 0.3.4 
 *    2005/09/24  version 20050920 by Keiichi Matsuzaki
 *      bug fix of (auto -> static)
 **************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <cfortran.h>
#include <hbook.h>
#include <cli.h>
#include <com.h>
#include <bnkfm.h>
#include <anl.h>
#include <anl_misc.h>
#include "MdpPacket.h"
#include "Compression.h"

char DeCompress_version[] = "version 20050920";

#define MODULE "DeCompress"

void DeCompress_init(int *status){ 
  EvsDef( MODULE ":ERR:DPCM_DECOMP");
  BnkDef( "GND:SUBIMG",      sizeof(unsigned char *));
  BnkDef( "GND:SUBIMG_LEN",  sizeof(int) );
  *status = ANL_OK;
}

static int outputBuffer[SUBIMG_LEN]; /* 20050920 why?, gcc bug? */
static char subimg[SUBIMG_LEN*2]; /* 20050920 bug fix */

void DeCompress_ana(int nevent, int eventid, int *status)
{
  unsigned char *cmpimg;
  int cmpimg_len;
  int gnd_mdphdr_len;
  char *gnd_mdphdr;
  int size,i;
  
  int img_size_s,img_size_p;
  int img_comp_mode;
  int decomp_error;

  char *subimg_ptr;
  int numOutputBytes;

 
  subimg_ptr = subimg;

  BnkfGetM("GND:MDPHDR",      sizeof(gnd_mdphdr),      &size, &gnd_mdphdr);
  BnkfGetM("GND:MDPHDR_LEN",  sizeof(gnd_mdphdr_len),  &size, &gnd_mdphdr_len);
  BnkGet("GND:CMPIMG",       sizeof(cmpimg),  &size, &cmpimg);
  BnkGet("GND:CMPIMG_LEN",   sizeof(cmpimg_len),  &size, &cmpimg_len);
  BnkGet("GND:IMG_COMP_MODE",   sizeof(img_comp_mode),  &size, &img_comp_mode);

  img_size_s = (((int) gnd_mdphdr[26] & 0xff) << 8)
    +(((int) gnd_mdphdr[27] & 0xff) << 0);

  img_size_p = (((int) gnd_mdphdr[28] & 0xff) << 8)
    +(((int) gnd_mdphdr[29] & 0xff) << 0);
  
  numOutputBytes = 2 * img_size_s * img_size_p;


  switch(img_comp_mode)
    {
    case NoCompression:
      /* no Compression */
      BnkPut("GND:SUBIMG",       sizeof(cmpimg),  &cmpimg);
      BnkPut("GND:SUBIMG_LEN",   sizeof(cmpimg_len),  &cmpimg_len);
      *status = ANL_OK;
      //      *status = ANL_SKIP;
      return; 
    case XII_bits_DPCM:
      /* 12 bits DPCM comp */
      // printf("Dpcm Decompress start;\n");
      // printf("cmpimg[0] = %2x\n",cmpimg[0]);
      // printf("cmpimg[1] = %2x\n",cmpimg[1]);
      // printf("cmpimg[cmpimg_len-3] = %2x\n",cmpimg[cmpimg_len-3]);
      // printf("cmpimg[cmpimg_len-2] = %2x\n",cmpimg[cmpimg_len-2]);
      // printf("cmpimg[cmpimg_len-1] = %2x\n",cmpimg[cmpimg_len-1]);
      // fflush(stdout);
      decomp_error = DpcmDecomp(cmpimg, cmpimg_len, outputBuffer, numOutputBytes);
      if(decomp_error != 0){
	EvsSet( MODULE ":ERR:DPCM_DECOMP");
	printf("ANL_SKIP\n");
	fflush(stdout);
	*status = ANL_SKIP;
	return;
      }
      // printf("Dpcm Decompress done;\n");
      break;
    case XII_bits_DCT:
      /* 12 bits DCT(JPEG) comp */
      // printf("Dct Decompress start;\n");
      // printf("cmpimg[0] = %2x\n",cmpimg[0]);
      // printf("cmpimg[1] = %2x\n",cmpimg[1]);
      // printf("cmpimg[cmpimg_len-3] = %2x\n",cmpimg[cmpimg_len-3]);
      // printf("cmpimg[cmpimg_len-2] = %2x\n",cmpimg[cmpimg_len-2]);
      // printf("cmpimg[cmpimg_len-1] = %2x\n",cmpimg[cmpimg_len-1]);
      // fflush(stdout); 
      DctDecomp(cmpimg, cmpimg_len, outputBuffer, numOutputBytes);
      // printf("Dct Decompress done;\n");
      break;

    default:
      printf("Error Image Compression Mode\n");
      *status = ANL_SKIP;
      return ;
    }

  for(i=0;i < numOutputBytes/2 ;i++){
    subimg[2*i]   = (outputBuffer[i] >> 8);
    subimg[2*i+1] = (outputBuffer[i] >> 0);
  }


  // printf("DecompressImg[numOutputBytes-1] = %x\n",subimg[numOutputBytes-2]); 
  // printf("DecompressImg[numOutputBytes] = %x\n",subimg[numOutputBytes-1]); 
  BnkPut("GND:SUBIMG",       sizeof(subimg_ptr),  &subimg_ptr);
  BnkPut("GND:SUBIMG_LEN",   sizeof(numOutputBytes),  &numOutputBytes);

  *status = ANL_OK;
}

void DeCompress_startup(int *status){ *status = ANL_OK; }
void DeCompress_com    (int *status){ *status = ANL_OK; }
void DeCompress_his    (int *status){ *status = ANL_OK; }
void DeCompress_bgnrun (int *status){ *status = ANL_OK; }
void DeCompress_endrun (int *status){ *status = ANL_OK; }
void DeCompress_exit   (int *status){ *status = ANL_OK; }


