/**************************************
 *
 *  DeCompressNone
 *
 *    2001/07/10  created
 *    2001/07/23  version 0.3.1 by K.Matsuzaki
 *      ignore compressed data
 **************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <cfortran.h>
#include <hbook.h>
#include <cli.h>
#include <com.h>
#include <bnkfm.h>
#include <anl.h>
#include <anl_misc.h>

char DeCompressNone_version[] = "version 0.3.1";

void DeCompressNone_init(int *status){ 
  BnkDef( "GND:SUBIMG",      sizeof(unsigned char *));
  BnkDef( "GND:SUBIMG_LEN",  sizeof(int) );
  *status = ANL_OK;
}

void DeCompressNone_ana(int nevent, int eventid, int *status)
{
  unsigned char *img;
  int len, code;
  int size;

  BnkGet("GND:CMPIMG",       sizeof(img),  &size, &img);
  BnkGet("GND:CMPIMG_LEN",   sizeof(len),  &size, &len);

  BnkGet( "GND:COMP_CODE",   sizeof(code),  &size, &code);

  if( (code & 0x87ff) != 0x0000 ){
    *status = ANL_SKIP;
    return;
  }

  BnkPut("GND:SUBIMG",       sizeof(img),  &img);
  BnkPut("GND:SUBIMG_LEN",   sizeof(len),  &len);

  *status = ANL_OK;
}

void DeCompressNone_startup(int *status){ *status = ANL_OK; }
void DeCompressNone_com    (int *status){ *status = ANL_OK; }
void DeCompressNone_his    (int *status){ *status = ANL_OK; }
void DeCompressNone_bgnrun (int *status){ *status = ANL_OK; }
void DeCompressNone_endrun (int *status){ *status = ANL_OK; }
void DeCompressNone_exit   (int *status){ *status = ANL_OK; }


