/**************************************
 *
 *  DeCompressDPCM
 *
 *    2001/08/03  created (for PM test)
 **************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <cfortran.h>
#include <hbook.h>
#include <cli.h>
#include <com.h>
#include <bnkfm.h>
#include <anl.h>
#include <anl_misc.h>
#include "MdpPacket.h"
#include "Compression.h"

char DeCompressNoneDPCM_version[] = "version 0.3.3";

#define MODULE "DeCompressNoneDPCM"

void DeCompressNoneDPCM_init   (int *status){ 
  BnkDef( "GND:SUBIMG",      sizeof(unsigned char *));
  BnkDef( "GND:SUBIMG_LEN",  sizeof(int) );
  *status = ANL_OK;
}

void DeCompressNoneDPCM_ana(int nevent, int eventid, int *status)
{
  unsigned char *cmpimg;
  int cmpimg_len;
  int size,i;
  
  int img_comp_mode;

  BnkGet("GND:CMPIMG",       sizeof(cmpimg),  &size, &cmpimg);
  BnkGet("GND:CMPIMG_LEN",   sizeof(cmpimg_len),  &size, &cmpimg_len);
  BnkGet("GND:IMG_COMP_MODE",   sizeof(img_comp_mode),  &size, &img_comp_mode);

  switch(img_comp_mode)
    {
    case NoCompression:
      /* no Compression */
      *status = ANL_SKIP;
      return; 
    case XII_bits_DPCM:
      /* 12 bits DPCM comp */
      break;
    case XII_bits_DCT:
      /* 12 bits DCT(JPEG) comp */
      *status = ANL_SKIP;
      return; 
    default:
      printf("Error Image Compression Mode\n");
      *status = ANL_SKIP;
      return ;
    }
  
  BnkPut("GND:SUBIMG",       sizeof(cmpimg),  &cmpimg);
  BnkPut("GND:SUBIMG_LEN",   sizeof(cmpimg_len),  &cmpimg_len);
  *status = ANL_OK;
}

void DeCompressNoneDPCM_startup(int *status){ *status = ANL_OK; }
void DeCompressNoneDPCM_com    (int *status){ *status = ANL_OK; }
void DeCompressNoneDPCM_his    (int *status){ *status = ANL_OK; }
void DeCompressNoneDPCM_bgnrun (int *status){ *status = ANL_OK; }
void DeCompressNoneDPCM_endrun (int *status){ *status = ANL_OK; }
void DeCompressNoneDPCM_exit   (int *status){ *status = ANL_OK; }


