/**************************************
 *
 *  SBimageRead
 *
 *    2001/03/24  created
 **************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <cfortran.h>
#include <hbook.h>
#include <cli.h>
#include <com.h>
#include <bnkfm.h>
#include <anl.h>
#include <anl_misc.h>

#include <solarb/Image.h>

char SBimageRead_version[] = "version 0.2.0";

/* output parameter */
static int full_x = 4096;
static int full_y = 2048;

/* output buffer */
static unsigned char image_buf   [IMAGE_LEN];

/* local variable */
static FILE *fp;
 
void SBimageRead_init(int *status){ 
  BnkDef( "ONB:IMAGE",       sizeof(unsigned char *));
  BnkDef( "ONB:IMAGE_LEN",   sizeof(int) );
  BnkDef( "ONB:FULL_X",      sizeof(int) );
  BnkDef( "ONB:FULL_Y",      sizeof(int) );
  *status = ANL_OK;
}

void SBimageRead_bgnrun(int *status){
  char filename[256] = "filename";

  INTRD( "Width",     full_x );
  INTRD( "Height",    full_y );
  TXTRD( "File name", filename );
  fp = fopen(filename, "r");
  if( fp == NULL ){
    *status = ANL_QUIT;
    return;
  }
  *status = ANL_OK;
}

void SBimageRead_ana(int nevent, int eventid, int *status)
{
  /* output */
  unsigned char *image   = image_buf;    int image_len;

  /* local */
  int result;

  /* generate contents */
  if( fp == NULL ){ *status = ANL_QUIT; return; }
    
  image_len = full_x * full_y * 2; /* 2byte = 16bit */
  result = fread( image, 1, image_len, fp);
  if( result < image_len ){
    /* some message required */
    *status = ANL_QUIT; return;
  }

  /* output */
  BnkPut( "ONB:IMAGE",       sizeof(image),       &image );
  BnkPut( "ONB:IMAGE_LEN",   sizeof(image_len),   &image_len );
  BnkPut( "ONB:FULL_X",      sizeof(full_x),      &full_x );
  BnkPut( "ONB:FULL_Y",      sizeof(full_y),      &full_y );

  *status = ANL_OK;
}

void SBimageRead_endrun(int *status){
  fclose(fp);
  *status = ANL_OK;
}

void SBimageRead_startup(int *status){ *status = ANL_OK; }
void SBimageRead_com    (int *status){ *status = ANL_OK; }
void SBimageRead_his    (int *status){ *status = ANL_OK; }
void SBimageRead_exit   (int *status){ *status = ANL_OK; }


