/* 
 *    2005/09/24  version 20050920 by K.Matsuzaki
 *      fixed possible inconsistency between header and data part
 */

#define BNKDEF(a,b) BnkDef(a,sizeof(b))
#define BNKPUT(a,b) BnkfPutM(a,sizeof(b),&(b));

#define ALWAYS_ONLY_ONCE 0

class DePacketizeBnkOut {

  byte * _verinf;   int _verinf_len  [NUM_APID];
  byte * _mdphdr;   int _mdphdr_len  [NUM_APID];
  byte * _datainfo; int _datainfo_len[NUM_APID];
  byte * _cmpimg;   int _cmpimg_len;

  PUBLIC DePacketizeBnkOut() {
  }

  PUBLIC void bnkdef() {
    BNKDEF( "GND:VERINF",         _verinf );
    BNKDEF( "GND:VERINF_LEN",     _verinf_len  [0] );
    BNKDEF( "GND:MDPHDR",         _mdphdr );
    BNKDEF( "GND:MDPHDR_LEN",     _mdphdr_len  [0] );
    BNKDEF( "GND:DATAINFO",       _datainfo );
    BNKDEF( "GND:DATAINFO_LEN",   _datainfo_len[0] );
    BNKDEF( "GND:CMPIMG",         _cmpimg );
    BNKDEF( "GND:CMPIMG_LEN",     _cmpimg_len );
  }

  PUBLIC void bnkput(int id) {
    _verinf   = _arr_verinf   + VERINF_LEN   * id;
    _mdphdr   = _arr_mdphdr   + MDPHDR_LEN   * id;
    _datainfo = _arr_datainfo + DATAINFO_LEN * id;
    _cmpimg   = _arr_cmpimg;

    BNKPUT( "GND:VERINF",         _verinf);
    BNKPUT( "GND:MDPHDR",         _mdphdr);
    BNKPUT( "GND:DATAINFO",       _datainfo);
    BNKPUT( "GND:CMPIMG",         _cmpimg );

    BNKPUT( "GND:VERINF_LEN",     _verinf_len   [id] );
    BNKPUT( "GND:MDPHDR_LEN",     _mdphdr_len   [id] );
    BNKPUT( "GND:DATAINFO_LEN",   _datainfo_len [id] );
    BNKPUT( "GND:CMPIMG_LEN",     _cmpimg_len );
  }

  PUBLIC void errdef(){
    EvsDef( MODULE "DISCARD" );
    EvsDef( MODULE "ERR:SEQN" );
    EvsDef( MODULE "ERR:FLAG1" );
    EvsDef( MODULE "ERR:FLAG2" );
    EvsDef( MODULE "ERR:COUNT" );
    EvsDef( MODULE "ERR:LENGTH1" );
    EvsDef( MODULE "ERR:LENGTH2" );
    EvsDef( MODULE "ERR:LENGTH3" );
    EvsDef( MODULE "ERR:TOOLARGE" );
  }

  PUBLIC void setVerInf(int id, int pos, byte value){ 
    _arr_verinf[VERINF_LEN*id + pos] = value;    
  }
  PUBLIC void setVerInfLen(int id, int verinf_len){
    _verinf_len[id] = verinf_len;
  }
  PUBLIC void setMdpHdr(int id, int pos, byte value){ 
    _arr_mdphdr[MDPHDR_LEN*id + pos] = value;    
  }
  PUBLIC void setMdpHdrLen(int id, int mdphdr_len){
    _mdphdr_len[id] = mdphdr_len;
  }
  PUBLIC void setDataInfo(int id, int pos, byte value){ 
    _arr_datainfo[DATAINFO_LEN*id + pos] = value;    
  }
  PUBLIC void setDataInfoLen(int id, int datainfo_len){
    _datainfo_len[id] = datainfo_len;
  }
  PUBLIC void setCmpImg(int pos, byte value){ 
    _arr_cmpimg[pos] = value;    
  }
  PUBLIC void setCmpImgLen(int cmpimg_len){
    _cmpimg_len = cmpimg_len;
  }

};


