/**************************************
 *
 *  ImageDiv
 *
 *    2001/03/26  version 0.2.0
 *      created
 **************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <cli.h>
#include <bnk.h>
#include <bnkf.h>
#include <anl.h>

#include <cc-java.h>
#include <solarb/sbstd.h>
#include <solarb/Image.h>     /* input */
#include <solarb/MdpPacket.h> /* output */

#define MODULE "ImageDiv:"

char ImageDiv_version[] = "version 0.2.0";

/*
 * This is a test module. Invalid parameter settings may 
 * cause troubles. Use carefully, please.
 */

// typedef int vect[2];

class ImageDiv {

#include "ImageDivParam.cc"
#include "ImageDivBnkIn.cc"
#include "ImageDivBnkOut.cc"

  ImageDivBnkIn  _bi;
  ImageDivBnkOut _bo;
  ImageDivParam  _pm;

  int _packetno;
  int _sub_sf;
  int _sub_sc;

  PUBLIC void init(){
    _bi = NEW ImageDivBnkIn();
    _bo = NEW ImageDivBnkOut();
    _pm = NEW ImageDivParam();

    _packetno = 0;
    _sub_sf   = 1;
    _sub_sc   = 0;

    _bo.bnkdef();
  }

  PUBLIC void ana(int REF status)
  {
    // BNKGET

    _bi.bnkget();

    // This module is unusual since parameters 
    // must be set in every mdp packet. 

    const int result = _pm.set_parameters();
  
    if( result != ImageDivParam::OK ){ /* end of image (i.e ccsds stream) */
      _sub_sf = 1;
      _sub_sc = 0; 

      status = ANL_SKIP; 
      return;
    }

    // packet type switching
    
    const boolean expinfo_packet = (_pm.expinfo_len() != ImageDivParam::NA);
    const boolean last_packet    = (_sub_sc+1 == _pm.num_packet());

    // prepartion of output data

    // -- packet size will be setted later

    if ( _pm.packetno() != ImageDivParam::AUTO ) _packetno = _pm.packetno(); 
    if ( _pm.sub_sf()   != ImageDivParam::AUTO ) _sub_sf   = _pm.sub_sf(); 
    else                                         _sub_sf  |= (last_packet?2:0);
    if ( _pm.sub_sc()   != ImageDivParam::AUTO ) _sub_sc   = _pm.sub_sc();   

    int full[2]; {
      if( _pm.direction == ImageDivParam::XY ){ 
	full[0] = _bi.getFullX(); 
	full[1] = _bi.getFullY(); 
      } else { 
	full[0] = _bi.getFullY(); 
	full[1] = _bi.getFullX(); 
      }
    }

    const int PTR base     = _pm.base();
    const int PTR part     = _pm.part();

    const int mdphdr_len   =     MDPHDR_LEN;
    const int datainfo_len = _pm.datainfo_len();
    const int subimg_len   = 	(expinfo_packet) ?
      (_pm.expinfo_len()) : (part[0]*part[1]*2);

    //

    int packet_size; {
      if ( _pm.packet_size() == ImageDivParam::AUTO ){
	packet_size = mdphdr_len + datainfo_len + subimg_len;
      }else{
	packet_size = _pm.packet_size(); 
      }
    }

    //

    // pack into MDP header

    _bo.setMdpHdrLen( mdphdr_len );
    {
      int tmp;

      _bo.setMdpHdr( 0+0, toUByte( _pm.datatype()  >> 0 ));

      _bo.setMdpHdr( 1+0, toUByte(     packet_size >>16 ));
      _bo.setMdpHdr( 1+1, toUByte(     packet_size >> 8 ));
      _bo.setMdpHdr( 1+2, toUByte(     packet_size >> 0 )); 

      _bo.setMdpHdr( 4+0, toUByte(    _packetno    >>24 ));
      _bo.setMdpHdr( 4+1, toUByte(    _packetno    >>16 ));
      _bo.setMdpHdr( 4+2, toUByte(    _packetno    >> 8 ));
      _bo.setMdpHdr( 4+3, toUByte(    _packetno    >> 0 ));

      _bo.setMdpHdr( 8+0, toUByte( _pm.main_id()   >> 8 ));
      _bo.setMdpHdr( 8+1, toUByte( _pm.main_id()   >> 0 ));
      tmp  =              toUByte((_pm.main_sf()    & 0x0003) << 6);
      tmp |=              toUByte((_pm.main_sc()    & 0x3f00) >> 8);
      _bo.setMdpHdr(10+0, tmp);
      _bo.setMdpHdr(10+1, toUByte((_pm.main_sc()    & 0x00ff) >> 0));

      _bo.setMdpHdr(12+0, toUByte((_pm.num_packet() & 0x00fc) >> 2));
      tmp  =              toUByte((_pm.num_packet() & 0x0003) << 6);
      tmp |=              toUByte((_pm.num_frame()  & 0x003f) >> 0);
      _bo.setMdpHdr(12+1, tmp);

      _bo.setMdpHdr(14+0, toUByte( _pm.sub_id()    >> 8 ));
      _bo.setMdpHdr(14+1, toUByte( _pm.sub_id()    >> 0 ));
      tmp  =              toUByte((   _sub_sf       & 0x0003) << 6);
      tmp |=              toUByte((   _sub_sc       & 0x3f00) >> 8);
      _bo.setMdpHdr(16+0, tmp);
      _bo.setMdpHdr(16+1, toUByte((   _sub_sc       & 0x00ff) >> 0));

      _bo.setMdpHdr(18+0, toUByte(     full[0]     >> 8 ));
      _bo.setMdpHdr(18+1, toUByte(     full[0]     >> 0 ));
      _bo.setMdpHdr(20+0, toUByte(     full[1]     >> 8 ));
      _bo.setMdpHdr(20+1, toUByte(     full[1]     >> 0 ));

      _bo.setMdpHdr(22+0, toUByte(     base[0]     >> 8 ));
      _bo.setMdpHdr(22+1, toUByte(     base[0]     >> 0 ));
      _bo.setMdpHdr(24+0, toUByte(     base[1]     >> 8 ));
      _bo.setMdpHdr(24+1, toUByte(     base[1]     >> 0 ));

      _bo.setMdpHdr(26+0, toUByte(     part[0]     >> 8 ));
      _bo.setMdpHdr(26+1, toUByte(     part[0]     >> 0 ));
      _bo.setMdpHdr(28+0, toUByte(     part[1]     >> 8 ));
      _bo.setMdpHdr(28+1, toUByte(     part[1]     >> 0 ));

      _bo.setMdpHdr(30+0, toUByte( _pm.comp_code() >> 8 ));
      _bo.setMdpHdr(30+1, toUByte( _pm.comp_code() >> 0 ));
    }

    // pack into DATAINFO

    _bo.setDataInfoLen( datainfo_len );
    {
      /* not yet supported */
    }

    // pack into DATA part

    _bo.setSubImgLen( subimg_len );
    if( !expinfo_packet ){
      int opos = 0;

      for(int ax1=0; ax1<part[1]; ax1++ ){
	for(int ax0=0; ax0<part[0]; ax0++ ){
	  final int SMALL = ImageDivParam::SMALL;

	  const int bx0 = base[0]+((_pm.port[0]==SMALL)?(ax0):(part[0]-1-ax0));
	  const int bx1 = base[1]+((_pm.port[1]==SMALL)?(ax1):(part[1]-1-ax1));
      
	  const int ipos = ( _pm.direction==ImageDivParam::XY )?
	    ( bx0 + bx1*full[0] ) : ( bx1 + bx0*full[1] );

	  const int value 
	    = ( fromUByte( _bi.getImage(2*ipos+0) ) << 8 ) 
	    + ( fromUByte( _bi.getImage(2*ipos+1) ) << 0 );

	  _bo.setSubImg(2*opos+0, toUByte(value >> 8));
	  _bo.setSubImg(2*opos+1, toUByte(value >> 0));
	  opos++;
	}
      }
    }else{
      /* not yet supported */
    }

    // preparation for next

    _packetno ++;
    _sub_sf = 0;
    _sub_sc ++; 

    _pm.IncrementBase();

    // BNKPUT 

    status = ANL_NEWROOT;   

    if( status != ANL_SKIP ) _bo.bnkput();
  }
};

/*
 * Linkage for slrb_anl
 */

extern "C" {
  static class ImageDiv lc = NEW ImageDiv();

  void ImageDiv_init   (int *status){ 
    lc.init();
    *status = ANL_OK;
  }
  void ImageDiv_ana    (int nevent, int eventid, int *status){ 
    lc.ana( *status ); 
  }

  /* default functions */
  void ImageDiv_startup(int *status){ *status = ANL_OK; }
  void ImageDiv_com    (int *status){ *status = ANL_OK; }
  void ImageDiv_his    (int *status){ *status = ANL_OK; }
  void ImageDiv_bgnrun (int *status){ *status = ANL_OK; }
  void ImageDiv_endrun (int *status){ *status = ANL_OK; }
  void ImageDiv_exit   (int *status){ *status = ANL_OK; }
}


