/* - BnkPut */ 

#define BNKDEF(a,b) BnkDef(a,sizeof(b))
#define BNKPUT(a,b) BnkfPutM(a,sizeof(b),&(b));

class ImageDivBnkOut {
  byte /*PTR*/ _arr_mdphdr  [MDPHDR_LEN];   
  byte /*PTR*/ _arr_datainfo[DATAINFO_LEN]; 
  byte /*PTR*/ _arr_subimg  [SUBIMG_LEN];   

  byte PTR _mdphdr;   int _mdphdr_len;
  byte PTR _datainfo; int _datainfo_len;
  byte PTR _subimg;   int _subimg_len;

  PUBLIC ImageDivBnkOut(){
    _mdphdr   = _arr_mdphdr;
    _datainfo = _arr_datainfo;
    _subimg   = _arr_subimg;

    for(int i=0; i<DATAINFO_LEN; i++){
      _datainfo[i] = i;
    }
  }

  PUBLIC void bnkdef() {
    BNKDEF( "ONB:MDPHDR",         _mdphdr );
    BNKDEF( "ONB:MDPHDR_LEN",     _mdphdr_len );
    BNKDEF( "ONB:DATAINFO",       _datainfo );
    BNKDEF( "ONB:DATAINFO_LEN",   _datainfo_len );
    BNKDEF( "ONB:SUBIMG",         _subimg );
    BNKDEF( "ONB:SUBIMG_LEN",     _subimg_len );
    
    /* bnkput 'static' regions */ 
    BNKPUT( "ONB:MDPHDR",         _mdphdr );
    BNKPUT( "ONB:DATAINFO",       _datainfo );
    BNKPUT( "ONB:SUBIMG",         _subimg );
  }

  PUBLIC void bnkput() {
    BNKPUT( "ONB:MDPHDR_LEN",     _mdphdr_len );
    BNKPUT( "ONB:DATAINFO_LEN",   _datainfo_len );
    BNKPUT( "ONB:SUBIMG_LEN",     _subimg_len );
  }

  // getter

  PUBLIC byte getSubImg(int pos) const { 
    return _subimg[pos];     
  }

  // setter

  PUBLIC void setSubImg(int pos, byte value){ 
    _subimg[pos] = value;    
  }
  PUBLIC void setMdpHdr(int pos, byte value){ 
    _mdphdr[pos] = value;    
  }

  PUBLIC void setSubImgLen(int subimg_len){ 
    _subimg_len = subimg_len; 
  }
  PUBLIC void setDataInfoLen(int datainfo_len){ 
    _datainfo_len = datainfo_len; 
  }
  PUBLIC void setMdpHdrLen(int mdphdr_len){ 
    _mdphdr_len = mdphdr_len; 
  }
};

