class ImageDivParam {
  PUBLIC static final int AUTO = -1;
  PUBLIC static final int NA   = -1;
  PUBLIC static final int END  = -1;
  PUBLIC static final int OK   =  0;

  /* internal parameter (CCD readout direction setting) */
  PUBLIC enum {SMALL, LARGE} port[2];
  PUBLIC enum {XY, YX} direction;
private:
  /* fields in MDP header */
  int _datatype;     /* input parameter */
  int _packet_size;  /* automatically generated (or manual input) */
  int _packetno;     /* input parameter, automatically ++'ed */

  int _num_frame;    /* input parameter, or use fixed value */
  int _main_id;      /* input parameter, or use fixed value */
  int _main_sf;      /* input parameter, or use fixed value */
  int _main_sc;      /* input parameter, or use fixed value */

  int _num_packet;   /* input parameter */
  int _sub_id;       /* input parameter, or use fixed value */
  int _sub_sf;       /* automatically generated (or manual input) */
  int _sub_sc;       /* input parameter, automatically ++'ed */

  //  vect full;        /* calculated from FULL_X and FULL_Y */
  int _base[2];        /* input parameter */
  int _part[2];        /* input parameter */

  int _comp_code;    /* input parameter, or use fixed value */

  /* length of parts in MDP packet */
  int _datainfo_len;
  int _expinfo_len; /* input parameter */


  PUBLIC int  datatype()     const { return _datatype; }   
  PUBLIC int  packet_size()  const { return _packet_size; }
  PUBLIC int  packetno()     const { return _packetno; }

  PUBLIC int  main_id()      const { return _main_id; }
  PUBLIC int  num_frame()    const { return _num_frame; }
  PUBLIC int  main_sc()      const { return _main_sc; }
  PUBLIC int  main_sf()      const { return _main_sf; }

  PUBLIC int  sub_id()       const { return _sub_id; }
  PUBLIC int  num_packet()   const { return _num_packet; }
  PUBLIC int  sub_sc()       const { return _sub_sc; }
  PUBLIC int  sub_sf()       const { return _sub_sf; }

  PUBLIC int  comp_code()    const { return _comp_code; }

  PUBLIC int const PTR base()  const { return _base; } 
  PUBLIC int const PTR part()  const { return _part; } 

  PUBLIC int  datainfo_len() const { return _datainfo_len; }
  PUBLIC int  expinfo_len()  const { return _expinfo_len; }

  PUBLIC void IncrementBase() {
    boolean expinfo_packet = (expinfo_len() != NA);
    if ( !expinfo_packet ){
      _base[1] += ((port[1]==SMALL)?(+_part[1]):(-_part[1]));
    }
  }

  PUBLIC ImageDivParam(){
    port[0] = SMALL;  port[1] = SMALL;
    direction    =    YX;

    _datatype     =     0;
    _packet_size  =  AUTO;
    _packetno     =  AUTO;

    _num_frame    =     1;
    _main_id      =     0; 
    _main_sf      =     3; 
    _main_sc      =     0; 

    _num_packet   =     0; 
    _sub_id       =     0; 
    _sub_sf       =  AUTO; 
    _sub_sc       =  AUTO; 

    _base[0] = 0;  _base[1] = 0;
    _part[0] = 0;  _part[1] = 0;
  
    _comp_code    =     0; 

    _datainfo_len =     0;
    _expinfo_len  =    NA;
  }

  PUBLIC void show_parameters(){
    switch(direction){
    case XY:    printf("AXIS_ORDER      = XY\n"); break;
    case YX:    printf("AXIS_ORDER      = YX\n"); break;
    }
    printf("PORT            = ");
    if(port[0]==SMALL){ printf("SMALL "); } else
      if(port[0]==LARGE){ printf("LARGE "); }
    if(port[1]==SMALL){ printf("SMALL\n"); } else
      if(port[1]==LARGE){ printf("LARGE\n"); }

    printf("DATATYPE#       = 0x%02x\n", _datatype);
    if( _packetno == AUTO ) 
    printf("PACKETNO        = AUTO\n"); else
    printf("PACKETNO        = %d\n",     _packetno);
    if( _packet_size == AUTO ) 
    printf("PACKET_SIZE     = AUTO\n");  else
    printf("PACKET_SIZE     = %d\n",     _packet_size);

    printf("MAIN_ID#        = 0x%04x\n", _main_id);
    printf("NUM_FRAME       = %d\n",     _num_frame);
    printf("MAIN_SF         = %d\n",     _main_sf);
    printf("MAIN_SC         = %d\n",     _main_sc);

    printf("SUB_ID#         = 0x%04x\n", _sub_id);
    printf("NUM_PACKET      = %d\n",     _num_packet);
    if( _sub_sf == AUTO ) 
    printf("SUB_SF          = AUTO\n");  else
    printf("SUB_SF          = %d\n",     _sub_sf);
    if( _sub_sc == AUTO ) 
    printf("SUB_SC          = AUTO\n");  else
    printf("SUB_SC          = %d\n",     _sub_sc);

    printf("BASE            = %5d %5d\n", _base[0], _base[1]);
    printf("PART            = %5d %5d\n", _part[0], _part[1]);

    printf("COMP_CODE#      = 0x%04x\n", _comp_code);

    printf("DATAINFO_LEN    = %d\n",     _datainfo_len);
    printf("EXPINFO_LEN     = %d\n",     _expinfo_len);
  }

  PUBLIC int set_parameters(){
    _packet_size = AUTO;
    _packetno    = AUTO;
    _sub_sf      = AUTO;
    _sub_sc      = AUTO;

    _expinfo_len = NA; 

    for (;;) {
      char key[20], *p;
      int it;

      char *names[] = {
	"SHOW_PARAMETERS",
	"AXIS_ORDER",  "PORT", 

	"DATATYPE",  "DATATYPE#", "PACKETNO",
	"MAIN_ID",   "MAIN_ID#",  "NUM_FRAME",  "MAIN_SF",   "MAIN_SC",   
	"SUB_ID",    "SUB_ID#",   "NUM_PACKET", "SUB_SF",    "SUB_SC",
	"BASE",      "PART",
	"COMP_CODE", "COMP_CODE#",

	"DATAINFO_LEN", "EXPINFO_LEN", 
	"GENERATE_PACKET",
	"END"
      };
      CLkeyrd(-3, "?Set Parameters>", key, 
	      names, sizeof(names)/sizeof(*names), &it, sizeof(key));
      if        ( !strcmp(key, "SHOW_PARAMETERS")){
	show_parameters();

      } else if ( !strcmp(key, "AXIS_ORDER")    ) {
	char *names[] = { "XY", "YX" };
	CLkeyrd(-3, "?Set Order>", key, 
		names, sizeof(names)/sizeof(*names), &it, sizeof(key));
	if      ( !strcmp(key, "XY") ) { direction = XY; }
	else if ( !strcmp(key, "YX") ) { direction = YX; }

      } else if ( !strcmp(key, "PORT")        ) {
	char *names[] = { "SMALL", "LARGE" };
	CLkeyrd(-3, "?PORT[0]", key, 
		names, sizeof(names)/sizeof(*names), &it, sizeof(key));
	if      ( !strcmp(key, "SMALL") ) { port[0] = SMALL; } 
	else if ( !strcmp(key, "LARGE") ) { port[0] = LARGE; }
	CLkeyrd(-3, "?PORT[1]", key, 
		names, sizeof(names)/sizeof(*names), &it, sizeof(key));
	if      ( !strcmp(key, "SMALL") ) { port[1] = SMALL; }
	else if ( !strcmp(key, "LARGE") ) { port[1] = LARGE; }

      } else if( !strcmp(key, p="DATATYPE")     ){ CLintrd( p, &_datatype);
      } else if( !strcmp(key, p="DATATYPE#")    ){ CLhexrd( p, &_datatype);
      } else if( !strcmp(key, p="PACKETNO")     ){ CLintrd( p, &_packetno);

      } else if( !strcmp(key, p="MAIN_ID")      ){ CLintrd( p, &_main_id);
      } else if( !strcmp(key, p="MAIN_ID#")     ){ CLhexrd( p, &_main_id);
      } else if( !strcmp(key, p="NUM_FRAME")    ){ CLintrd( p, &_num_frame);
      } else if( !strcmp(key, p="MAIN_SF")      ){ CLintrd( p, &_main_sf);
      } else if( !strcmp(key, p="MAIN_SC")      ){ CLintrd( p, &_main_sc);

      } else if( !strcmp(key, p="SUB_ID")       ){ CLintrd( p, &_sub_id);
      } else if( !strcmp(key, p="SUB_ID#")      ){ CLhexrd( p, &_sub_id);
      } else if( !strcmp(key, p="NUM_PACKET")   ){ CLintrd( p, &_num_packet);
      } else if( !strcmp(key, p="SUB_SF")       ){ CLintrd( p, &_sub_sf);
      } else if( !strcmp(key, p="SUB_SC")       ){ CLintrd( p, &_sub_sc);

      } else if( !strcmp(key, "BASE")           ){ 
	CLintrd( "BASE[0]", &_base[0]); 
	CLintrd( "BASE[1]", &_base[1]);
      } else if( !strcmp(key, "PART")           ){ 
	CLintrd( "PART[0]", &_part[0]); 
	CLintrd( "PART[1]", &_part[1]);

      } else if( !strcmp(key, p="COMP_CODE")    ){ CLintrd( p, &_comp_code);
      } else if( !strcmp(key, p="COMP_CODE#")   ){ CLhexrd( p, &_comp_code);

      } else if( !strcmp(key, p="DATAINFO_LEN") ){ CLintrd( p, &_datainfo_len);
      } else if( !strcmp(key, p="EXPINFO_LEN")  ){ CLintrd( p, &_expinfo_len);

      } else if( !strcmp(key,"GENERATE_PACKET") ){ break;
      } else if( !strcmp(key,"END")             ){ return END;
      } else { fprintf(stderr, MODULE " possible bug in software\n"); exit(1);
      }
    }
    return OK;
  }
};
