/**************************************
 *  
 *  ImagePaste
 *
 *    2001/02/06  created 
 *    2001/08/01  version 0.3.3 by K.Matsuzaki
 *      PM integ version
 **************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <cli.h>
#include <bnk.h>
#include <bnkf.h>
#include <evs.h>
#include <anl.h>

#include <cc-java.h>
#include <solarb/sbstd.h>
#include <solarb/MdpPacket.h> /* input */
#include <solarb/Image.h>     /* output */

#define MODULE "ImagePaste:"

enum direction {XY, YX};
enum port {SMALL, LARGE};

class ImagePaste {

#include "ImagePasteBnkIn.cc"
#include "ImagePasteBnkOut.cc"

  ImagePasteBnkIn  _bi;
  ImagePasteBnkOut _bo;

  PUBLIC void init(){
    _bi = NEW ImagePasteBnkIn();
    _bo = NEW ImagePasteBnkOut();

    _bo.bnkdef();
    _bo.errdef();
  }

  void ana(int REF status){

    /* definition of instrument dependent variables */

    _bi.bnkget();

    //// result of checking is not feed backed into processing yet

    //////
 
    const int PTR full = _bi.getFull();
    const int PTR base = _bi.getBase();
    const int PTR part = _bi.getPart();

    enum direction direction;
    enum port  port[2];

    switch(_bi.getDataType() & 0xfe){
    case DATA_TYPE_FG: 
    case DATA_TYPE_SP: 
    case DATA_TYPE_EIS:
      direction = YX;
      port[0] = SMALL;       /* must be replaced with real value */
      port[1] = (base[1]<2048)?(SMALL):(LARGE);
      break;

    case DATA_TYPE_XRT:
      direction = XY;        /* must be replaced with real value */
      port[0] = SMALL;       /* must be replaced with real value */
      port[1] = SMALL;       /* must be replaced with real value */
      break;

    case DATA_TYPE_CT_REF:
    case DATA_TYPE_CT_LIV:
    case DATA_TYPE_CT_RES:
      status = ANL_SKIP;
      return;
    }

    const byte PTR subimg = _bi.getSubImg();

    /* initialization for output image */

    if( _bi.getSubSC() == 0 ){
      int opos=0;

      for(int ax2=0; ax2<full[1]; ax2++){
	for(int ax1=0; ax1<full[0]; ax1++){
	  _bo.setImage( 2*opos+0, toUByte( BLANK ) );
	  _bo.setImage( 2*opos+1, toUByte( BLANK ) );
	  opos++;
	}
      }
    }

    /* copy into output image */

    int omin0=-1, omax0=-1;
    int omin1=-1, omax1=-1;

    if(!_bi.expinfo_packet()){

      int ipos = 0;

      if( direction==XY ){ _bo.setFullXY(full[0], full[1]); }
      else               { _bo.setFullXY(full[1], full[0]); }

      for( int ax1=0; ax1<part[1]; ax1++ ){
	for( int ax0=0; ax0<part[0]; ax0++ ){
	  const int bx0 = base[0] + ((port[0]==SMALL)?(ax0):(part[0]-1-ax0));
	  const int bx1 = base[1] + ((port[1]==SMALL)?(ax1):(part[1]-1-ax1));

	  int opos;
	  if( direction==XY ){ opos = bx0 + bx1*full[0]; } 
	  else               { opos = bx1 + bx0*full[1]; }

	  int value;
	  value  = fromUByte(subimg[2*ipos+0]) << 8;
	  value += fromUByte(subimg[2*ipos+1]) << 0;

	  //// printf("%d %d %d %04x\n", ipos, ax0, ax1, value);
	  //// printf( "ImagePaste: (%d,%d) = %d\n", bx0, bx1, value);

	  if( fromUByte( _bo.getImage(2*opos+0) ) == BLANK && 
	      fromUByte( _bo.getImage(2*opos+1) ) == BLANK ){

	    _bo.setImage( 2*opos+0, toUByte( value >> 8 ) );
	    _bo.setImage( 2*opos+1, toUByte( value >> 0 ) );
	  }else{
	    if( omin0 == -1 && omin1 == -1 && omax0 == -1 && omax1 == -1 ){
	      omin0 = omax1 = bx0;
	      omin1 = omax1 = bx1;
	    }else{
	      if( omin0 > bx0 ) omin0 = bx0;
	      if( omax0 < bx0 ) omax0 = bx0;
	      if( omin1 > bx1 ) omin1 = bx1;
	      if( omax1 < bx1 ) omax1 = bx1;
	    }	    
	  }
	  ipos++;
	}
      }
    }

    if( omin0 == -1 && omin1 == -1 && omax0 == -1 && omax1 == -1 ){
      // ok
    }else{
      EvsSet(MODULE "ERR:OVERWRAP");
      errlog(MODULE " coordinate(%d,%d)-(%d,%d) is overwaping.\n",
	     omin0, omin1, omax0, omax1 );
    }
    _bo.setImageLen( full[0] * full[1] * 2 ); /* 2byte = 16bit */

    if( (_bi.getSubSF() & 2) == 0 ){
      status = ANL_SKIP;    
      return;
    }

    status = ANL_OK;    
    _bo.bnkput();
  }
};

/*
 * Linkage for slrb_anl
 */

extern "C" {
  char ImagePaste_version[] = "version 0.3.3";

  static class ImagePaste lc = NEW ImagePaste();

  void ImagePaste_init(int *status){ 
    lc.init();
    *status = ANL_OK;
  }
  void ImagePaste_ana(int nevent, int eventid, int *status){ 
    lc.ana( *status ); 
  }

  /* default functions */

  void ImagePaste_endrun (int *status){ 
    fflush(stdout);
    *status = ANL_OK; 
  }

  void ImagePaste_startup(int *status){ *status = ANL_OK; }
  void ImagePaste_com    (int *status){ *status = ANL_OK; }
  void ImagePaste_his    (int *status){ *status = ANL_OK; }
  void ImagePaste_bgnrun (int *status){ *status = ANL_OK; }
  void ImagePaste_exit   (int *status){ *status = ANL_OK; }
}

