/* - BnkGet */ 

#define BNKGET(a,b) { int size; BnkfGetM(a,sizeof(b),&size,&(b)); }
#define errlog printf

class ImagePasteBnkIn {

  // bnk-related variables

  int _datatype;      
  int _packetsize;
  int _packetno;

  int _main_id;
  int _num_frame;
  int _main_sf;       
  int _main_sc;       
  
  int _sub_id;
  int _num_packet;
  int _sub_sf;        
  int _sub_sc;        

  int _full[2];       
  int _base[2];       
  int _part[2];       

  int _comp_code;

  int _subimg_len;    byte PTR _subimg;   

  // getter

  PUBLIC int            getDataType() const { return _datatype; }
  // -- packetsize 
  // -- packetno   

  // -- mainid     
  // -- num_frame  
  PUBLIC int            getMainSF()   const { return _main_sf; }
  PUBLIC int            getMainSC()   const { return _main_sc; }

  // -- subid      
  // -- num_packet 
  PUBLIC int            getSubSF()    const { return _sub_sf; }
  PUBLIC int            getSubSC()    const { return _sub_sc; }

  PUBLIC int  const PTR getFull()     const { return _full; } 
  PUBLIC int  const PTR getBase()     const { return _base; } 
  PUBLIC int  const PTR getPart()     const { return _part; } 

  PUBLIC byte const PTR getSubImg()   const { return _subimg; }
  // -- subimg_len 

  // sequence counter related definitions

  static final int MAIN_SC_MAX = 0x3fff;
  static final int SUB_SC_MAX  = 0x3fff;

  static int COUNTUP(int x){ return (x+1)&0x3fff; }

  // getter functions for bnk-related variables

  PUBLIC boolean expinfo_packet() const { 
    switch(_datatype){
    case DATA_TYPE_FG: case DATA_TYPE_FG+1:
    case DATA_TYPE_SP: case DATA_TYPE_SP+1: 
      return (_main_sc == 0);
    default:
      return false;
    }
  }
  
  PUBLIC void bnkget() {
    BNKGET( "GND:MDP_DATATYPE",   _datatype );
    BNKGET( "GND:MDP_PACKETSIZE", _packetsize );
    BNKGET( "GND:PACKETNO",       _packetno );

    BNKGET( "GND:MAIN_ID",        _main_id );
    BNKGET( "GND:NUM_FRAME",      _num_frame );
    BNKGET( "GND:MAIN_SF",        _main_sf );
    BNKGET( "GND:MAIN_SC",        _main_sc );

    BNKGET( "GND:SUB_ID",         _sub_id );
    BNKGET( "GND:NUM_PACKET",     _num_packet );
    BNKGET( "GND:SUB_SF",         _sub_sf );
    BNKGET( "GND:SUB_SC",         _sub_sc );

    BNKGET( "GND:FULL1",          _full[0] );
    BNKGET( "GND:FULL2",          _full[1] );
    BNKGET( "GND:BASE1",          _base[0] );
    BNKGET( "GND:BASE2",          _base[1] );
    BNKGET( "GND:PART1",          _part[0] );
    BNKGET( "GND:PART2",          _part[1] );

    BNKGET( "GND:COMP_CODE",      _comp_code );

    BNKGET( "GND:SUBIMG",         _subimg );
    BNKGET( "GND:SUBIMG_LEN",     _subimg_len );
  }

};




