/* - BnkPut */ 

#define BNKDEF(a,b) BnkDef(a,sizeof(b))
#define BNKPUT(a,b) BnkfPutM(a,sizeof(b),&(b));

#define BLANK 0xff

class ImagePasteBnkOut {

  PRIVATE byte _arr_image[IMAGE_LEN]; 
  PRIVATE byte PTR _image; 
  PRIVATE int _image_len;
  PRIVATE int _full_x;
  PRIVATE int _full_y;

  // getter

  PUBLIC byte getImage(int pos) const { 
    if( pos >= IMAGE_LEN || pos < 0 ) return BLANK;
    return _image[pos];     
  }

  // setter

  PUBLIC void setImage(int pos, byte value){ 
    if( pos < IMAGE_LEN && pos >= 0 ) _image[pos] = value;    
  }
  PUBLIC void setImageLen(int image_len){ 
    _image_len = image_len; 
  }
  PUBLIC  void setFullXY(int full_x, int full_y){ 
    _full_x = full_x;
    _full_y = full_y;
  }

  // constructor

  PUBLIC  ImagePasteBnkOut() {
    _image = _arr_image;
  }

  PUBLIC  void bnkdef() {
    BNKDEF( "GND:IMAGE",          _image );
    BNKDEF( "GND:IMAGE_LEN",      _image_len );
    
    BNKDEF( "GND:FULL_X",         _full_x );
    BNKDEF( "GND:FULL_Y",         _full_y );
    
    /* bnkput 'static' regions */ 
    BNKPUT( "GND:IMAGE",          _image );
  }

  PUBLIC  void bnkput() {
    BNKPUT( "GND:IMAGE_LEN",      _image_len );

    BNKPUT( "GND:FULL_X",         _full_x );
    BNKPUT( "GND:FULL_Y",         _full_y );
  }

  PUBLIC  void errdef() {
    EvsDef(MODULE "ERR:OVERWRAP");
  }

  PUBLIC int anl_status(ImagePasteBnkIn const REF bi){
    if( (bi.getSubSC() & 2) == 0 ){
      return ANL_SKIP;    
    }
    return ANL_OK;    
  }

};

