/**************************************
 *
 *  JPEGcheck
 *
 *    2005/09/23  created by Keiichi Matsuzaki
 *
 **************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <cfortran.h>
#include <hbook.h>
#include <cli.h>
#include <com.h>
#include <bnkfm.h>
#include <anl.h>
#include <anl_misc.h>
#include "MdpPacket.h"
#include "OurJpeg.h"
#include "umsLibrary.h"

extern int OurJpeg_SOF;

char JPEGcheck_version[] = "version 20050920";

#define MODULE "JPEGcheck"

void JPEGcheck_init(int *status){ 
  tableTools_init();

  EvsDef( MODULE ":ERR");
  *status = ANL_OK;
}

void JPEGcheck_ana(int nevent, int eventid, int *status)
{
  unsigned char *cmpimg;
  int cmpimg_len;
  int img_comp_mode;
  /*
    char *gnd_mdphdr;
    int gnd_mdphdr_len;
  */
  int size,i;

  BnkGet("GND:CMPIMG",       sizeof(cmpimg),  &size, &cmpimg);
  BnkGet("GND:CMPIMG_LEN",   sizeof(cmpimg_len),  &size, &cmpimg_len);
  BnkGet("GND:IMG_COMP_MODE",   sizeof(img_comp_mode),  &size, &img_comp_mode);
  /*
  BnkfGetM("GND:MDPHDR",      sizeof(gnd_mdphdr),      &size, &gnd_mdphdr);
  BnkfGetM("GND:MDPHDR_LEN",  sizeof(gnd_mdphdr_len),  &size, &gnd_mdphdr_len);
  */

  if( img_comp_mode == 0 ){
    *status = ANL_OK;
    return;
  }
  {
    ums__state_t state;
    int bitlen;

    bitlen = cmpimg_len * 8;

    initException( &state );
    validateOurJpeg(cmpimg, bitlen, &state);
    if ( state.state != UMS__STATE_OK ) {
      int sta = state.spos/8 - 16;
      int end = state.spos/8 + 16;

      EvsSet( MODULE ":ERR");

      fprintf(stderr, "input(%d*8+%d):\n", bitlen/8, bitlen%8 );
      fprintException( stderr, &state );
      fprintf(stderr, "%s\n", getDetail( &state ) );

      if( sta < 0        ) sta = 0;
      if( end > bitlen/8 ) end = bitlen/8;

      for(i=sta;i<state.spos/8;i++){
	fprintf(stderr,"%02x ", cmpimg[i]);
      }
      fprintf(stderr,"\n");
      fprintf(stderr,"---\n");
      for(i=state.spos/8;i<end;i++){
	fprintf(stderr,"%02x ", cmpimg[i]);
      }
      fprintf(stderr,"\n");

      *status = ANL_SKIP;
      return;
    }
  }

  *status = ANL_OK;

  switch(img_comp_mode){
  case 2: /*  8bit DPCM */
    if( OurJpeg_SOF != 0xC3 ){ *status = ANL_SKIP; } break;
  case 3: /* 12bit DPCM */
    if( OurJpeg_SOF != 0xC3 ){ *status = ANL_SKIP; } break;
  case 6: /*  8bit DCT */
    if( OurJpeg_SOF != 0xC1 ){ *status = ANL_SKIP; } break;
  case 7: /* 12bit DCT */
    if( OurJpeg_SOF != 0xC1 ){ *status = ANL_SKIP; } break;
  default:
    *status = ANL_SKIP;
  }

  if( *status == ANL_SKIP ){
    EvsSet( MODULE ":ERR");
    fprintf(stderr, 
	    "SOF marker 0x%02x is not consitent with img comp mode %d\n",
	    OurJpeg_SOF, img_comp_mode );
  }

}

void JPEGcheck_exit   (int *status){ 
  tableTools_end();

  *status = ANL_OK; 
}

void JPEGcheck_startup(int *status){ *status = ANL_OK; }
void JPEGcheck_com    (int *status){ *status = ANL_OK; }
void JPEGcheck_his    (int *status){ *status = ANL_OK; }
void JPEGcheck_bgnrun (int *status){ *status = ANL_OK; }
void JPEGcheck_endrun (int *status){ *status = ANL_OK; }

