/**************************************
 *
 *  Packetize
 *
 *    2001/03/26  version 0.2.0 by K.Matsuzaki
 *      created
 *    2001/07/10  version 0.3.0 by K.Matsuzaki
 *      data source change (SUBIMG->CMPIMG)
 **************************************/

/*
 * This is a test module. Invalid parameter settings may 
 * cause troubles. Use carefully, please.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <bnkfm.h>
#include <anl.h>

#include <cc-java.h>
#include <solarb/MdpPacket.h>   /* input */
#include <solarb/CcsdsPacket.h> /* output */

#define MODULE "Packetize:"

char Packetize_version[] = "version 0.3.0";

/*
 * This is a test module. Invalid parameter settings may 
 * cause troubles. Use carefully, please.
 */

/* #define TEST 'D' */

class Packetize {

#include "PacketizeBnkIn.cc"
#include "PacketizeBnkOut.cc"

  PacketizeBnkIn  _bi;
  PacketizeBnkOut _bo;

  int _seqn_flag;
  int _rdpntr;
  int _endpos;

  double _sbtime;

  int _packet_count[9];

  PUBLIC void init(){
    _bi = NEW PacketizeBnkIn();
    _bo = NEW PacketizeBnkOut();

    _bo.bnkdef();
    _sbtime = 0.0;

    for( int i=0; i<9 ; i++ ) 
      _packet_count[i] = 0;
  }

  PUBLIC void ana(int REF status){
    int apid;

    _bi.bnkget();

    do{
      const int      mdphdr_len   = _bi.getMdpHdrLen();
      const int      datainfo_len = _bi.getDataInfoLen();
      const int      cmpimg_len   = _bi.getCmpImgLen();

      int datatype = fromUByte( _bi.getMdpHdr(0) );

      int id;
      switch(datatype){
      case DATA_TYPE_FG:     id=0; apid = SB_APID_FG_OBS;   break;
      case DATA_TYPE_FG+1:   id=1; apid = SB_APID_FG_OBS+1; break;
      case DATA_TYPE_SP:     id=2; apid = SB_APID_SP_OBS;   break;
      case DATA_TYPE_SP+1:   id=3; apid = SB_APID_SP_OBS+1; break;
      case DATA_TYPE_CT_REF: id=4; break; /* not yet supported */
      case DATA_TYPE_CT_LIV: id=5; break; /* not yet supported */
      case DATA_TYPE_CT_RES: id=6; break; /* not yet supported */
      case DATA_TYPE_XRT:    id=7; break; /* not yet supported */
      case DATA_TYPE_EIS:    id=8; break; /* not yet supported */
      }

      /* create user data of ccsds Packet */
      int packet_len = SBccsdsPacketCSize;
      if( _rdpntr >= _endpos ){

	/* no continuos data is available, now start new packet processing */
	_seqn_flag = 1;

	_rdpntr = 0;
	_endpos = cmpimg_len;

	for(int i=0; i<mdphdr_len;   i++)
	  _bo.setPacket(packet_len+i, _bi.getMdpHdr(i));
	packet_len += mdphdr_len;

	for(int i=0; i<datainfo_len; i++)
	  _bo.setPacket(packet_len+i, _bi.getDataInfo(i));
	packet_len += datainfo_len;

	/* packet_len < SBccsdsMaxPacketSize 
	   must be guaranteed in previous modules  */
      }else{
	_seqn_flag = 0;

	int size = _endpos - _rdpntr;
	if( size > SBccsdsMaxPacketSize - SBccsdsPacketCSize ) 
	  size = SBccsdsMaxPacketSize - SBccsdsPacketCSize; 
	/* i.e. 2034 bytes */

	for(int i=0; i<size; i++)
	  _bo.setPacket(packet_len+i, _bi.getCmpImg(_rdpntr+i));
	packet_len += size; _rdpntr += size;
      }
      _bo.setPacketLen( packet_len );

      _sbtime += 1.0/32; /* = 32msec, to be replaced with real value */
      long ti = (long) (_sbtime*32);

      if ( _rdpntr < _endpos ) { _seqn_flag |= 0; }
      else                     { _seqn_flag |= 2; }

      /* create header part of ccsds Packet */
      {
	_bo.setPacket(0, toUByte( apid >> 8 ));
	_bo.setPacket(1, toUByte( apid >> 0 ));
	_bo.setPacket(2, toUByte( _packet_count[id]>>8 ));
	_bo.setPacket(3, toUByte( _packet_count[id]>>0 ));

	_bo.fixSeqnFlag(_seqn_flag);
    
	_bo.setPacket(4, toUByte( packet_len>>8 ));
	_bo.setPacket(5, toUByte( packet_len>>0 ));

	/* secondary header */
	_bo.setPacket(6, toUByte( ti >> 24 ));
	_bo.setPacket(7, toUByte( ti >> 16 ));
	_bo.setPacket(8, toUByte( ti >>  8 )); 
	_bo.setPacket(9, toUByte( ti >>  0 )); 
      }

      _packet_count[id] ++;
    
      if ( (_seqn_flag & 2) == 0 ){
	status = ANL_NEWROOT; 
      }else{
	status = ANL_OK;
      }

#ifdef TEST 
      /* Modification of contents after bnkput is effective since
	 contents are transfered by pointer */
      
      test(status);
#else
      /* status is one of ANL_SKIP and ANL_NEWROOT; */
#endif
    } while( status == ANL_QUIT );

    if( status != ANL_SKIP ) _bo.bnkput();
  }


#ifdef TEST 
  /*
   * code for debuging of DePacketize  
   */
  void test(int REF status){ 

    static int c=0;

    switch( TEST ){
    case 'A':  /* force reset STRT_FLG */
      if( _seqn_flag == 1 ){ if( ++c == 2 ) _seqn_flag = 0; } break;

    case 'B':  /* force set STRT_FLG */
      if( _seqn_flag == 0 ){ if( ++c == 2 ) _seqn_flag = 1; } break;

    case 'C':  /* force set STOP_FLG */
      if( _seqn_flag == 0 ){ if( ++c == 2 ) _seqn_flag = 2; } break;

    case 'D':  /* force reset STOP_FLG */
      if( _seqn_flag == 2 ){ if( ++c == 2 ) _seqn_flag = 0; } break;

    case 'E':  /* drop a packet */
      if( ++c == 20 ){
	if( status == ANL_NEWROOT ) status = ANL_QUIT; // for restart
	else                        status = ANL_SKIP;  
      }
      break;

    case 'F':  /* drop a sequence of packets */
      if( ++c >= 20 && c<100 ) {
	if( status == ANL_NEWROOT ) status = ANL_QUIT; // for restart
	else                        status = ANL_SKIP; 
      }
      break;

    case 'G':  /* modified packet sequence counter */
      if( ++c == 20 ){ _packet[2] = _packet[3] = 0; } break;
      
    case 'H':  /* illeagal sequence flag */
      if( _seqn_flag == 2 ){ if( ++c == 2 ) _seqn_flag = 3; } break;

    }

    fixSeqnFlag();
  }
#endif


};


extern "C" {
  static class Packetize lc = NEW Packetize();

  void Packetize_init   (int *status){ 
    lc.init();
    *status = ANL_OK;
  }

  void Packetize_ana    (int nevent, int eventid, int *status){ 
    lc.ana( *status ); 
  }

  /* default functions */
  void Packetize_startup(int *status){ *status = ANL_OK; }
  void Packetize_com    (int *status){ *status = ANL_OK; }
  void Packetize_his    (int *status){ *status = ANL_OK; }
  void Packetize_bgnrun (int *status){ *status = ANL_OK; }
  void Packetize_endrun (int *status){ *status = ANL_OK; }
  void Packetize_exit   (int *status){ *status = ANL_OK; }
}





