/* - BnkPut */ 

#define BNKDEF(a,b) BnkDef(a,sizeof(b))
#define BNKPUT(a,b) BnkfPutM(a,sizeof(b),&(b));

class PacketizeBnkOut {
  byte _arr_packet[SBccsdsMaxPacketSize];
  byte PTR _packet;  int _packet_len;

  int _seqn_flag; /// should be removed

  int _rdpntr;    /// should be removed
  int _endpos;    /// should be removed

  PUBLIC PacketizeBnkOut() {
    _packet = _arr_packet;
  }

  PUBLIC void bnkdef(){
    BNKDEF( "SLRB:PACKET:PTR",       _packet );
    BNKDEF( "SLRB:PACKET:SIZE",      _packet_len );

    /* bnkput 'static' regions */ 
    BNKPUT( "SLRB:PACKET:PTR",       _packet );
  }

  PUBLIC void bnkput(){
    BNKPUT( "SLRB:PACKET:SIZE",      _packet_len );
  }

  // setter

  PUBLIC void setPacket(int pos, byte value){ 
    _packet[pos] = value;    
  }
  PUBLIC void setPacketLen(int packet_len){ 
    _packet_len = packet_len;
  }

  //

  PUBLIC void fixSeqnFlag(int seqn_flag){
    if( (seqn_flag & 1) != 0 ) _packet[2] |= 0x40; else _packet[2] &= 0xBF; 
    if( (seqn_flag & 2) != 0 ) _packet[2] |= 0x80; else _packet[2] &= 0x7F; 
  }
};




