/*
 *
 * dpcmdecomp.c
 * 
 * This is the main routine for the 12-bit Solar-B Mission Data Processor
 * (MDP) DPCM decoder. Large parts are stolen from ljpgtopnm.c.
 *
 *  Revision History
 *    0.10            2001.06.25    T.Shimizu
 *    0.20            2001.07.01    T.Shimizu
 *           remove dcInfo from DpcmDecomp. Initial release
 *
 *
 * ljpgtopnm.c --
 *
 * This is the main routine for the lossless JPEG decoder.  Large
 * parts are stolen from the IJG code, so:
 *
 * Copyright (C) 1991, 1992, Thomas G. Lane.
 * Part of the Independent JPEG Group's software.
 * See the file Copyright for more details.
 *
 * Copyright (c) 1993 Brian C. Smith, The Regents of the University
 * of California
 * All rights reserved.
 * 
 * Copyright (c) 1994 Kongji Huang and Brian C. Smith.
 * Cornell University
 * All rights reserved.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice and the following
 * two paragraphs appear in all copies of this software.
 * 
 * IN NO EVENT SHALL CORNELL UNIVERSITY BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF CORNELL
 * UNIVERSITY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * CORNELL UNIVERSITY SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND CORNELL UNIVERSITY HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */


#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>
#include "jpeg.h"
#include "mcu.h"
//// #include "proto.h"
#include "io.h"

/*
 * For Solar-B application
 * This is included for checking decompressed results.
 * Should be commented out
 *
 *extern int image_height;      
 *extern int image_width;    
 */


#include <stdio.h>

int DpcmDecompError;

void DpcmDecompErrorInit()
{
  DpcmDecompError = 0;
}

void DpcmDecompErrorSet(int errono)
{
  DpcmDecompError = errono;
}

int
DpcmDecomp (inputBuffer, numInputBytes, outputBuffer, numOutputBytes) 
    Uchar inputBuffer[];
    int numInputBytes;
    int outputBuffer[];
    int numOutputBytes;

{
    DecompressInfo dcInfo;

    GetJpegCharInit();

    MEMSET(&dcInfo, 0, sizeof(dcInfo));

    DpcmDecompErrorInit();

    /*
     * Read the JPEG File header, up to scan header, and initialize all
     * the variables in the decompression information structure.
     */
    ReadFileHeader (&dcInfo, inputBuffer, numInputBytes);
    if(DpcmDecompError != 0) return DpcmDecompError;

    /*
     * Loop through each scan in image. ReadScanHeader returns
     * 0 once it consumes and EOI marker.
     */
    if (!ReadScanHeader (&dcInfo, inputBuffer, numInputBytes)) {
	fprintf (stderr, "Empty JPEG file\n");
	//	exit(1);

	/*
	 * add by M.Kubo (2001-Aug-02)
	 */
	DpcmDecompErrorSet(1);
	return DpcmDecompError;
    }

    /* 
     * Write PPM or PGM image header. Decode the image bits
     * stream. Clean up everything when finished decoding.
     */

    /*
     *WritePmHeader(dcInfo);
     */
    DecoderStructInit(&dcInfo);
    if(DpcmDecompError != 0) return DpcmDecompError;

    HuffDecoderInit(&dcInfo);
    if(DpcmDecompError != 0) return DpcmDecompError;

    DecodeImage(&dcInfo,inputBuffer,numInputBytes,outputBuffer,numOutputBytes);
    if(DpcmDecompError != 0) return DpcmDecompError;


  /*
   * for Solar-B application
   * This is for checking the decompressed data
   * Should be commeted out
   *
   *image_width = dcInfo.imageWidth;
   *image_height = dcInfo.imageHeight;
   *fprintf(stderr, "Width%dHeight%d\n", image_width, image_height);
   */

    FreeArray2D(mcuROW1);
    FreeArray2D(mcuROW2);

    if (ReadScanHeader (&dcInfo, inputBuffer, numInputBytes)) {
	fprintf (stderr, "Warning: multiple scans detected in JPEG file\n");
	fprintf (stderr, "         not currently supported\n");
	fprintf (stderr, "         ignoring extra scans\n");
    }

    return DpcmDecompError;
}
