;+
; NAME: ccsds_packet__define.pro
;
; PURPOSE: Definition of the general ccsds packet structure
;
; CATEGORY: Science
;
; CALLING SEQUENCE: None
;
; INPUTS: None
;
; KEYWORD PARAMETERS: None
;
; OUTPUTS: None
;
; CALLS: None
;
; COMMON BLOCKS:None.
;
; PROCEDURE:
;
; RESTRICTIONS: Uses SolarSoft
;
; MODIFICATION HISTORY:
;	23/11/05 mcrw	wrote
;       14/08/06 mcrw	added documentation
;
;-


;pro ccsds_packet::set_primary_header_length, len
;  self.primary_hdr_len = len
;end

;function ccsds_packet::primary_header_length
;  return, self.primary_hdr_len
;end

;pro ccsds_packet::set_secondary_header_length, len
;  self.secondary_hdr_len = len
;end

;function ccsds_packet::secondary_header_length
;  return, self.secondary_hdr_len
;end

;pro ccsds_packet::set_endian, endian
;  self.endian = endian
;end

;function ccsds_packet::endian
;  return, self.endian
;end

;pro ccsds_packet::set_has_secondary_hdr, bool
;  self.has_secondary_hdr = bool
;end

;function ccsds_packet::has_secondary_hdr
;  return, self.has_secondary_hdr
;end

;function ccsds_packet::ccsds_header
;  return, self.ccsds_header
;end

;pro ccsds_packet::print_sequence_count
;  print, 'Sequence count ' + strtrim(string(self->get_sequence_count(), format='(Z4)'), 2)
;end

;function ccsds_packet::get_apid
;;  return, self.ccsds_header[0] * 256 or self.ccsds_header[1]
;  return, ((self.ccsds_header[0] and '07'x) * 256L) or self.ccsds_header[1]
;end

;function ccsds_packet::get_sequence_count
;  return, ((self.ccsds_header[2] and '3F'x) * 256L) or self.ccsds_header[3]
;;    return, ishft((self.ccsds_header[2] and '3F'x), 8) or self.ccsds_header[3]
;end

;function ccsds_packet::get_sequence_flag
;  byte2 = self.ccsds_header[2]
;;	print, 'BYTE2 = ', byte2, ishft(byte(byte2) and 'C0'x, -6)
;	
;  return, ishft(byte(byte2) and 'C0'x, -6)
;  return, ishft(self.ccsds_header[2], -6)
;end

;function ccsds_packet::is_start_packet_of_sequence
;  seq_flag = self->get_sequence_flag()
;  return, (seq_flag eq 3) or (seq_flag eq 1)
;end

;function ccsds_packet::is_end_packet_of_sequence
;  seq_flag = self->get_sequence_flag()
;  
;;	self->print_ccsds_header
;;	print,'seq_flag:', seq_flag
;  
;  return, (seq_flag eq 3) or (seq_flag eq 2)
;end

;function ccsds_packet::is_middle_packet_of_sequence
;  seq_flag = self->get_sequence_flag()
;  return, (seq_flag eq 3) or (seq_flag eq 0)
;end

;function ccsds_packet::get_user_data_length
;  return, (ishft(ulong(self.ccsds_header[4]), 8) or ulong(self.ccsds_header[5]))
;end

;function ccsds_packet::get_actual_user_data_length
;  error, 'subclass responsibility'
;  return, self->get_user_data_length() - 3
;end

;pro ccsds_packet::print_ccsds_header
;  self->trace, 'ccsds_packet::print_ccsds_header'
;  print, 'Ccsds Header: ', string(self.ccsds_header, format = '(Z02)')
;end

;function ccsds_packet::read_ccsds_md_header, lu, header
;;  print, 'ccsds_packet::read_ccsds_md_header'
;  self->trace, 'ccsds_packet::read_ccsds_md_header'
;  error = self->read_ccsds_packet_header(lu)
;  if error then return, 0
;;  foo = bytarr(8)
;;  readu, lu, foo
;  readu, lu, header
;  header = swap_endian(header)
;;;;  byteorder, header, /big_endian
;;;;print,header
;  return, 1
;end

;function ccsds_packet::read_ccsds_packet, lu, packet, with_apid=with_apid, payload_only=payload_only
;;  print, 'ccsds_packet::read_ccsds_packet'
;  self->trace, 'ccsds_packet::read_ccsds_packet'
;  error = self->read_ccsds_packet_header(lu)
;  if error then return, 0
;  ;if error then return, error
;  error = self->read_ccsds_payload(lu, buffer)
;  if error then return, 0
;  if keyword_set(payload_only) then begin
;	  packet = buffer
;  endif else begin
;  	packet = [self.ccsds_header, buffer]
;  endelse
;  
;  ;self.ccsds_payload = buffer
;  
;  if KEYWORD_SET(with_apid) then begin
;    more = 1
;    while (more) do begin
;      if self->get_apid() eq with_apid then return, 1
;;;;      error = self->read_ccsds_packet_header(lu, buffer)
;      error = self->read_ccsds_packet_header(lu)
;      if error then return, 0
;      ;if error then return, error
;      error = self->read_ccsds_payload(lu, buffer)
;      if error then return, 0
;      if keyword_set(payload_only) then packet = buffer $
;      else packet = [self.ccsds_header, buffer]
;   endwhile
; endif else return, 1
;;  return, not error
;end

;function ccsds_packet::read_ccsds_packet_header, lu
;;  print, 'ccsds_packet::read_ccsds_packet_header'
;  self->trace, 'ccsds_packet::read_ccsds_packet_header'
;  on_ioerror, bad_hdr_rd
;
;  hdr = self.ccsds_header
;  readu, lu, hdr
;;;;;;;;;;  if self.debug then print, hdr
;  
;  self.ccsds_header = hdr
;  return, 0
;;    return, n_elements(hdr)
;
;  bad_hdr_rd:
;  if eof(lu) then begin
;     print, 'ccsds_packet::read_ccsds_packet_header : END OF FILE found'
;     ;self->set_errors, 2, !SYSERROR, !ERR_STRING
;     ; GDL
;     self->set_errors, 2, 1, !ERR_STRING
;     return, 1
;  endif
;  ;self->set_errors, 1, !SYSERROR, !ERR_STRING
;  ; GDL
;  self->set_errors, 2, 2, !ERR_STRING
;  print, 'ccsds_packet::read_ccsds_packet_header: bad_hdr_rd', hdr
;  print, !err_string
;  return, 2
;end

;function ccsds_packet::read_ccsds_payload, lu, buffer
;;  print, 'ccsds_packet::read_ccsds_payload'
;  self->trace, 'ccsds_packet::read_ccsds_payload'
;  on_ioerror, bad_data_rd
;
;  data_length = self->get_actual_user_data_length()
;  data = bytarr(data_length)
;  readu, lu, data
;  buffer = data
;  ;self.ccsds_payload = buffer
;  return, 0
;
;  bad_data_rd:
;  if eof(lu) then begin
;     print, 'ccsds_packet::read_ccsds_payload : END OF FILE found'
;     ;self->set_errors, 2, !SYSERROR, !ERR_STRING
;     ; GDL
;     self->set_errors, 2, 1, !ERR_STRING
;     return, 1
;  endif
;  ;self->set_errors, 1, !SYSERROR, !ERR_STRING
;  ; GDL
;  self->set_errors, 2, 2, !ERR_STRING
;  print, 'ccsds_packet::read_ccsds_payload: bad_data_rd'
;  print, !err_string
;  return, 2
;end

;pro eis_ccsds_packet::tidy_up
;    self->close_files
;end

;pro ccsds_packet::report, lun
;print, 'Report'
;;    self->debug
;end

;pro ccsds_packet::debug
;    print, 'ccsds_packet::debug'
;    self->base_object::debug
;    prefix = 'ccsds_packet.'
;    print, prefix + 'primary_hdr_len   : ' + strtrim(string(self.primary_hdr_len), 2)
;    print, prefix + 'has_secondary_hdr : ' + strtrim(string(self.has_secondary_hdr), 2)
;    print, prefix + 'secondary_hdr_len : ' + strtrim(string(self.secondary_hdr_len), 2)
;    print, prefix + 'endian            : ' + '''' + self.endian + ''''
;    print, prefix + 'debug             : ' + strtrim(string(self.debug), 2)
;end

;pro ccsds_packet::initialise
;  print, 'ccsds_packet::initialise'
;;  self->clear_errors
;;  self->base_object::initialise
;end

;function ccsds_packet::INIT, debug=debug
;  COMPILE_OPT IDL2
;  print, 'ccsds_packet::INIT'
;  foo = self->base_object::INIT()
;  if keyword_set(debug) then self.debug = 1
;  self.primary_hdr_len = 6
;  ;self.primary_hdr_len = ccsds_constants.primary_header_length
;  ;self.primary_hdr_len = ccsds_constants.primary_header_length()
;  self.endian = 'big'
;  return, 1
;end

pro ccsds_packet__define
  print, 'ccsds_packet__define'
  struct = { ccsds_packet,		     $
             inherits base_object,           $
;             ccsds_header      : bytarr(10), $
             ccsds_header      : bytarr(6), $
;             ccsds_payload     : bytarr(2048), $
;             ccsds_payload     : bytarr(0), $
             primary_hdr_len   : 0,          $
             has_secondary_hdr : 0,          $
             secondary_hdr_len : 0,          $
             has_ancillary_data_field  : 0,  $
             ancillary_data_field_leng : 0,  $
             has_time_code_field       : 0,  $
             time_code_field_len       : 0,  $
             endian            : '',         $
             debug             : 0}
end
