;+
; NAME: ccsds_packet__define.pro
;
; PURPOSE: Definition of the general ccsds packet structure
;
; CATEGORY: Science
;
; CALLING SEQUENCE: None
;
; INPUTS: None
;
; KEYWORD PARAMETERS: None
;
; OUTPUTS: None
;
; CALLS: None
;
; COMMON BLOCKS:None.
;
; PROCEDURE:
;
; RESTRICTIONS: Uses SolarSoft
;
; MODIFICATION HISTORY:
;	23/11/05 mcrw	wrote
;       14/08/06 mcrw	added documentation
;
;-

function ccsds_packet::read_ccsds_packet, lu, packet, with_apid=with_apid, payload_only=payload_only
;  print, 'ccsds_packet::read_ccsds_packet'
  self->trace, 'ccsds_packet::read_ccsds_packet'
  error = self->read_ccsds_packet_header(lu)
  if error then return, 0
  ;if error then return, error
  error = self->read_ccsds_payload(lu, buffer)
  if error then return, 0
  if keyword_set(payload_only) then begin
;     print, 'CCSDS_PACKET::READ_CCSDS_PACKET /payload_only'
     if self.has_secondary_hdr then begin
        n = n_elements(buffer)
        packet = buffer[self.secondary_hdr_len:n-self.secondary_hdr_len-1]
     endif else begin
        packet = buffer
     endelse
  endif else begin
     packet = [self.ccsds_header, buffer]
;;;     print, 'CCSDS_PACKET::READ_CCSDS_PACKET all data'
  endelse
  
  ;self.ccsds_payload = buffer
  
  if KEYWORD_SET(with_apid) then begin
    more = 1
    while (more) do begin
      if self->get_apid() eq with_apid then return, 1
;;;      error = self->read_ccsds_packet_header(lu, buffer)
      error = self->read_ccsds_packet_header(lu)
      if error then return, 0
      ;if error then return, error
      error = self->read_ccsds_payload(lu, buffer)
      if error then return, 0
      if keyword_set(payload_only) then packet = buffer $
      else packet = [self.ccsds_header, buffer]
   endwhile
 endif else return, 1
;  return, not error
end
