;+
; NAME: eis_ccsds_reader__define.pro
;
; PURPOSE: Definition of the EIS ccsds packet structure
;
; CATEGORY: Science
;
; CALLING SEQUENCE: None
;
; INPUTS: None
;
; KEYWORD PARAMETERS: None
;
; OUTPUTS: None
;
; CALLS: None
;
; COMMON BLOCKS:None.
;
; PROCEDURE:
;
; RESTRICTIONS: Uses SolarSoft
;
; MODIFICATION HISTORY:
;	23/11/05 mcrw	wrote
;       14/08/06 mcrw	added documentation
;
;-

; Open a file for reading. No error checking yet.
;function eis_ccsds_reader::open_for_reading, fname
;  openr, file_unit, fname, /get_lun, error=err
;  if err ne 0 then return, 0  ; Set error here
;  self.file_unit = file_unit
;  self->set_file_name, fname
;  self->clear_errors
;;  fs = fstat(file_unit)
;;  print, 'FS.SIZE = ', fs.size
;  return, 1
;end
;
;pro eis_ccsds_reader::close_input
;  on_ioerror, bad_lun
;
;  lu = self.file_unit
;  close, lu, /force
;  free_lun, lu
;  bad_lun:
;end
;
;pro eis_ccsds_reader::close_files
;  print, 'eis_ccsds_reader::close_files'
;  self->close_input
;end
;
;function eis_ccsds_reader::number_of_packets
;  return, self.number_of_packets
;end
;
;function eis_ccsds_reader::increment_previous_seq_count
;  return, (self.previous_seq_count + 1L) and '3FFF'x
;end
;
;function eis_ccsds_reader::last_packet_of_sequence
;	return, *(self.ccsds_packet)->is_end_packet_of_sequence()
;end
;
;function eis_ccsds_reader::read_ccsds_header, keep=keep
;  lu  = self.file_unit
;  error = self->read_ccsds_packet_header(lu)
;  if error then return, 0
;  if keyword_set(keep) then begin
;    self.first_ccsds_header = hdr
;    self.previous_seq_count = seq_count
;    print, 'read_ccsds_header : KEEPING'
;    self->print_sequence_count
;    return, 1
;  endif
;end
;
;;   on_ioerror, bad_hdr_rd
;;
;;   lu  = self.file_unit
;;   hdr = self.ccsds_header
;;   readu, lu, hdr
;;   self.ccsds_header = hdr
;;   ret_val = 1
;;
;;   seq_count = self->get_sequence_count()
;;   if keyword_set(keep) then begin
;;      self.first_ccsds_header = hdr
;;      self.previous_seq_count = seq_count
;;         print, 'read_ccsds_header : KEEPING'
;;         self->print_sequence_count
;;      return, 1
;;   endif
;;
;;   ;self->print_sequence_count
;;   ;next_seq_count = self->increment_previous_seq_count()
;;   ;if seq_count ne next_seq_count then begin
;;   ;   print, 'eis_ccsds_reader::read_ccsds_header: bad sequence count, found ' + $
;;   ;          strtrim(string(seq_count, format = '(Z4)'), 2) + $
;;   ;          ' expecting ' + $
;;   ;          strtrim(string(self->increment_previous_seq_count(), format = '(Z4)'), 2)
;;   ;   number_missing = self->calculate_number_missing(seq_count, next_seq_count)
;;   ;   self.missing_packets = 1
;;   ;   self.missing_packet_count = self.missing_packet_count + number_missing
;; ;        self->set_errors, 3, !SYSERROR, !ERR_STRING
;;   ;   ret_val = 2
;;   ;endif
;;
;;   self.previous_seq_count = seq_count
;;   return, ret_val
;; ;    return, n_elements(hdr)
;;
;;   bad_hdr_rd:
;;   if eof(lu) then begin
;;      print, 'eis_ccsds_reader : END OF FILE found'
;;      ;self->set_errors, 2, !SYSERROR, !ERR_STRING
;;      ; GDL
;;      self->set_errors, 2, 1, !ERR_STRING
;;      return, 0
;;   endif
;;   ;self->set_errors, 1, !SYSERROR, !ERR_STRING
;;   ; GDL
;;   self->set_errors, 2, 2, !ERR_STRING
;;   print, 'eis_ccsds_reader::read_ccsds_header: bad_hdr_rd', hdr
;;   print, !err_string
;;   return, 0
;;end
;
;; pro eis_ccsds_reader::read_user_data, buffer
;;   on_ioerror, bad_data_rd
;;
;;   lu = self.file_unit
;;   data_length = self->get_actual_user_data_length()
;;   data = bytarr(data_length)
;;   readu, lu, data
;;   buffer = data
;;   return
;;
;; bad_data_rd:
;;   print, 'eis_ccsds_reader::read_user_data: bad data read'
;;   if eof(lu) then print, 'END OF FILE'
;;   ;self->set_errors, 10, !SYSERROR, !ERR_STRING
;;   buffer = data
;; end
;
;; function eis_ccsds_reader::read_next_packet, buffer
;;   ;print, 'eis_ccsds_reader::read_next_packet'
;;   if self->read_ccsds_header() then begin
;;     self->read_user_data, buffer
;;     return, 1
;;   endif
;;     return, 0
;; end
;;
;function eis_ccsds_reader::read_md_header, header
;;  print, 'eis_ccsds_reader::read_md_header'
;  self->trace, 'eis_ccsds_reader::read_md_header'
;  on_ioerror, bad_md_hdr_read
;
;  lu = self.file_unit
;  error = *(self.ccsds_packet)->read_ccsds_md_header(lu, header)
;;  h = bytarr(10)
;;  readu, lu, h
;;  readu, lu, header
;  return, error
;
;  bad_md_hdr_read:
;  return,1
;end
;
; function eis_ccsds_reader::next_packet, packet, with_apid=with_apid, payload_only=payload_only
;;   print, 'eis_ccsds_reader::next_packet'
;   self->trace, 'eis_ccsds_reader::next_packet'
;   lu = self.file_unit
;
;   ;;;error = self->read_ccsds_packet(lu, packet, with_apid=with_apid)
;   error = *(self.ccsds_packet)->read_ccsds_packet(lu, packet, with_apid=with_apid, payload_only=payload_only)
;
;   ;packet = [self.ccsds_header, self.ccsds_payload]
;   ;print, 'eis_ccsds_reader::next_packet : error = ', error
;   self.number_of_packets = self.number_of_packets + 1
;   return, error
;   ;return, self->eis_ccsds_interface::next_packet(lu, packet, with_apid=with_apid)
; end
;;   if KEYWORD_SET(with_apid) then begin
;;     ;print, 'Looking for 0x' + strtrim(string(with_apid, format='(Z04)'))
;;     more = 1
;;     while (more) do begin
;;       if self->read_next_packet(buffer) then begin
;;         ;print, 'APID = 0x' + strtrim(string(self->get_apid(), format = '(Z04)'), 2)
;;         if self->get_apid() eq with_apid then begin
;;           packet = [self.ccsds_header, buffer]
;;           ;print, 'Found packet'
;;           return, 1
;;         endif
;;       endif else begin
;;         ;print, 'Not right packet'
;;         return, 0
;;       endelse
;;     endwhile
;;   endif else begin
;;     if self->read_next_packet(buffer) then begin
;;     ;if self->read_ccsds_header() then begin
;;     ;  self->read_user_data, buffer
;;       packet = [self.ccsds_header, buffer]
;;       return, 1
;;     endif else begin
;;       return, 0
;;     endelse
;;   endelse
;; end
;
;function eis_ccsds_reader::first_ccsds_header
;  return, self.first_ccsds_header
;end
;
;; Read packets until end of sequence (exposure)
;;pro eis_ccsds_reader::read_exposure_data, buffer, success
;;  self->clear_errors
;;  self.missing_packet_count = 0
;;  success = 0
;;  if self->read_ccsds_header() gt 0 then begin
;;     self->read_user_data, data
;;     good = (self.io_error eq 0)
;;     if not good then return
;;     more = not self->is_end_packet_of_sequence()
;;     while good and more do begin
;;        if self->read_ccsds_header() gt 0 then begin
;;           self->read_user_data, dat
;;           good = (self.io_error eq 0)
;;           if good then begin
;;              data = [data, dat]
;;           endif
;;           more = not self->is_end_packet_of_sequence()
;;        endif else begin
;;           print, 'eis_ccsds_reader::read_exposure_data : bad ccsds header read detected'
;;           good = 0
;;           return
;;        endelse
;;     endwhile
;;     buffer  = data
;;     success = 1
;;  endif
;;end
;
;;function eis_ccsds_reader::packet
;;  return, [self.ccsds_header, self.ccsds_payload]
;;end
;
;;pro eis_ccsds_reader::clear_errors
;;  self->eis_ccsds_interface::clear_errors
;;end
;
;pro eis_ccsds_reader::clear_counters
;  self.previous_seq_count = 0
;  self.number_of_packets = 0
;end
;
;pro eis_ccsds_reader::rewind
;  point_lun, self.file_unit, 0
;end
;

;pro eis_ccsds_reader::debug
;  print, 'eis_ccsds_reader::debug'
;  self->ccsds_reader::debug
;  prefix = 'eis_ccsds_reader.'
;;  print, prefix + 'eis_ccsds_reader.first_ccsds_header   : ', string(self.first_ccsds_header, format='(Z02)')
;;  print, prefix + 'eis_ccsds_reader.file_unit            : ', self.file_unit
;;  print, prefix + 'eis_ccsds_reader.previous_seq_count   : ', string(self.previous_seq_count, format='(Z04)')
;end

;pro eis_ccsds_reader::CLEANUP
;  print, 'eis_ccsds_reader::CLEANUP'
;  self->close_files
;end

;pro eis_ccsds_reader::initialise
;;print,'eis_ccsds_reader::initialise'
;  self->trace, 'eis_ccsds_reader::initialise'
;  self->ccsds_reader::initialise
;;  self->clear_errors
;;  self->clear_counters
;;;;;  self->eis_ccsds_interface::initialise, ' '
;end

;function eis_ccsds_reader::INIT, name, version
;  print,'eis_ccsds_reader::INIT'
;;  self->trace, 'eis_ccsds_reader::INIT'
;  foo = self->ccsds_reader::INIT(name, version, 'eis_ccsds_packet')
;  return, 1
;end

pro eis_ccsds_reader__define
  print, 'eis_ccsds_reader__define'
  struct = { eis_ccsds_reader, $

    inherits ccsds_reader }

end
