;+
; NAME: eis_gap_ccsds_reader__next_packet.pro
;
; PURPOSE: Definition of the EIS ccsds packet structure
;
; CATEGORY: Science
;
; CALLING SEQUENCE: None
;
; INPUTS: packet
;
; KEYWORD PARAMETERS: with_apid, payload_only
;
; OUTPUTS: packet
;
; RETURNS: 
;
; CALLS: Super class method.
;
; COMMON BLOCKS:None.
;
; PROCEDURE:
;
; RESTRICTIONS: If reading a status packet archive then gaps will only
; be detected when using the with_apid keyword set to a packet apid
; which uses the ccsds packet sequence count field properly.
; If reading a mission packet archive then the with_apid keyword is redundant.
;
; MODIFICATION HISTORY:
;	23/11/05 mcrw	wrote
;       14/08/06 mcrw	added documentation
;
;-

function eis_gap_ccsds_reader::next_packet, packet, with_apid=with_apid, payload_only=payload_only

  previous_seq_count = self.seq_count
  error = self->eis_ccsds_reader::next_packet(packet, with_apid=with_apid, payload_only=payload_only)
  current_seq_count = self.seq_count
;  print, 'Previous seq count = ', previous_seq_count, ', Current seq
;  count = ', current_seq_count
  if self.number_of_packets ne 1 then begin
     if (current_seq_count - previous_seq_count) ne 1 then begin
        packet = *(self.ccsds_packet)
;        help, packet
        ; either next line or the next work
;        if *(self.ccsds_packet)->get_sys_error() ne 1 then begin
        if packet->get_sys_error() ne 1 then begin

; these lines don't
;        if *(*(packet).sys_err_code[1]) ne 1 then begin
;        if *(self.ccsds_packet)->sys_err_code[1] ne 1 then begin
;        if *(packet.sys_err_code[1]) ne 1 then begin
           print, 'GAP DETECTED ', current_seq_count, ', ', previous_seq_count
        endif
     endif
  endif
  
  return, error

  return, self->eis_ccsds_reader::next_packet(packet, with_apid=with_apid, payload_only=payload_only)
  lu = self.file_unit
  error = self->read_ccsds_packet(lu, packet, with_apid=with_apid)
  return, error
end
