;+
; NAME: ccsds_writer__define.pro
;
; PURPOSE: Definition of the EIS ccsds packet structure
;
; CATEGORY: Science
;
; CALLING SEQUENCE: None
;
; INPUTS: None
;
; KEYWORD PARAMETERS: None
;
; OUTPUTS: None
;
; CALLS: None
;
; COMMON BLOCKS:None.
;
; PROCEDURE:
;
; RESTRICTIONS: Uses SolarSoft
;
; MODIFICATION HISTORY:
;	23/11/05 mcrw	wrote
;       14/08/06 mcrw	added documentation
;
;-

pro ccsds_writer::create_packet, buffer, first=first, last=last
  if keyword_set(first) then begin
     bytes_left = 267
     seq_flag = '40'X
  endif else begin
     if keyword_set(last) then begin
        pix_count = n_elements(buffer)
        bytes_left = (pix_count * 2) + 3
        seq_flag = '80'X
     endif else begin
        bytes_left = self->max_user_data()
        seq_flag = 0
     endelse
  endelse
  hdr = self.ccsds_header
  self->set_ccsds_header_flags, hdr, seq_flag, bytes_left
;    hdr[2] = seq_flag
;    hdr[2] = hdr[2] or ishft(scount, -8)
;    hdr[3] = scount and 255
;    hdr[4] = ishft((bytes_left and 65280), -8)	; MSB length
;    hdr[5] = bytes_left and 255			; LSB length
  self.ccsds_header = hdr
  lu = self.file_unit
  writeu, lu, hdr
  writeu, lu, buffer
end
