;+
; NAME: ccsds_writer__define.pro
;
; PURPOSE: Definition of the EIS ccsds packet structure
;
; CATEGORY: Science
;
; CALLING SEQUENCE: None
;
; INPUTS: None
;
; KEYWORD PARAMETERS: None
;
; OUTPUTS: None
;
; CALLS: None
;
; COMMON BLOCKS:None.
;
; PROCEDURE:
;
; RESTRICTIONS: Uses SolarSoft
;
; MODIFICATION HISTORY:
;	23/11/05 mcrw	wrote
;       14/08/06 mcrw	added documentation
;
;-

; Open a file for writing. No error checking yet.
;function ccsds_writer::open_for_writing, fname
;  print, 'ccsds_writer::open_for_writing'
;  openw, file_unit, fname, /get_lun, error=err
;  self.file_unit = file_unit
;  self->set_file_name, fname
;  self.error = 0
;  return, 1
;end

;pro ccsds_writer::close_output
;  on_ioerror, bad_lun
;
;  lu = self.file_unit
;  close, lu, /force
;  free_lun, lu
;
;  bad_lun:
;end

;pro ccsds_writer::close_files
;  self->close_output
;end

; Really is 2032
;function ccsds_writer::max_user_data
;  return, 2035
;end

;pro ccsds_writer::set_ccsds_header_flags, hdr, seq_flag, scount, bytes_left
;  hdr[2] = seq_flag
;  hdr[2] = hdr[2] or ishft(scount, -8)
;  hdr[3] = scount and 255
;  hdr[4] = ishft((bytes_left and 65280), -8)	; MSB length
;  hdr[5] = bytes_left and 255			; LSB length
;end

;pro ccsds_writer::write_packet, packet
;  lu = self.file_unit
;  writeu, lu, packet
;end

;pro ccsds_writer::create_packet, buffer, first=first, last=last
;  scount = self.seq_count
;  if keyword_set(first) then begin
;     bytes_left = 267
;     seq_flag = '40'X
;  endif else begin
;     if keyword_set(last) then begin
;        pix_count = n_elements(buffer)
;        bytes_left = (pix_count * 2) + 3
;        seq_flag = '80'X
;     endif else begin
;        bytes_left = self->max_user_data()
;        seq_flag = 0
;     endelse
;  endelse
;  hdr = self.ccsds_header
;  self->set_ccsds_header_flags, hdr, seq_flag, scount, bytes_left
;;    hdr[2] = seq_flag
;;    hdr[2] = hdr[2] or ishft(scount, -8)
;;    hdr[3] = scount and 255
;;    hdr[4] = ishft((bytes_left and 65280), -8)	; MSB length
;;    hdr[5] = bytes_left and 255			; LSB length
;  self.ccsds_header = hdr
;  lu = self.file_unit
;  writeu, lu, hdr
;  writeu, lu, buffer
;  self->increment_seq_count, scount
;end

;pro ccsds_writer::sync, first_ccsds_hdr
;  print,'ccsds_writer::sync', first_ccsds_hdr
;  self.ccsds_header = first_ccsds_hdr
;  seq_count_msb = first_ccsds_hdr[2] and '3F'X
;  seq_count_lsb = first_ccsds_hdr[3]
;  self.seq_count = ishft(fix(seq_count_msb), 8) or fix(seq_count_lsb)
;end

;pro ccsds_writer::increment_seq_count, scount
;  scount = scount + 1
;  scount = scount and '3FFF'X
;  self.seq_count = scount
;end

;pro ccsds_writer::next_output_header, data_size
;  self->increment_seq_count
;;        self->update_ccsds_header, pixels_left
;end

;pro ccsds_writer::debug
;  print, 'ccsds_writer::debug'
;  self->ccsds_interface::debug
;  print, 'seq_count : ', self.seq_count
;end

;pro ccsds_writer::initialise
;print, 'ccsds_writer::initialise'
;  self.seq_count = 0
;  self->ccsds_interface::initialise, ' '
;end

;function ccsds_writer::INIT, name, version
;  print, 'ccsds_writer::INIT'
;  ;foo = self->ccsds_interface::INIT('dummy_basename')
;  self.seq_count = 0L
;  return, 1
;end

pro ccsds_writer__define

  struct = { ccsds_writer, $
             seq_count : 0L,            $
             ccsds_header : bytarr(10), $
             inherits ccsds_interface }
    
end
