;+
; NAME: ccsds_writer__define.pro
;
; PURPOSE: Definition of the EIS ccsds packet structure
;
; CATEGORY: Science
;
; CALLING SEQUENCE: None
;
; INPUTS: None
;
; KEYWORD PARAMETERS: None
;
; OUTPUTS: None
;
; CALLS: None
;
; COMMON BLOCKS:None.
;
; PROCEDURE:
;
; RESTRICTIONS: Uses SolarSoft
;
; MODIFICATION HISTORY:
;	23/11/05 mcrw	wrote
;       14/08/06 mcrw	added documentation
;
;-

pro ccsds_writer::set_ccsds_header_flags, hdr, seq_flag, bytes_left
  scount = self.seq_count
  self->increment_seq_count, scount
  scount = self.seq_count
  hdr[2] = seq_flag
  hdr[2] = hdr[2] or ishft(scount, -8)
  hdr[3] = scount and 255
  hdr[4] = ishft((bytes_left and 65280), -8)	; MSB length
  hdr[5] = bytes_left and 255			; LSB length
end
