;+
; NAME: eis_md_decompressor__define.pro
;
; PURPOSE: Definition of the EIS ccsds packet structure
;
; CATEGORY: Science
;
; CALLING SEQUENCE: None
;
; INPUTS: None
;
; KEYWORD PARAMETERS: None
;
; OUTPUTS: None
;
; CALLS: None
;
; COMMON BLOCKS:None.
;
; PROCEDURE:
;
; RESTRICTIONS: Uses SolarSoft
;
; MODIFICATION HISTORY:
;	23/11/05 mcrw	wrote
;       14/08/06 mcrw	added documentation
;
;-

; Check the number of data bytes matches the number in the md header
function eis_md_decompressor::data_good, hdr, dat, ok
  if self.verbose_level then print, 'eis_md_decompressor::data_good'
  ret = 1
  pkt_size  = (ishft(long(hdr[9]),16)) or (ishft(long(hdr[10]),8)) or hdr[11]
  pkt_size  = pkt_size - 264
  num_bytes = n_elements(dat)
  if ((num_bytes ne pkt_size) or (ok eq 0)) then begin
     ret = 0
     dat = intarr(pkt_size/2)
  endif
  return, ret
end

