;+
; NAME: eis_md_decompressor__define.pro
;
; PURPOSE: Definition of the EIS ccsds packet structure
;
; CATEGORY: Science
;
; CALLING SEQUENCE: None
;
; INPUTS: None
;
; KEYWORD PARAMETERS: None
;
; OUTPUTS: None
;
; CALLS: None
;
; COMMON BLOCKS:None.
;
; PROCEDURE:
;
; RESTRICTIONS: Uses SolarSoft
;
; MODIFICATION HISTORY:
;	23/11/05 mcrw	wrote
;       14/08/06 mcrw	added documentation
;
;-

pro eis_md_decompressor::debug
  self->trace, 'eis_md_decompressor::debug'

  prefix = 'eis_md_decompressor.'
  print, 'eis_md_decompressor debug:'
  print, prefix + 'version                 : ' + self.decompressor_version
  print, prefix + 'version                 : ' + self.version
  print, prefix + 'logger_filename         : ' + *self.local_logger->file_name()
  print, prefix + 'log_dir                 : ' + self.log_dir
  print, prefix + 'source_file             : ' + self.source_file
  print, prefix + 'compressed_file         : ' + self.compressed_file
  print, prefix + 'compressed_files_count  : ' + strtrim(string(self.compressed_files_count), 2)
  print, prefix + 'out_file                : ' + self.out_file
;  print, prefix + 'start_sid               : ' + string(self.start_sid, format='(Z04)')
  print, prefix + 'start_number            : ' + string(self.start_number, format='(Z08)')
  print, prefix + 'hdr_filename            : ' + self.hdr_filename
  print, prefix + 'raw_image_filename      : ' + self.raw_image_filename
  print, prefix + 'decomped_image_filename : ' + self.decomped_image_filename
  print, prefix + 'basename                : ' + self.basename
  print, prefix + 'decompression_program   : ' + self.decompression_program
  print, prefix + 'ctype                   : ' + self.ctype
  print, prefix + 'decompressed_dest       : ' + self.decompressed_dest
  print, prefix + 'fail                    : ' + strtrim(string(self.fail), 2)
;  print, prefix + 'io_error                : ' + strtrim(string(self.io_error), 2)
  print, prefix + 'compression             : ' + strtrim(string(self.compression, format='(Z4)'), 2)
  print, prefix + 'tables                  : ''' + self.tables + ''''
  print, prefix + 'integers_in_count       : ' + strtrim(string(self.integers_in_count), 2)
  print, prefix + 'integers_out_count      : ' + strtrim(string(self.integers_out_count), 2)
  print, prefix + 'percent_comp            : ' + strtrim(string(self.percent_comp, format = '(F5.2)'), 2) + '%'
  print, prefix + 'compression_factor      : ' + strtrim(string(self.compression_factor, format = '(F5.2)'), 2)
  print, prefix + 'mdppmdctrecover_fix     : ' + self.mdppmdctrecover_fix
  print, prefix + 'rescued                 : ' + strtrim(string(self.rescued), 2)
  print, prefix + 'total_md_packets        : ' + strtrim(string(self.total_md_packets), 2)
  print, prefix + 'total_ccsds_packets     : ' + strtrim(string(self.total_ccsds_packets), 2)
  print, prefix + 'packets_per_exposure    : ' + strtrim(string(self.packets_per_exposure), 2)
  print, prefix + 'exposures               : ' + strtrim(string(self.exposures), 2)
;    print, prefix + 'packet_sizes            : ', self.packet_sizes
;;;  print, prefix + 'missing ccsds packets   : ' + strtrim(string(*self.raster->missing_ccsds_packets()), 2)
  print, prefix + 'raw_directory           : ' + self.raw_directory
  print, prefix + 'image_directory         : ' + self.image_directory
  print, prefix + 'header_directory        : ' + self.header_directory
  print, prefix + 'period                  : ' + self.period
  print, prefix + 'verbose_level           : ' + strtrim(string(self.verbose_level), 2)

;  *self.raster->debug
;    *self.md_writer->debug

  stop
  
end
