;+
; NAME: eis_md_decompressor__define.pro
;
; PURPOSE: Definition of the EIS ccsds packet structure
;
; CATEGORY: Science
;
; CALLING SEQUENCE: None
;
; INPUTS: None
;
; KEYWORD PARAMETERS: None
;
; OUTPUTS: None
;
; CALLS: None
;
; COMMON BLOCKS:None.
;
; PROCEDURE:
;
; RESTRICTIONS: Uses SolarSoft
;
; MODIFICATION HISTORY:
;	23/11/05 mcrw	wrote
;       14/08/06 mcrw	added documentation
;
;-

pro eis_md_decompressor__define

  struct = { eis_md_decompressor,                           $
             decompressor_version    : '',                  $

             main_logger             : ptr_new(obj_new()),  $
             local_logger            : ptr_new(obj_new()),  $

             master_dir              : '', $
             log_dir                 : '', $
             main_log                : '', $
             local_log               : '', $

             raster                  : ptr_new(obj_new()),  $

             ccsds_reader            : ptr_new(obj_new()),  $

             md_packet_reader        : ptr_new(obj_new()),  $
             md_writer               : ptr_new(obj_new()),  $

             jpeg_table              : bytarr(8),           $
             jpeg_types              : strarr(8),           $

             files_decompressed      : list(),              $
             
             compressed_files_count  : 0L,                  $ ; Count of number of files to decompress
             file_number             : 0L,                  $ ; Current file of total being processed
             start_number            : 0L,                  $ ; Packet number of first md header
             end_number              : 0L,                  $ ; Packet number of last md header
             start_msf               : 0U,                  $ ; Main sequence flag of first md header
             end_msf                 : 0U,                  $
             start_msc               : 0U,                  $ ; Main sequence count of first md header
             end_msc                 : 0U,                  $
             start_sid               : 0U,                  $ ; SID of first md header
             end_sid                 : 0U,                  $
             start_ssf               : 0U,                  $ ; Sub Sequence flag of first md header
             end_ssf                 : 0U,                  $
             start_T1                : 0UL,                 $ ; SID of first md header
             end_T1                  : 0UL,                 $
             start_T2                : 0UL,                 $ ; SID of first md header
             end_T2                  : 0UL,                 $
             start_MHC               : 0UL,                 $ ; SID of first md header
             end_MHC                 : 0UL,                 $
             start_FMIR              : 0U,                  $ ; SID of first md header
             end_FMIR                : 0U,                  $
             compressed_file         : ' ',	            $ ; Pathname of compressed file
             source_file             : ' ',	            $ ; ?
             out_file                : ' ',                 $ ; ?
             hdr_filename            : ' ',                 $ ; Files containing md hdrs
             raw_image_filename      : ' ',                 $ ; raw output, input to decompression routine
             decomped_image_filename : ' ',                 $ ; Output filename used by c programs
             basename                : ' ',                 $ ; Basename of compressed ccsds file
             decompression_program   : ' ',                 $
             ctype                   : ' ',                 $
             ctab                    : bytarr(8),           $
             decompressed_dest       : ' ',                 $ ; Where to move output to
             fail                    : 0,                   $
             mdppmdctrecover_fix     : ' ',                 $
;             io_error                : 0,                   $
             compression             : 0L,                  $
             integers_in_count       : 0L,                  $
             integers_out_count      : 0L,                  $
             percent_comp            : 0.0,                 $
             compression_factor      : 0.0,                 $
             tables                  : '',                  $

             total_md_packets        : 0L,                  $
             total_ccsds_packets     : 0L,                  $
             packets_per_exposure    : 0L,                  $
             exposures               : 0L,                  $ ; Per file
             total_exposures         : 0L,                  $ ; Per batch
             pe                      : 0,                   $ ; Mission data packets per exposure
             packet_sizes            : lonarr(8),           $ ; Packet sizes
             rescued                 : 0,                   $
             raw_directory           : ' ',                 $
             image_directory         : ' ',                 $
             header_directory        : ' ',                 $
             output_directory        : ' ',                 $
             period                  : ' ',                 $
             use_idl_save            : 0,                   $
             verbose_level           : 0, $
           inherits sys_if_object }

end
