;+
; NAME: eis_md_decompressor__define.pro
;
; PURPOSE: Definition of the EIS ccsds packet structure
;
; CATEGORY: Science
;
; CALLING SEQUENCE: None
;
; INPUTS: None
;
; KEYWORD PARAMETERS: None
;
; OUTPUTS: None
;
; CALLS: None
;
; COMMON BLOCKS:None.
;
; PROCEDURE:
;
; RESTRICTIONS: Uses SolarSoft
;
; MODIFICATION HISTORY:
;	23/11/05 mcrw	wrote
;       14/08/06 mcrw	added documentation
;
;-
function eis_md_decompressor::INIT, logger, plan_dates, verbose_level=verbose_level, rescued=rescued, trace=trace
  print, 'eis_md_decompressor::INIT'

  self.decompressor_version = '0.1b'
  self.version = '0.1b'

  if keyword_set(rescued) then self.rescued = 1 else self.rescued = 0
  if keyword_set(verbose_level) then self.verbose_level = verbose_level else self.verbose_level = 0
  if keyword_set(trace) then self.trace_on

  if keyword_set(trace) then begin
     print, 'Trace set'
;     stop
  endif else begin
     print, 'Trace not set'
;     stop
  endelse
  
;  self->set_verbose, 1

;  log_dir = getenv('HOME') + '/Hinode/decompression'
;  log_name = log_dir + '/decompression_' + plan_dates + '_log.txt'
;
;  logger = ptr_new(obj_new('eis_logger'))
;  print, 'Got logger'
;
;  res = *logger->open_log(log_name, /append)
;  print, 'Opened log', res

  self.local_logger = logger
  self.log_dir = FILE_DIRNAME(*logger->file_name()) + path_sep()

;;;  self.ccsds_reader = ptr_new(obj_new('eis_ccsds_reader', '1', 'eis_ccsds_packet'))
;;;;;  self.ccsds_reader = ptr_new(obj_new('eis_ccsds_reader', 'ccsds_reader', '1', 'eis_ccsds_packet', trace=trace))

;  self.ccsds_reader = ptr_new(obj_new('eis_gap_ccsds_reader', 'FOO', '1', trace=trace))
  self.md_packet_reader = ptr_new(obj_new('eis_md_packet_reader', self.local_logger, verbose=verbose_level, trace=trace))

;;;;;  self.md_writer = ptr_new(obj_new('eis_md_writer'))

;  self.raster = ptr_new(obj_new('eis_md_raster', logname, verbose=verbose))
;  self.raster = ptr_new(obj_new('eis_md_raster', verbose=verbose))
;  self.md_writer = ptr_new(obj_new('eis_md_writer'))
;    (*self.md_reader)->initialise, verbose_level=verbose_level
;    (*self.md_writer)->initialise, verbose_level=verbose_level
;  (*self.raster_reader)->initialise
;  (*self.md_writer)->initialise

  self.period = plan_dates
  
  self.jpeg_table[0] = 98
  self.jpeg_table[1] = 90
  self.jpeg_table[2] = 75
  self.jpeg_table[3] = 50
  self.jpeg_table[4] = 95
  self.jpeg_table[5] = 92
  self.jpeg_table[6] = 85
  self.jpeg_table[7] = 65

  self.jpeg_types[0] = '98'
  self.jpeg_types[1] = '90'
  self.jpeg_types[2] = '75'
  self.jpeg_types[3] = '50'
  self.jpeg_types[4] = '95'
  self.jpeg_types[5] = '92'
  self.jpeg_types[6] = '85'
  self.jpeg_types[7] = '65'

  self.compressed_files_count = 0
;  self.fail       = 0

  self.use_idl_save = 1

  base = getenv('HOME') + '/work/localdata/md/decompression/'
  self.raw_directory    = base + 'raw/'
  self.image_directory  = base + 'image/'
  self.header_directory = base + 'header/'
  self.output_directory = base + 'output/'
  self.source_file      = self.raw_directory + 'raw_*'

  self.files_decompressed = list('')
  return, 1
end
