;+
; NAME: eis_md_decompressor__define.pro
;
; PURPOSE: Definition of the EIS ccsds packet structure
;
; CATEGORY: Science
;
; CALLING SEQUENCE: None
;
; INPUTS: None
;
; KEYWORD PARAMETERS: None
;
; OUTPUTS: None
;
; CALLS: None
;
; COMMON BLOCKS:None.
;
; PROCEDURE:
;
; RESTRICTIONS: Uses SolarSoft
;
; MODIFICATION HISTORY:
;	23/11/05 mcrw	wrote
;       14/08/06 mcrw	added documentation
;
;-

pro eis_md_decompressor::log_report
  self->trace, 'eis_md_decompressor::log_report'

  prefix = 'eis_md_decompressor.'
  
;  *(self.local_logger)->logm, prefix + 'logger_filename         : ' + *self.local_logger->file_name()
;  *(self.local_logger)->logm, prefix + 'log_dir                 : ' + self.log_dir
;  *(self.local_logger)->logm, prefix + 'source_file             : ' + self.source_file
  *(self.local_logger)->logm, prefix + 'compressed_file         : ' + self.compressed_file
  *(self.local_logger)->logm, prefix + 'out_file                : ' + self.out_file
  *(self.local_logger)->logm, prefix + 'start_number            : ' + string(self.start_number, format='(Z08)')
  *(self.local_logger)->logm, prefix + 'hdr_filename            : ' + self.hdr_filename
  *(self.local_logger)->logm, prefix + 'raw_image_filename      : ' + self.raw_image_filename
  *(self.local_logger)->logm, prefix + 'decomped_image_filename : ' + self.decomped_image_filename
  *(self.local_logger)->logm, prefix + 'basename                : ' + self.basename
  *(self.local_logger)->logm, prefix + 'decompression_program   : ' + self.decompression_program
  *(self.local_logger)->logm, prefix + 'ctype                   : ' + self.ctype
  *(self.local_logger)->logm, prefix + 'tables                  : ' + self.tables
  *(self.local_logger)->logm, prefix + 'decompressed_dest       : ' + self.decompressed_dest
  *(self.local_logger)->logm, prefix + 'fail                    : ' + strtrim(string(self.fail), 2)
  ; Not in struct
  ;*(self.local_logger)->logm, prefix + 'io_error                : ' + strtrim(string(self.io_error), 2)
  *(self.local_logger)->logm, prefix + 'compression             : ' + strtrim(string(self.compression, format='(Z4)'), 2)
  *(self.local_logger)->logm, prefix + 'integers_in_count       : ' + strtrim(string(self.integers_in_count), 2)
  *(self.local_logger)->logm, prefix + 'integers_out_count      : ' + strtrim(string(self.integers_out_count), 2)
  *(self.local_logger)->logm, prefix + 'percent_comp            : ' + strtrim(string(self.percent_comp, format = '(F5.2)'), 2) + '%'
  *(self.local_logger)->logm, prefix + 'compression_factor      : ' + strtrim(string(self.compression_factor, format = '(F5.2)'), 2)
  *(self.local_logger)->logm, prefix + 'mdppmdctrecover_fix     : ' + self.mdppmdctrecover_fix
  *(self.local_logger)->logm, prefix + 'rescued                 : ' + strtrim(string(self.rescued), 2)
  *(self.local_logger)->logm, prefix + 'total_md_packets        : ' + strtrim(string(self.total_md_packets), 2)
  *(self.local_logger)->logm, prefix + 'total_ccsds_packets     : ' + strtrim(string(self.total_ccsds_packets), 2)
  *(self.local_logger)->logm, prefix + 'packets_per_exposure    : ' + strtrim(string(self.packets_per_exposure), 2)
  *(self.local_logger)->logm, prefix + 'exposures               : ' + strtrim(string(self.exposures), 2)
;    print, prefix + 'packet_sizes            : ', self.packet_sizes
;;;  print, prefix + 'missing ccsds packets   : ' + strtrim(string(*self.raster->missing_ccsds_packets()), 2)
;  *(self.local_logger)->logm, prefix + 'raw_directory           : ' + self.raw_directory
;  *(self.local_logger)->logm, prefix + 'image_directory         : ' + self.image_directory
;  *(self.local_logger)->logm, prefix + 'header_directory        : ' + self.header_directory
;  *(self.local_logger)->logm, prefix + 'period                  : ' + self.period
;  *(self.local_logger)->logm, prefix + 'verbose_level           : ' + strtrim(string(self.verbose_level), 2)

  (*(*(self.md_packet_reader)->md_packet())->md_header())->log_items, *(self.local_logger)
  print, prefix + 'start_sid               : ' + string(self.start_sid, format='(Z04)')
  *(self.local_logger)->log, ' '
  
;  *self.raster->debug
;    *self.md_writer->debug
end


