



pro eis_md_decompressor::record_decompression_program, header
  self->trace, 'eis_md_decompressor::record_decompression_program'
  
  ; Set path to the decompression programs
;  eis_bin = getenv('EIS_BIN')

  ;
  ; Where to write the de-packetized
  ; compressed exposures (mission data packets)
  ;
;  self.raw_image_filename = self.raw_directory + self.basename

  ;
  ; Where to put and get the decompressed exposures
  ;
;  self.decomped_image_filename = self.image_directory + self.basename
  ;
  ; Where to write each mission packet data header
  ;
;  self.hdr_filename = self.header_directory + self.basename

  ; Set decompression method string
;  self.decompression_program = ''

  ;
  ; Get the compression word from the md header
  ;
  comp = header->compression_code()
  self.compression = comp
  if (comp and '700'X) eq '700'X then begin
     self->set_decompression_program, 'jpeg_decompress'
     jpeg_type = self->determine_jpeg_type(comp)
     self.ctype = 'JPEG_' + jpeg_type
  endif else begin
     if (comp and '0300'x) eq '0300'x then begin
        self->set_decompression_program, 'dpcm_decompress'
        self.ctype = 'DPCM'
     endif
  endelse
  
                                ;
  ; Final packet archive destination
  ;
;  if self.rescued then begin
;;        dest = getenv('HOME') + '/work/localdata/sdtp/rescued/decompressed/'
;;        dest = '/home/matt/tmp/decompressed/'
;     dest = '/Users/mcrw/tmp/decompressed/'
;  endif else begin
;;        dest = getenv('HOME') + '/work/localdata/sdtp/decompressed/'
;;        dest = '/home/matt/tmp/decompressed/'
;     dest = '/Users/mcrw/tmp/decompressed/'
;  endelse
;  self.decompressed_dest = dest
;  self.out_file = dest + self.basename
end
