;+
; NAME: eis_md_decompressor__define.pro
;
; PURPOSE: Definition of the EIS ccsds packet structure
;
; CATEGORY: Science
;
; CALLING SEQUENCE: None
;
; INPUTS: None
;
; KEYWORD PARAMETERS: None
;
; OUTPUTS: None
;
; CALLS: None
;
; COMMON BLOCKS:None.
;
; PROCEDURE:
;
; RESTRICTIONS: Uses SolarSoft
;
; MODIFICATION HISTORY:
;	23/11/05 mcrw	wrote
;       14/08/06 mcrw	added documentation
;
;-

; Use packet number and sid to make a filename and save the mission data header
; in that file
pro eis_md_decompressor::save_md_header, hdr, sid, pkt_num
  self->verbose, 'eis_md_decompressor::save_md_header', 1
  self.compressed_files_count = self.compressed_files_count + 1 ; ???
  pkt_str = self->make_filename_suffix(sid, pkt_num)
  print, 'eis_md_decompressor::save_md_header : saving packet number ' + pkt_str
  file_name = self.header_directory + self.basename + pkt_str
  print, 'Saving header to ' + file_name
  ;;;;;;
  if self.use_idl_save eq 1 then begin
     ;;;;;;
     save, hdr, filename = file_name
     ;;;;;;
  endif else begin
     openw, lun, file_name, /get_lun
     writeu, lun, hdr
     close, lun
     free_lun, lun
  endelse
  ;;;;;;
end

