pro eis_md_decompressor::update_stats
  self->trace, 'eis_md_decompressor::report'

  if self->succeeded() then begin

     openw, lun, self.log_dir + '/decompress_record.txt', /get_lun, /append

     dint_in  = double(self.integers_in_count)
     dint_out = double(self.integers_out_count)
     percent  = (dint_in / dint_out) * 100.0
     factor   = dint_out / dint_in

     self.percent_comp = percent
     self.compression_factor = factor
     
     print, format='(A26, 2(A15), 2(A10), A6, A10, A20)', $
            'Source file','Ints in','Ints out','Comp %','Factor','Type','Method','Comp table'
     
     print, format='(A26, 2(I15), 2(D10.2), Z6, A10, "  [",8(Z02),"]")', $
            self.basename,                $
            self.integers_in_count,       $
            self.integers_out_count,      $
            percent,                      $
            factor,                       $
            self.compression,             $
            self.ctype,                   $
;;;            *self.raster->ctab()
            self.ctab
     
     printf, lun, format='(A26, 2(I15), 2(D10.2), Z6, A10, "  [",8(Z02),"]")', $
             self.basename,                $
             self.integers_in_count,       $
             self.integers_out_count,      $
             percent,                      $
             factor,                       $
             self.compression,             $
             self.ctype,                   $
;;;             *self.raster->ctab()
             self.ctab
     
     close, lun
     free_lun, lun
     
  end else begin
     openw, rat, self.log_dir + '/development_decomp_failure_record.txt', /get_lun, /append
     self->failure_report, rat
     close, rat
     free_lun, rat
  endelse
  
end
