;+
; NAME: eis_md_decompressor__define.pro
;
; PURPOSE: Definition of the EIS ccsds packet structure
;
; CATEGORY: Science
;
; CALLING SEQUENCE: None
;
; INPUTS: None
;
; KEYWORD PARAMETERS: None
;
; OUTPUTS: None
;
; CALLS: None
;
; COMMON BLOCKS:None.
;
; PROCEDURE:
;
; RESTRICTIONS: Uses SolarSoft
;
; MODIFICATION HISTORY:
;	23/11/05 mcrw	wrote
;       14/08/06 mcrw	added documentation
;
;-

pro eis_md_decompressor::write_new_archive
  if self.verbose_level then print,'eis_md_decompressor::write_new_archive : start'
  res = *self.md_writer->open_for_writing(self.out_file)
  if res eq 0 then begin
     print,'eis_md_decompressor::write_new_archive : can''t open output'
;;;        self->debug
     stop
  endif
;  *self.md_writer->sync, *self.raster->first_ccsds_header()
  pe = 0
  count = 0
  if self.compressed_files_count eq 0 then stop
  sid = self.start_sid
  pkt_num = self.start_number
;;;;;;  goto, skip
  while count lt self.compressed_files_count do begin
    ; Access current sid's data
;     sid_str = string(sid, format='(Z04)')
;     pkt_num_str = string(pkt_num, format='(Z08)')
     ; get mdhdr from mdhdr file
     pkt_num_str = self->make_filename_suffix(sid, pkt_num)
;;;     if self->get_header(pkt_num, sid_str, md_hdr) then begin
     if self->get_header(pkt_num_str, md_hdr) then begin
       ; open decompressed data file and read data
;;;        self->get_data, pkt_num, sid_str, data, ok
        self->get_data, pkt_num_str, data, ok
        ; check num pixels equals num in header
        if self->data_good(md_hdr, data, ok) then begin
          ; do bit decompression on data
           self->bit_decompress, data, bit_data
        endif else bit_data = data
        ; write out new mission data packet
        *self.md_writer->write_packet, md_hdr, bit_data
        self->update_out_count, n_elements(bit_data) ; in ints
        ; next file
        count = count + 1
        pkt_num = pkt_num + 1
     endif else begin
        ; Write out a dummy md packet
        ; need mid, sid (got) and other parameters
        ; No such packet with this packet number, try next number
        pkt_num = pkt_num + 1
     endelse
     sid = sid + 1 ;;; AAAARRRGGGHHH!!!!!
  endwhile
skip:
  *self.md_writer->close_output
  self->verbose,'eis_md_decompressor::write_new_archive : end', 1
end

