;;;pro mdppmdctrecover_test, hdr, cmp_data, fix_string
pro mdppmdctrecover_test, cmp_data, comp_code

; debug
  print, 'mdppmdctrecover start'
  help, cmp_data
;  print, ' header:', hdr
;  return
  
; The cmp_data contains the entire data for a single mission data
; packet. It is a vector of unsigned bytes.
; hdr is the icu mission data header
; Format of the data:
;    462 bytes jpeg information
;      N bytes image pixels
;

  ; Variable to control data return if the fix is required
  fix_applied = 0

  ; Get the total size of the incoming data
  cmp_data_size = ulong(n_elements(cmp_data))
  help,cmp_data_size

    ; Make the ground mdp header. Remove first 8 bytes,
    ; compression table (not needed)
;  gnd_mdphdr = hdr[8:*]

;    image_start = 32
    ;left over from previous attempt when cmp_data was assumed to
    ;hold the gnd mdp hdr (which was incorrect). Will tidy up later
;    image_start = 0

    ; The comp_code is the last 2 bytes of the mdp header
;  comp_code = ishft(uint(gnd_mdphdr[30]), 8) + gnd_mdphdr[31]

;debug
  comp_code_str = string(comp_code, format='(Z)')
  print,'comp_code = ' + comp_code_str

    ; Determine which compression has been used
  dctbl  = ishft(comp_code, -3) and 3
  dpcm12 = (ishft(comp_code, -8) and 7) eq 3
  dct12  = (ishft(comp_code, -8) and 7) eq 7

; debug
  print, 'dctbl, dpcm12, dct12 = ', dctbl, dpcm12, dct12

  if dct12 then begin
;     if ( ((cmp_data[6] and 4) ne 0) and ((cmp_data['99'X] and 4) ne 0) ) then begin
        print, 'RECOVER: dct12 QTABLE'
        fix_string = 'QTABLE'
                                ; No need to set fix variable as this modifies the input directly
                                ; and is copied to cpm_img if further fixing is required.
        cmp_data[6]     = cmp_data[6] and 'FB'X
        cmp_data['99'X] = cmp_data['99'X] and 'FB'X
;     endif
  endif
  
; debug
  print, 'dpcm12 or dct12 = ', dpcm12 or dct12
  print, 'dctbl eq 0 = ', dctbl eq 0
  print, 'dctbl eq 2 = ', dctbl eq 2
  
  if ( (dpcm12 or dct12) and $
       ((dctbl eq 0) or (dctbl eq 2)) ) then begin
;;;         (dctbl eq 1) ) then begin

    ; EIS uses jpeg compression codes 0x3F28 to 0x3F2F inclusive
    ; According to the code this will never make dctbl eq 0
    ; or eq 2. The test above will always fail so no dct
    ; recovery can take place. This will not fix the EIS
    ; problem.
    ; Testing for dctbl eq 1 makes the test succeed but then
    ; djpeg reports the error: Bogus DHT index 12 and fails.

        ; Set the fix variable
     fix_applied = 1

        ; Make a new vector with 4 extra bytes
     cmp_img = bytarr(cmp_data_size + 4)

        ; Copy the original data into the new vector
     cmp_img[0:cmp_data_size - 1] = cmp_data[0:*]

     if dpcm12 then begin
        print, 'RECOVER: DPCM'
        fix_string = fix_string + ' DPCM'
                                ; memmove(cmpimg+0x3a, cmpimg+0x36, cmpimg_len-0x36);
                                ;         dest,        src,         size
;            cmp_img['3A'X:cmp_data_size - 1 - '36'X] = cmp_data['36'X:cmp_data_size - 1 - '36'X]
        cmp_img['3A'X:*] = cmp_data['36'X:*]
        
        cmp_img['18'X] = '23'X
        cmp_img['23'X] = '01'X
        cmp_img['24'X] = '01'X
        cmp_img['25'X] = '01'X
        cmp_img['26'X] = '01'X
        cmp_img['36'X] = '0C'X
        cmp_img['37'X] = '0D'X
        cmp_img['38'X] = '0E'X
        cmp_img['39'X] = '0F'X
     endif
     
     if dct12 then begin
        print, 'RECOVER: DCT'
        fix_string = fix_string + ' DCT'
                                ; memmove(cmpimg+0xbf, cmpimg+0xbb, cmpimg_len-0xbb);
;            cmp_img['BF'X:cmp_data_size - 1 - 'BB'X] = cmp_data['BB'X:cmp_data_size - 1 - 'BB'X]
        cmp_img['BF'X:*] = cmp_data['BB'X:*]
        
        cmp_img['9D'X] = '26'X
        cmp_img['A8'X] = '01'X
        cmp_img['A9'X] = '01'X
        cmp_img['AA'X] = '01'X
        cmp_img['AB'X] = '01'X
        cmp_img['BB'X] = '0C'X
        cmp_img['BC'X] = '0D'X
        cmp_img['BD'X] = '0E'X
        cmp_img['BE'X] = '0F'X
     endif
     
                                ; c code with no required idl equivalent now
                                ; cmpimg_len += 4;
                                ; BnkfPutM("GND:CMPIMG_LEN",
                                ; sizeof(cmpimg_len), &cmpimg_len);
     
  endif
  
;    if join then cmp_data = [gnd_mdphdr, cpm_img]
  if fix_applied then cmp_data = cmp_img
  
; debug
  print, 'mdppmdctrecover end'
  
end
