
pro eis_aocs1_reformatter::unpack_aocs1_status_parameters, packet_data_array, p0, p1, p2, p3, p4, p5
  self->trace, 'eis_aocs1_reformatter::unpack_aocs1_status_parameters'

  ; p2v5 = self->pad_data(packet_data_array.p2v5)
  p0 = float(packet_data_array[*].sat_rot)
  p1 = float(packet_data_array[*].ufsaxang)
  p2  = float(packet_data_array[*].ufsayang)
  p3  = float(packet_data_array[*].ufsbxang)
  p4  = float(packet_data_array[*].ufsbyang)
  p5  = float(packet_data_array[*].errangz)

end

pro eis_aocs1_reformatter::create_aocs1_status_bintable_extension, header, packet_data_array, pntrs
  self->trace, 'eis_aocs1_reformatter::create_aocs1_status_bintable_extension'

  self->unpack_aocs1_status_parameters, packet_data_array, p0, p1, p2, p3, p4, p5

  if self.padding then begin
     self->pad, p0, pntrs
     self->pad, p1, pntrs
     self->pad, p2, pntrs
     self->pad, p3, pntrs
     self->pad, p4, pntrs
     self->pad, p5, pntrs
  endif

  ; Create the column descriptions
  fxbaddcol, col, header, p0, 'SAT_ROT',  'Current Sequence Index',   tunit='None', tdmin=min(p0), tdmax=max(p0)
  fxbaddcol, col, header, p1, 'UFSAXANG', 'Current Sequence Pointer', tunit='None', tdmin=min(p1), tdmax=max(p1)
  fxbaddcol, col, header, p2, 'UFSAYANG', 'Current Linelist Index',   tunit='None', tdmin=min(p2), tdmax=max(p2)
  fxbaddcol, col, header, p3, 'UFSBXANG', 'Current Linelist Index',   tunit='None', tdmin=min(p3), tdmax=max(p3)
  fxbaddcol, col, header, p4, 'UFSBYANG', 'Current Linelist Index',   tunit='None', tdmin=min(p4), tdmax=max(p4)
  fxbaddcol, col, header, p5, 'ERRANGZ',  'Current Linelist Index',   tunit='None', tdmin=min(p5), tdmax=max(p5)

  ; Create the fits header
  self->create_fits_header, lu, self.fits_filename, header

  ; Write the columns data
  self->write_data, lu, p0, 1, 1, 'SAT_ROT'
  self->write_data, lu, p1, 2, 1, 'UFSAXANG'
  self->write_data, lu, p2, 3, 1, 'UFSAYANG'
  self->write_data, lu, p3, 4, 1, 'UFSBXANG'
  self->write_data, lu, p4, 5, 1, 'UFSBYANG'
  self->write_data, lu, p5, 6, 1, 'ERRANGZ'

  ; Finish up, close_fits_file disposes of lun
  self->close_fits_file, lu

end
