
pro eis_eismdp_reformatter::unpack_eismdp_status_parameters, packet_data_array, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15
  self->trace, 'eis_eismdp_reformatter::unpack_eismdp_status_parameters'

  ; p2v5 = self->pad_data(packet_data_array.p2v5)
  p0  = float(packet_data_array[*].cmd_eis_srq_cnt)
  p1  = float(packet_data_array[*].cmd_eis_dhu_cnt)
  p2  = float(packet_data_array[*].sts_eis_rp1_cnt)
  p3  = float(packet_data_array[*].sts_eis_rp2_cnt)
  p4  = float(packet_data_array[*].sts_eis_rp3_cnt)
  p5  = float(packet_data_array[*].sts_eis_rp4_cnt)
  p6  = float(packet_data_array[*].sts_eis_err)
  p7  = float(packet_data_array[*].sts_eis_rcv)
  p8  = float(packet_data_array[*].sts_eis_err_tim)
  p9  = float(packet_data_array[*].img_eis_busy)
  p10 = float(packet_data_array[*].img_eis_que_siz)
  p11 = float(packet_data_array[*].img_eis_rcv_cnt)
  p12 = float(packet_data_array[*].img_eis_rcv_siz)
  p13 = float(packet_data_array[*].eis_flr_flg)
  p14 = float(packet_data_array[*].eis_flr_loc_x)
  p15 = float(packet_data_array[*].eis_flr_loc_y)

end

pro eis_eismdp_reformatter::create_eismdp_status_bintable_extension, header, packet_data_array, pntrs
  self->trace, 'eis_eismdp_reformatter::create_eismdp_status_bintable_extension'

  self->unpack_eismdp_status_parameters, packet_data_array, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15

  if self.padding then begin
     self->pad, p0,  pntrs
     self->pad, p1,  pntrs
     self->pad, p2,  pntrs
     self->pad, p3,  pntrs
     self->pad, p4,  pntrs
     self->pad, p5,  pntrs
     self->pad, p6,  pntrs
     self->pad, p7,  pntrs
     self->pad, p8,  pntrs
     self->pad, p9,  pntrs
     self->pad, p10, pntrs
     self->pad, p11, pntrs
     self->pad, p12, pntrs
     self->pad, p13, pntrs
     self->pad, p14, pntrs
     self->pad, p15, pntrs
  endif

  ; Create the column descriptions
  fxbaddcol, col, header, p0,  'CMD_EIS_SRQ_CNT', 'Current Sequence Index',   tunit='None', tdmin=min(p0), tdmax=max(p0)
  fxbaddcol, col, header, p1,  'CMD_EIS_DHU_CNT', 'Current Sequence Pointer', tunit='None', tdmin=min(p1), tdmax=max(p1)
  fxbaddcol, col, header, p2,  'STS_EIS_RP1_CNT', 'Current Linelist Index',   tunit='None', tdmin=min(p2), tdmax=max(p2)
  fxbaddcol, col, header, p3,  'STS_EIS_RP2_CNT', 'Current Linelist Index',   tunit='None', tdmin=min(p3), tdmax=max(p3)
  fxbaddcol, col, header, p4,  'STS_EIS_RP3_CNT', 'Current Linelist Index',   tunit='None', tdmin=min(p4), tdmax=max(p4)
  fxbaddcol, col, header, p5,  'STS_EIS_RP4_CNT', 'Current Linelist Index',   tunit='None', tdmin=min(p5), tdmax=max(p5)
  fxbaddcol, col, header, p6,  'STS_EIS_ERR',     'Current Linelist Index',   tunit='None', tdmin=min(p5), tdmax=max(p5)
  fxbaddcol, col, header, p7,  'STS_EIS_RCV',     'Current Linelist Index',   tunit='None', tdmin=min(p5), tdmax=max(p5)
  fxbaddcol, col, header, p8,  'STS_EIS_ERR_TIM', 'Current Linelist Index',   tunit='None', tdmin=min(p5), tdmax=max(p5)
  fxbaddcol, col, header, p9,  'IMG_EIS_BUSY',    'Current Linelist Index',   tunit='None', tdmin=min(p5), tdmax=max(p5)
  fxbaddcol, col, header, p10, 'IMG_EIS_QUE_SIZ', 'Current Linelist Index',   tunit='None', tdmin=min(p5), tdmax=max(p5)
  fxbaddcol, col, header, p11, 'IMG_EIS_RCV_CNT', 'Current Linelist Index',   tunit='None', tdmin=min(p5), tdmax=max(p5)
  fxbaddcol, col, header, p12, 'IMG_EIS_RCV_SIZ', 'Current Linelist Index',   tunit='None', tdmin=min(p5), tdmax=max(p5)
  fxbaddcol, col, header, p13, 'EIS_FLR_FLG',     'Current Linelist Index',   tunit='None', tdmin=min(p5), tdmax=max(p5)
  fxbaddcol, col, header, p14, 'EIS_FLR_LOC_X',   'Current Linelist Index',   tunit='None', tdmin=min(p5), tdmax=max(p5)
  fxbaddcol, col, header, p15, 'EIS_FLR_LOC_Y',   'Current Linelist Index',   tunit='None', tdmin=min(p5), tdmax=max(p5)

  ; Create the fits header
  self->create_fits_header, lu, self.fits_filename, header

  ; Write the columns data
  self->write_data, lu, p0,   1, 1, 'CMD_EIS_SRQ_CNT'
  self->write_data, lu, p1,   2, 1, 'CMD_EIS_DHU_CNT'
  self->write_data, lu, p2,   3, 1, 'STS_EIS_RP1_CNT'
  self->write_data, lu, p3,   4, 1, 'STS_EIS_RP2_CNT'
  self->write_data, lu, p4,   5, 1, 'STS_EIS_RP3_CNT'
  self->write_data, lu, p5,   6, 1, 'STS_EIS_RP4_CNT'
  self->write_data, lu, p6,   7, 1, 'STS_EIS_ERR'
  self->write_data, lu, p7,   8, 1, 'STS_EIS_RCV'
  self->write_data, lu, p8,   9, 1, 'STS_EIS_ERR_TIM'
  self->write_data, lu, p9,  10, 1, 'IMG_EIS_BUSY'
  self->write_data, lu, p10, 11, 1, 'IMG_EIS_QUE_SIZ'
  self->write_data, lu, p11, 12, 1, 'IMG_EIS_RCV_CNT'
  self->write_data, lu, p12, 13, 1, 'IMG_EIS_RCV_SIZ'
  self->write_data, lu, p13, 14, 1, 'EIS_FLR_FLG'
  self->write_data, lu, p14, 15, 1, 'EIS_FLR_LOC_X'
  self->write_data, lu, p15, 16, 1, 'EIS_FLR_LOC_Y'

  ; Finish up, close_fits_file disposes of lun
  self->close_fits_file, lu

end
