
pro eis_hk1_reformatter::create_bintable_extension, extension_name, extension_comment, packet_data_array, pntrs
  self->trace, 'eis_hk1_reformatter::create_bintable_extension'

  if self->create_bintable_extension_header(extension_name, extension_comment, header) then begin

     self->add_primary_header_keywords, header

     case extension_name of
        'HK1 TEMPERATURES' : self->create_hk1_temperatures_bintable_extension, header, packet_data_array, pntrs
        'HK1 STATUS'       : self->create_hk1_status_bintable_extension,       header, packet_data_array, pntrs
        'HK1 MDP'          : self->create_hk1_mdp_bintable_extension,          header, packet_data_array, pntrs
        'SPACECRAFT'       : self->create_spacecraft_bintable_extension,       header, packet_data_array, pntrs
        else               : self->log, 'Unknown extension name: ' + extension_name
     endcase
     
  endif
  
end
