
pro eis_hk1_reformatter::unpack_hk1_mdp_parameters, packet_data_array, p0, p1, p2
  self->trace, 'eis_hk1_reformatter::unpack_hk1_mdp_parameters'

  ; p2v5 = self->pad_data(packet_data_array.p2v5)
  p0 = float(packet_data_array[*].dist_28v_volt)
  p1 = float(packet_data_array[*].dist_28v_cur)
  p2  = float(packet_data_array[*].eis_date_rate)

end

pro eis_hk1_reformatter::create_hk1_mdp_bintable_extension, header, packet_data_array, pntrs
  self->trace, 'eis_hk1_reformatter::create_hk1_mdp_bintable_extension'

  self->unpack_hk1_mdp_parameters, packet_data_array, p0, p1, p2

  if self.padding then begin
     self->pad, p0, pntrs
     self->pad, p1, pntrs
     self->pad, p2, pntrs
  endif

  ; Create the column descriptions
  fxbaddcol, col, header, p0, 'HK1_DIST_28V_VOLT', 'Current Sequence Index',   tunit='None', tdmin=min(p0), tdmax=max(p0)
  fxbaddcol, col, header, p1, 'HK1_DIST_28V_CUR',  'Current Sequence Pointer', tunit='None', tdmin=min(p1), tdmax=max(p1)
  fxbaddcol, col, header, p2, 'EIS_DATA_RATE',     'Current Linelist Index',   tunit='None', tdmin=min(p2), tdmax=max(p2)


  ; Create the fits header
  self->create_fits_header, lu, self.fits_filename, header

  ; Write the columns data
  self->write_data, lu, p0, 1, 1, 'HK1_DIST_28V_VOLT'
  self->write_data, lu, p1, 2, 1, 'HK1_DIST_28V_CUR'
  self->write_data, lu, p2, 3, 1, 'EIS_DATA_RATE'

  ; Finish up, close_fits_file disposes of lun
  self->close_fits_file, lu

end
