
pro eis_hk1_reformatter::unpack_hk1_status_parameters, packet_data_array, p0, p1, p2, p3
  self->trace, 'eis_hk1_reformatter::unpack_hk1_status_parameters'

  ; p2v5 = self->pad_data(packet_data_array.p2v5)
  p0 = float(packet_data_array[*].eis_on_off)
  p1 = float(packet_data_array[*].eis_a_htr_ed)
  p2  = float(packet_data_array[*].eis_b_htr_ed)
  p3  = float(packet_data_array[*].eis_c_htr_ed)

end

pro eis_hk1_reformatter::create_hk1_status_bintable_extension, header, packet_data_array, pntrs
  self->trace, 'eis_hk1_reformatter::create_hk1_status_bintable_extension'

  self->unpack_hk1_status_parameters, packet_data_array, p0, p1, p2, p3

  if self.padding then begin
     self->pad, p0, pntrs
     self->pad, p1, pntrs
     self->pad, p2, pntrs
     self->pad, p3, pntrs
  endif

  ; Create the column descriptions
  fxbaddcol, col, header, p0, 'HK1_EIS_ON_OFF',   'Current Sequence Index',   tunit='None', tdmin=min(p0), tdmax=max(p0)
  fxbaddcol, col, header, p1, 'HK1_EIS_A_HTR_ED', 'Current Sequence Pointer', tunit='None', tdmin=min(p1), tdmax=max(p1)
  fxbaddcol, col, header, p2, 'HK1_EIS_B_HTR_ED', 'Current Linelist Index',   tunit='None', tdmin=min(p2), tdmax=max(p2)
  fxbaddcol, col, header, p3, 'HK1_EIS_C_HTR_ED', 'Current Linelist Index',   tunit='None', tdmin=min(p3), tdmax=max(p3)

  ; Create the fits header
  self->create_fits_header, lu, self.fits_filename, header

  ; Write the columns data
  self->write_data, lu, p0, 1, 1, 'HK1_EIS_ON_OFF'
  self->write_data, lu, p1, 2, 1, 'HK1_EIS_A_HTR_ED'
  self->write_data, lu, p2, 3, 1, 'HK1_EIS_B_HTR_ED'
  self->write_data, lu, p3, 4, 1, 'HK1_EIS_C_HTR_ED'

  ; Finish up, close_fits_file disposes of lun
  self->close_fits_file, lu

end
