
pro eis_hk1_reformatter::unpack_hk1_temperatures_parameters, packet_data_array, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11
  self->trace, 'eis_hk1_reformatter::unpack_hk1_temperatures_parameters'

  ; p2v5 = self->pad_data(packet_data_array.p2v5)
  p0   = float(packet_data_array[*].eis_a_htr_temp)
  p1   = float(packet_data_array[*].eis_b_htr_temp)
  p2   = float(packet_data_array[*].eis_c_htr_temp)
  p3   = float(packet_data_array[*].eis_icu1_temp)
  p4   = float(packet_data_array[*].eis_icu2_temp)
  p5   = float(packet_data_array[*].eis_str1_temp)
  p6   = float(packet_data_array[*].eis_str2_temp)
  p7   = float(packet_data_array[*].eis_str3_temp)
  p8   = float(packet_data_array[*].eis_str4_temp)
  p9   = float(packet_data_array[*].eis_str5_temp)
  p10  = float(packet_data_array[*].eis_str6_temp)
  p11  = float(packet_data_array[*].eis_str7_temp)

end

pro eis_hk1_reformatter::create_hk1_temperatures_bintable_extension, header, packet_data_array, pntrs
  self->trace, 'eis_hk1_reformatter::self->create_hk1_temperatures_bintable_extension'

  self->unpack_hk1_temperatures_parameters, packet_data_array, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11

  if self.padding then begin
     self->pad, p0,  pntrs
     self->pad, p1,  pntrs
     self->pad, p2,  pntrs
     self->pad, p3,  pntrs
     self->pad, p4,  pntrs
     self->pad, p5,  pntrs
     self->pad, p6,  pntrs
     self->pad, p7,  pntrs
     self->pad, p8,  pntrs
     self->pad, p9,  pntrs
     self->pad, p10, pntrs
     self->pad, p11, pntrs
  endif

  ; Create the column descriptions
  fxbaddcol, col, header, p0,  'HK1_EIS_A_HTR_TMP', 'Current Sequence Index',   tunit='Degree C', tdmin=min(p0),  tdmax=max(p0)
  fxbaddcol, col, header, p1,  'HK1_EIS_B_HTR_TMP', 'Current Sequence Pointer', tunit='Degree C', tdmin=min(p1),  tdmax=max(p1)
  fxbaddcol, col, header, p2,  'HK1_EIS_C_HTR_TMP', 'Current Linelist Index',   tunit='Degree C', tdmin=min(p2),  tdmax=max(p2)

  fxbaddcol, col, header, p3,  'HK1_EIS_ICU_1_TEMP', 'Current Linelist Index',  tunit='Degree C', tdmin=min(p3),  tdmax=max(p3)
  fxbaddcol, col, header, p4,  'HK1_EIS_ICU_2_TEMP', 'Current Linelist Index',  tunit='Degree C', tdmin=min(p4),  tdmax=max(p4)

  fxbaddcol, col, header, p5,  'HK1_EIS_STR_1_TEMP', 'Current Linelist Index',  tunit='Degree C', tdmin=min(p5),  tdmax=max(p5)
  fxbaddcol, col, header, p6,  'HK1_EIS_STR_2_TEMP', 'Current Linelist Index',  tunit='Degree C', tdmin=min(p6),  tdmax=max(p6)
  fxbaddcol, col, header, p7,  'HK1_EIS_STR_3_TEMP', 'Current Linelist Index',  tunit='Degree C', tdmin=min(p7),  tdmax=max(p7)
  fxbaddcol, col, header, p8,  'HK1_EIS_STR_4_TEMP', 'Current Linelist Index',  tunit='Degree C', tdmin=min(p8),  tdmax=max(p8)
  fxbaddcol, col, header, p9,  'HK1_EIS_STR_5_TEMP', 'Current Linelist Index',  tunit='Degree C', tdmin=min(p9),  tdmax=max(p9)
  fxbaddcol, col, header, p10, 'HK1_EIS_STR_6_TEMP', 'Current Linelist Index',  tunit='Degree C', tdmin=min(p10), tdmax=max(p10)
  fxbaddcol, col, header, p11, 'HK1_EIS_STR_7_TEMP', 'Current Linelist Index',  tunit='Degree C', tdmin=min(p11), tdmax=max(p11)

  ; Create the fits header
  self->create_fits_header, lu, self.fits_filename, header

  ; Write the columns data
  self->write_data, lu, p0,  1,  1, 'HK1_EIS_A_HTR_TMP'
  self->write_data, lu, p1,  2,  1, 'HK1_EIS_B_HTR_TMP'
  self->write_data, lu, p2,  3,  1, 'HK1_EIS_C_HTR_TMP'

  self->write_data, lu, p3,  4,  1, 'HK1_EIS_ICU_1_TEMP'
  self->write_data, lu, p4,  5,  1, 'HK1_EIS_ICU_2_TEMP'

  self->write_data, lu, p5,  6,  1, 'HK1_EIS_STR_1_TEMP'
  self->write_data, lu, p6,  7,  1, 'HK1_EIS_STR_2_TEMP'
  self->write_data, lu, p7,  8,  1, 'HK1_EIS_STR_3_TEMP'
  self->write_data, lu, p8,  9,  1, 'HK1_EIS_STR_4_TEMP'
  self->write_data, lu, p9,  10, 1, 'HK1_EIS_STR_5_TEMP'
  self->write_data, lu, p10, 11, 1, 'HK1_EIS_STR_6_TEMP'
  self->write_data, lu, p11, 12, 1, 'HK1_EIS_STR_7_TEMP'

  ; Finish up, close_fits_file disposes of lun
  self->close_fits_file, lu

end
; eis_a_htr_temp : 0B, $ ; 223
; eis_b_htr_temp : 0B, $ ; 224
; eis_c_htr_temp : 0B, $ ; 225
; eis_icu1_temp  : 0B, $ ; 383
; eis_icu2_temp  : 0B, $ ; 384
; eis_str1_temp  : 0B, $ ; 385
; eis_str2_temp  : 0B, $ ; 386
; eis_str3_temp  : 0B, $ ; 387
; eis_str4_temp  : 0B, $ ; 388
; eis_str5_temp  : 0B, $ ; 389
; eis_str6_temp  : 0B, $ ; 390
; eis_str7_temp  : 0B, $ ; 391
