
pro eis_hk2_reformatter::unpack_hk2_status_parameters, packet_data_array, p0, p1, p2, p3, p4, p5
  self->trace, 'eis_hk2_reformatter::unpack_hk2_status_parameters'

  ; p2v5 = self->pad_data(packet_data_array.p2v5)
  p0 = float(packet_data_array[*].tr_mode)
  p1 = float(packet_data_array[*].ufsause)
  p2  = float(packet_data_array[*].ufsbuse)
  p3  = float(packet_data_array[*].sc_att_x)
  p4  = float(packet_data_array[*].sc_att_y)
  p5  = float(packet_data_array[*].sc_att_z)

end

pro eis_hk2_reformatter::create_hk2_status_bintable_extension, header, packet_data_array, pntrs
  self->trace, 'eis_hk2_reformatter::create_hk2_status_bintable_extension'

  self->unpack_hk2_status_parameters, packet_data_array, p0, p1, p2, p3, p4, p5

  if self.padding then begin
     self->pad, p0, pntrs
     self->pad, p1, pntrs
     self->pad, p2, pntrs
     self->pad, p3, pntrs
     self->pad, p4, pntrs
     self->pad, p5, pntrs
  endif

  ; Create the column descriptions
  fxbaddcol, col, header, p0, 'TR_MODE',  'Current Sequence Index',   tunit='None', tdmin=min(p0), tdmax=max(p0)
  fxbaddcol, col, header, p1, 'UFSAUSE',  'Current Sequence Pointer', tunit='None', tdmin=min(p1), tdmax=max(p1)
  fxbaddcol, col, header, p2, 'UFSBUSE',  'Current Linelist Index',   tunit='None', tdmin=min(p2), tdmax=max(p2)
  fxbaddcol, col, header, p3, 'SC_ATT_X', 'Current Linelist Index',   tunit='None', tdmin=min(p3), tdmax=max(p3)
  fxbaddcol, col, header, p4, 'SC_ATT_Y', 'Current Linelist Index',   tunit='None', tdmin=min(p4), tdmax=max(p4)
  fxbaddcol, col, header, p5, 'SC_ATT_Z', 'Current Linelist Index',   tunit='None', tdmin=min(p5), tdmax=max(p5)

  ; Create the fits header
  self->create_fits_header, lu, self.fits_filename, header

  ; Write the columns data
  self->write_data, lu, p0, 1, 1, 'TR_MODE'
  self->write_data, lu, p1, 2, 1, 'UFSAUSE'
  self->write_data, lu, p2, 3, 1, 'UFSBUSE'
  self->write_data, lu, p3, 4, 1, 'SC_ATT_X'
  self->write_data, lu, p4, 5, 1, 'SC_ATT_Y'
  self->write_data, lu, p5, 6, 1, 'SC_ATT_Z'

  ; Finish up, close_fits_file disposes of lun
  self->close_fits_file, lu

end
