
;pro eis_sts1_reformatter::create_bintable_extension, extension_name, extension_comment, packet_data_array, src, dest, lengths
pro eis_sts1_reformatter::create_bintable_extension, extension_name, extension_comment, packet_data_array, pntrs
  self->trace, 'eis_sts1_reformatter::create_bintable_extension'

  if self->create_bintable_extension_header(extension_name, extension_comment, header) then begin

     self->add_primary_header_keywords, header

     case extension_name of
        'ICU PSU VOLTAGES'         : self->create_icu_psu_voltages_bintable_extension,         header, packet_data_array, pntrs
        'ICU PSU CURRENTS'         : self->create_icu_psu_currents_bintable_extension,         header, packet_data_array, pntrs
        'ICU TEMPERATURES'         : self->create_icu_psu_temperatures_bintable_extension,     header, packet_data_array, pntrs
        'ICU MISC PARAMETERS'      : self->create_icu_misc_parameters_bintable_extension,      header, packet_data_array, pntrs
        'ICU STATUS PARAMETERS'    : self->create_icu_status_parameters_bintable_extension,    header, packet_data_array, pntrs
        'PSU STATUS PARAMETERS'    : self->create_psu_status_parameters_bintable_extension,    header, packet_data_array, pntrs
        'HM STATUS PARAMETERS'     : self->create_hm_status_parameters_bintable_extension,     header, packet_data_array, pntrs
        'ICU INTERFACE PARAMETERS' : self->create_icu_interface_parameters_bintable_extension, header, packet_data_array, pntrs
        'ICU ERROR PARAMETERS'     : self->create_icu_error_parameters_bintable_extension,     header, packet_data_array, pntrs
        'ICU COUNTER PARAMETERS'   : self->create_icu_counter_parameters_bintable_extension,   header, packet_data_array, pntrs
        'ICU SCIENCE PARAMETERS'   : self->create_icu_science_parameters_bintable_extension,   header, packet_data_array, pntrs
        'SPACECRAFT'               : self->create_spacecraft_bintable_extension,               header, packet_data_array, pntrs
        else                       : self->log, 'Unknown extension name: ' + extension_name
     endcase
     
  endif
  
end
