
pro eis_sts1_reformatter::unpack_hm_status_parameters, packet_data_array, p0, p1, p2, p3, p4, p5, p6, p7
  self->trace, 'eis_sts1_reformatter::unpack_hm_status_parameters'

  ; p2v5 = self->pad_data(packet_data_array.p2v5)
  p0 = float(packet_data_array[*].hm_ool)
  p1 = float(packet_data_array[*].psu_to and '0001'X)
  p2 = float(ishft((packet_data_array[*].psu_to and '0002'X), -1))
  p3 = float(ishft((packet_data_array[*].psu_to and '0004'X), -2))
  p4 = float(ishft((packet_data_array[*].psu_to and '0008'X), -3))
  p5 = float(ishft((packet_data_array[*].psu_to and '0010'X), -4))
  p6 = float(ishft((packet_data_array[*].psu_to and '0020'X), -5))
  p7 = float(ishft((packet_data_array[*].psu_to and '1FC0'X), -6))

end

pro eis_sts1_reformatter::create_hm_status_parameters_bintable_extension, header, packet_data_array, pntrs
	self->trace, 'eis_sts1_reformatter::create_hm_status_parameters_bintable_extension'

  self->unpack_hm_status_parameters, packet_data_array, p0, p1, p2, p3, p4, p5, p6, p7

  if self.padding then begin
     self->pad, p0, pntrs
     self->pad, p1, pntrs
     self->pad, p2, pntrs
     self->pad, p3, pntrs
     self->pad, p4, pntrs
     self->pad, p5, pntrs
     self->pad, p6, pntrs
     self->pad, p7, pntrs
  endif

  ; Create the column descriptions
  fxbaddcol, col, header, p0, 'HM_ALERT_OOL', 'Health Monitor alert. Parameter out of limit value', tunit='None', tdmin=min(p0), tdmax=max(p0)
  fxbaddcol, col, header, p1, 'HM_PSU_TO',    'PSU status to health monitor time-out',              tunit='None', tdmin=min(p1), tdmax=max(p1)
  fxbaddcol, col, header, p2, 'HM_CAM_TO',    'CAM status to health monitor time-out',              tunit='None', tdmin=min(p2), tdmax=max(p2)
  fxbaddcol, col, header, p3, 'HM_MHC_TO',    'MHC status to health monitor time-out',              tunit='None', tdmin=min(p3), tdmax=max(p3)
  fxbaddcol, col, header, p4, 'HM_PSU_OOL',   'PSU OOL error flag',                                 tunit='None', tdmin=min(p4), tdmax=max(p4)
  fxbaddcol, col, header, p5, 'HM_CAM_OOL',   'CAM OOL error flag',                                 tunit='None', tdmin=min(p5), tdmax=max(p5)
  fxbaddcol, col, header, p6, 'HM_MHC_OOL',   'MHC OOL error flag',                                 tunit='None', tdmin=min(p6), tdmax=max(p6)
  fxbaddcol, col, header, p7, 'HM_PARM_ID',   'Sub-system OOL parameter identifier',                tunit='None', tdmin=min(p7), tdmax=max(p7)

  ; Create the fits header
  self->create_fits_header, lu, self.fits_filename, header

  ; Write the columns data
  self->write_data, lu, p0, 1, 1, 'HM_ALERT_OOL'
  self->write_data, lu, p1, 2, 1, 'HM_PSU_TO'
  self->write_data, lu, p2, 3, 1, 'HM_CAM_TO'
  self->write_data, lu, p3, 4, 1, 'HM_MHC_TO'
  self->write_data, lu, p4, 5, 1, 'HM_PSU_OOL'
  self->write_data, lu, p5, 6, 1, 'HM_CAM_OOL'
  self->write_data, lu, p6, 7, 1, 'HM_MHC_OOL'
  self->write_data, lu, p7, 8, 1, 'HM_PARM_ID'

  ; Finish up, close_fits_file disposes of lun
  self->close_fits_file, lu

end
